<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class ResolvetransactiondtData2 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::transaction(function () {
            DB::table('transaction_dts')
                ->where(function($query) {
                    $query->whereNull('item_unit')
                          ->orWhere('item_unit', '');
                })
                ->orWhere(function($query) {
                    $query->whereNull('item_pack')
                          ->orWhere('item_pack', '');
                })
                ->orWhere(function($query) {
                    $query->whereNull('item_qtyPerPack')
                          ->orWhere('item_qtyPerPack', '')
                          ->orWhere('item_qtyPerPack', '0');
                })
                ->update([
                    'item_unit' => DB::raw("CASE WHEN item_unit IS NULL OR item_unit = '' THEN 'u' ELSE item_unit END"),
                    'item_pack' => DB::raw("CASE WHEN item_pack IS NULL OR item_pack = '' THEN '-' ELSE item_pack END"),
                    'item_qtyPerPack' => DB::raw("CASE WHEN item_qtyPerPack IS NULL OR item_qtyPerPack = '' OR item_qtyPerPack = '0' THEN '1' ELSE item_qtyPerPack END")

                ]);
        });

        DB::transaction(function () {
            DB::table('transactiondttmps')
                ->where(function($query) {
                    $query->whereNull('item_unit')
                          ->orWhere('item_unit', '');
                })
                ->orWhere(function($query) {
                    $query->whereNull('item_pack')
                          ->orWhere('item_pack', '');
                })
                ->orWhere(function($query) {
                    $query->whereNull('item_qtyPerPack')
                          ->orWhere('item_qtyPerPack', '')
                          ->orWhere('item_qtyPerPack', '0');
                })
                ->update([
                    'item_unit' => DB::raw("CASE WHEN item_unit IS NULL OR item_unit = '' THEN 'u' ELSE item_unit END"),
                    'item_pack' => DB::raw("CASE WHEN item_pack IS NULL OR item_pack = '' THEN '-' ELSE item_pack END"),
                    'item_qtyPerPack' => DB::raw("CASE WHEN item_qtyPerPack IS NULL OR item_qtyPerPack = '' OR item_qtyPerPack = '0' THEN '1' ELSE item_qtyPerPack END")
                ]);
        });

        DB::transaction(function () {
            DB::table('items')
                ->where(function($query) {
                    $query->whereNull('item_unit')
                          ->orWhere('item_unit', '');
                })
                ->orWhere(function($query) {
                    $query->whereNull('item_pack')
                          ->orWhere('item_pack', '');
                })
                ->orWhere(function($query) {
                    $query->whereNull('item_qtyPerPack')
                          ->orWhere('item_qtyPerPack', '')
                          ->orWhere('item_qtyPerPack', '0');
                })
                ->update([
                    'item_unit' => DB::raw("CASE WHEN item_unit IS NULL OR item_unit = '' THEN 'u' ELSE item_unit END"),
                    'item_pack' => DB::raw("CASE WHEN item_pack IS NULL OR item_pack = '' THEN '-' ELSE item_pack END"),
                    'item_qtyPerPack' => DB::raw("CASE WHEN item_qtyPerPack IS NULL OR item_qtyPerPack = '' OR item_qtyPerPack = '0' THEN '1' ELSE item_qtyPerPack END")
                ]);
        });
        DB::transaction(function () {
            DB::table('client_items')
                ->where(function($query) {
                    $query->whereNull('item_unit')
                          ->orWhere('item_unit', '');
                })
                ->orWhere(function($query) {
                    $query->whereNull('item_pack')
                          ->orWhere('item_pack', '');
                })
                ->orWhere(function($query) {
                    $query->whereNull('item_qtyPerPack')
                          ->orWhere('item_qtyPerPack', '')
                          ->orWhere('item_qtyPerPack', '0');
                })
                ->update([
                    'item_unit' => DB::raw("CASE WHEN item_unit IS NULL OR item_unit = '' THEN 'u' ELSE item_unit END"),
                    'item_pack' => DB::raw("CASE WHEN item_pack IS NULL OR item_pack = '' THEN '-' ELSE item_pack END"),
                    'item_qtyPerPack' => DB::raw("CASE WHEN item_qtyPerPack IS NULL OR item_qtyPerPack = '' OR item_qtyPerPack = '0' THEN '1' ELSE item_qtyPerPack END")
                ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
