<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClientSuppliersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('client_suppliers', function (Blueprint $table) {
            $table->bigIncrements('supplier_id');
            $table->string('supplier_name', 50);
            $table->string('supplier_contactPerson', 50)->nullable();
            $table->string('supplier_address', 50)->nullable();
            $table->integer('supplier_country')->index()->nullable();
            $table->string('supplier_phone', 20)->nullable();
            $table->string('supplier_email', 50);
            $table->integer('supplier_related_clientid');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('client_suppliers');
    }
}
