<?php

namespace App\Repositories\InternalTransfer;

use App\Models\transactiondttmp;
use App\Models\transactionDtSnTmp;
use App\Models\transactionDtsn;
use Illuminate\Support\Facades\DB;
use App\Models\GoodsIn\transactions as GoodsInTransactions;
use App\Models\transactionDt;
use App\Models\transactiontmp;
use App\Models\suppliers;
use App\Models\transactions;
use App\Models\clientItem;
use App\Models\clientSupplier;
use App\Models\location;
use App\Models\items;
use App\Models\country;
use Illuminate\Support\Facades\Log;

use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Http\Controllers\BackOffice\History\HistoryController;

use App\Interfaces\InternalTransfer;
use Exception;
use File;
use App;
use  App\Http\Dtos\GoodsIn\inputExcelDetailsDto;

use App\Http\Dtos\InternalTransfer\inputInternalDtTmpDto;
use App\Http\Controllers\BackOffice\Common\CommonServices;
use App\Http\Dtos\InternalTransfer\inputInternalTmpDto;
use  App\Http\Mappers\InternalTransfer\InputTmpMapper;
use  App\Http\Mappers\InternalTransfer\InputDtTmpMapper;
use  App\Http\Mappers\InternalTransfer\InputTmpOrigMapper;
use  App\Http\Mappers\GeneralMappers\OriginalToTmpDtMapper;
use  App\Http\Mappers\GeneralMappers\TmpToOriginalDtMapper;
use  App\Http\Mappers\GeneralMappers\TmpToOriginalMapper;

use App\Interfaces\InternalTransfer\InternalTransferInterface;

class InternalTransferRepository implements InternalTransferInterface
{
    protected $inputTmpMapper;
    protected $inputDtTmpMapper;
    protected $inputTmpOrigMapper;
    protected $originalToTmpDtMapper;
    protected $tmpToOriginalDtMapper;
    protected $tmpToOriginalMapper;



    public function __construct(
        InputTmpMapper $inputTmpMapper,
        InputDtTmpMapper $inputDtTmpMapper,
        InputTmpOrigMapper $inputTmpOrigMapper,
        OriginalToTmpDtMapper $originalToTmpDtMapper,
        TmpToOriginalDtMapper $tmpToOriginalDtMapper,
        TmpToOriginalMapper $tmpToOriginalMapper,

    ) {
        $this->inputTmpMapper = $inputTmpMapper;
        $this->inputDtTmpMapper = $inputDtTmpMapper;
        $this->inputTmpOrigMapper = $inputTmpOrigMapper;
        $this->originalToTmpDtMapper = $originalToTmpDtMapper;
        $this->tmpToOriginalDtMapper = $tmpToOriginalDtMapper;
        $this->tmpToOriginalMapper = $tmpToOriginalMapper;
    }

    public function storeTransactionDtTmp(inputInternalDtTmpDto $request)

    {

        $newTransactionDtTmp = null;
        $transactionTmpAfterUpdateEntry = transactiontmp::where('relatedTransferId', $request['transactionTmpId'])->first();
        $referenceData = transactionDt::where('transactiondt_id', $request['idReferenceDt'])->first();
        $compinedInput = $this->inputTmpOrigMapper->toArray($referenceData, $request);

        if ($compinedInput['transactiondttmp_id'] && $compinedInput['transactiondttmp_id'] > 0) {

            // $newTransactionDtTmp = transactiondttmp::where('reference_internal_dt', $compinedInput['transactiondttmp_id'])->first();
            transactiondttmp::where('transactiondttmp_id', $compinedInput['transactiondttmp_id'])
                ->update([
                    'item_quantity' => $compinedInput['item_quantity'],
                    'item_weight' => $compinedInput['item_weight'],
                    'gross_weight' => $compinedInput['item_weight'],
                    'total_gross_weight' => $compinedInput['item_quantity']* $compinedInput['item_weight'],
                    'total_weight' => $compinedInput['item_quantity']* $compinedInput['item_weight'],
                    'total_price' => $compinedInput['item_quantity']* $compinedInput['transactiondttmp_price'],
                ]);
            transactiondttmp::where('reference_internal_dt', $compinedInput['transactiondttmp_id'])
                ->update([
                    'item_quantity' => $compinedInput['item_quantity'],
                    'item_weight' => $compinedInput['item_weight'],
                    'gross_weight' => $compinedInput['item_weight'],
                    'total_gross_weight' => $compinedInput['item_quantity']* $compinedInput['item_weight'],
                    'total_weight' => $compinedInput['item_quantity']* $compinedInput['item_weight'],
                    'total_price' => $compinedInput['item_quantity']* $compinedInput['transactiondttmp_price'],
                ]);
            $newTransactionDtTmp = transactiondttmp::where('transactiondttmp_id', $compinedInput['transactiondttmp_id'])->first();
        } else {
            $newTransactionDtTmp = transactiondttmp::create($compinedInput);
            $compinedInput['dt_transaction_type'] = 'GOODS_IN';
            $compinedInput['id_reference_dt'] = null;
            $compinedInput['raw_in_grid'] = null;
            $compinedInput['reference_internal_dt']  = $newTransactionDtTmp->transactiondttmp_id;
            $compinedInput['client_id']  = $transactionTmpAfterUpdateEntry->transactiontmp_clientId;
            $compinedInput['transactiontmp_id']  = $transactionTmpAfterUpdateEntry->transactiontmp_id;
            $newTransactionDtTmp2 = transactiondttmp::create($compinedInput);
        }


        $transactionDetailsTmp = transactiondttmp::join('client_items', 'client_items.item_id', '=', 'transactiondttmps.item_id')
            ->leftjoin('client_suppliers', 'client_suppliers.supplier_id', '=', 'transactiondttmps.supplier_id')
            ->select(
                'client_items.item_barcode',
                'client_suppliers.supplier_name',
                'transactiondttmps.item_quantity',
                'transactiondttmps.supplier_invoice_number',
                'transactiondttmps.item_id',
                'transactiondttmps.supplier_id',
                'transactiontmp_id',
                'transactiondttmp_id',
                'client_items.item_code',
                'client_items.item_description',
                'transactiondttmps.transactiontmpdt_billOfEntry',
                'transactiondttmps.transactiondttmp_locationid',
                'transactiondttmps.transactiondttmp_countryOfOrigin',
                'client_items.item_hasSerial',
                'hscode',
                'transactiondttmps.transactiondttmp_price',
                'transactiondttmps.id_reference_dt',
                'transactiondttmps.raw_in_grid',
            )
            ->where([
                ['transactiontmp_id', '=', $request['transactionTmpId']]
            ])
            ->get();
        $data['transactionDetailsTmp'] = $transactionDetailsTmp;
        $data['transactionTmp'] = $newTransactionDtTmp;
        $data['transactionDt'] = $newTransactionDtTmp;
        return $data;
    }
}
