<?php

namespace App\Models;

use App\enums\NotificationTopics;
use Illuminate\Database\Eloquent\Model;

class notifications extends Model
{
    public $timestamps = false;
    protected $primaryKey = 'notification_id';
    protected $fillable = [
        'notification_title',
        'notification_description',
        'notification_seen',
        'notification_related_userid',
        'trans_id',
        'notification_code'
    ];

    const notificationTopics = array(
        NotificationTopics::GI_RECEIVED => array(
            'code' => NotificationTopics::GI_RECEIVED,
            'title_en' => 'GoodsIn Order',
            'title_ar' => 'GoodsIn Order',
            'message_en' => 'GoodsIn Items with Reference: {{_reference}} was created',
            'message_ar' => 'GoodsIn Items with Reference: {{_reference}} was created'
        ),
        NotificationTopics::DO_PREPARATION => array(
            'code' => NotificationTopics::DO_PREPARATION,
            'title_en' => 'Delivery Order',
            'title_ar' => 'Delivery Order',
            'message_en' => 'Delivery Items with Reference: {{_reference}} was created',
            'message_ar' => 'Delivery Items with Reference: {{_reference}} was created'

        ),
        NotificationTopics::DO_RELEASED => array(
            'code' => NotificationTopics::DO_RELEASED,
            'title_en' => 'Delivery Released',
            'title_ar' => 'Delivery Released',
            'message_en' => 'Delivery Items with Reference: {{_reference}} Released',
            'message_ar' => 'Delivery Items with Reference: {{_reference}} Released'

        ),
        NotificationTopics::DO_ARRIVED => array(
            'code' => NotificationTopics::DO_ARRIVED,
            'title_en' =>'Delivery Arrived',
            'title_ar' => 'Delivery Arrived',
            'message_en' => 'Delivery Items with Reference: {{_reference}} Arrived',
            'message_ar' => 'Delivery Items with Reference: {{_reference}} Arrived'

        ),
        NotificationTopics::TO_CREATED =>array(
            'code' => NotificationTopics::TO_CREATED,
            'title_en' =>'TO Created',
            'title_ar' => 'TO Created',
            'message_en' => 'TO Created with Reference: {{_reference}}',
            'message_ar' => 'TO Created with Reference: {{_reference}}'

        ),
    );
}
