<?php

namespace App\Http\Controllers\mobile\RMA;


use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\client;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use JWTAuth;

class RMAController extends ApiController
{
    public function fetchRMAINOrders(Request $request)
    {


        $user_id = JWTAuth::user()->id;
        $client_id = client::where('user_id', $user_id)->first()->client_id;

        $items = DB::table('transactions')
            ->join('client_customers', 'client_customers.customer_id', '=', 'transactions.clientCustomer_id')
            ->where([
                ['transaction_clientID', '=', $client_id],
                ['transaction_type', '=', 'RMA_IN'],
                ['transaction_mobileReference', '!=', null],
            ])
            ->get();
        foreach ($items as $subItems) {
            $subItems->transactionDt = DB::table('transaction_dts')
                ->join('client_items', 'client_items.item_id', '=', 'transaction_dts.item_id')
                ->where('transaction_dts.transaction_id', '=', $subItems->transaction_id)
                ->get();
        }
        return ApiController::successResponse($items, 200);
    }

    public function fetchPendingRMAINOrders(Request $request)
    {


        $user_id = JWTAuth::user()->id;
        $client_id = client::where('user_id', $user_id)->first()->client_id;

        $items = DB::table('transactiontmps')
            ->join('client_customers', 'client_customers.customer_id', '=', 'transactiontmps.clientCustomer_id')
            ->where([
                ['transactiontmp_clientId', '=', $client_id],
                ['transactiontmp_type', '=', 'RMA_IN'],
                ['transactiontmp_mobileReference', '!=', null],
                ['transactiontmp_reference', '=', null],
            ])
            ->get();
        foreach ($items as $subItems) {
            $subItems->transactiontmpDt = DB::table('transactiondttmps')
                ->join('client_items', 'client_items.item_id', '=', 'transactiondttmps.item_id')
                ->where('transactiondttmps.transactiontmp_id', '=', $subItems->transactiontmp_id)
                ->get();
        }
        return ApiController::successResponse($items, 200);
    }

    public function newRMAINTransaction(Request $request)
    {
        $user_id = JWTAuth::user()->id;
        $company_id = JWTAuth::user()->company_id;

        $validator = Validator::make($request->all(), [
            'transaction_date' => 'required',
            'clientCustomer_id' => 'required',


        ]);
        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }
        $client_id = client::where('user_id', $user_id)->first()->client_id;

        $sequence = DB::table('clients')
                ->where([
                    ['clients.client_id', '=', $client_id]
                ])
                ->max('client_rma_reference') + 1;


        $utilitiesController = new UtilitiesController();

        $newItem = DB::table('transactiontmps')
            ->insertGetId([
                // 'transaction_reference' => $sequence,

                'transactiontmp_mobileReference' => $sequence,

                'transactiontmp_date' => $utilitiesController->convertTodayToTimetsamp($request->transaction_date . "" . date('H:i:s')),
                'transactiontmp_type' => "RMA_IN",
                'transactiontmp_clientId' => $client_id,
                'transactiontmp_remark' => $request->transaction_remark,
                'clientCustomer_id' => $request->clientCustomer_id,
                'company_id' => $company_id

            ]);

        foreach ($request->transactiondt as $detailsdt) {

            foreach ($detailsdt['transactiondt_billOfEntry'] as $bills) {
                $newItemDetails = DB::table('transactiondttmps')
                    ->insertGetId([
                        'item_id' => $detailsdt['item_id'],
                        'item_quantity' => $bills['quantity'],
                        'transactiontmp_id' => $newItem,
                        'transactiontmpdt_billOfEntry' => $bills['bills'],
                    ]);

            }

        }

        // if($sequence ==1){
        //     sequence::where('sequence_transactionType','like','DO')->insert([
        //         'sequence_transactionRef' => "1",
        //         'branch_id' => "1",
        //         'sequence_transactionType' => $request->transactionType
        //     ]);
        // }else{
        //     sequence::where('sequence_transactionType','like','DO')->increment('sequence_transactionRef',1);
        // }
        $updateUser = DB::table('clients')
            ->where([
                ['clients.client_id', '=', $client_id]
            ])->increment('client_rma_reference', 1);
        // ->update([
        //     'client_delivery_reference'   => $sequence+1,
        // ]);
        if ($updateUser) {
            $admins = DB::table('users')
                ->where([
                    ["user_role_id", 1],
                    ["company_id", $company_id]
                ])
                ->get();
            foreach ($admins as $admindt) {

                if ($admindt->user_pushToken) {
                    $utilitiesController->sendNotification('RMA Order', 'New RMA Order was created', $admindt->user_pushToken, $admindt->id, '');
                }

            }
            return ApiController::successResponse("success", 200);
        }

        return ApiController::errorResponse($updateUser, 422);


        return ApiController::successResponse($newItem, 200);

    }


    public function fetchRMAINItems(Request $request)
    {


        $user_id = JWTAuth::user()->id;
        $client_id = client::where('user_id', $user_id)->first()->client_id;

        $items = DB::table('client_items')
            ->where('item_related_client_id', $client_id)
            ->get();

        return ApiController::successResponse($items, 200);
    }
}
