<?php

namespace App\Http\Controllers\BackOffice\Transactions;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\Transactions\input\TransactionSearchRequest;
use App\Http\Controllers\BackOffice\Transactions\TransactionService;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\Localization;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use PDF;

class TransactionController extends ApiController
{

    public function fetchTransactions(TransactionSearchRequest $request)
    {
        $service = new TransactionService();
        return $service->fetchTransactions($request);
    }


    public function transactionsPdf(Request $request)
    {
        $UtilitiesController = new UtilitiesController();
        $requestData = $UtilitiesController->decipherRequest($request->transactionDataId);
        if (!$requestData) {
            return 'unreachable url found';
        }
        $requestData = json_decode($requestData);
        $requestData = $requestData->info;
        $transactionSearchRequest = new TransactionSearchRequest();
        $transactionSearchRequest->merge([
            'fromDate' => $requestData->fromDate ?? null,
            'toDate' => $requestData->toDate ?? null,
            'clientId' => $requestData->clientId ?? null,
            'type' => $requestData->type ?? [],
            'hasFiles' => $requestData->hasFiles ?? 0,
            'language'=>$requestData->language
        ]);
        $service = new TransactionService();
        return $service->transactionsPdf($transactionSearchRequest);
    }
}
