<?php

namespace App\Http\Controllers\BackOffice\Reports;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\Localization;
use App\Models\tansactionDataPdf;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use JWTAuth;
use PDF;
use Illuminate\Support\Facades\Log;


class GoodsInReportsController extends ApiController
{
    public function getDataDropDown(Request $request)
    {
        $company_id = JWTAuth::user()->company_id;
        $UtilitiesController = new UtilitiesController();

        $dateFromTimeStamp = $UtilitiesController->convertTodayToTimetsamp($request->transactionFromDate . "00:00:00");
        $dateToTimeStamp = $UtilitiesController->convertTodayToTimetsamp($request->transactionToDate . "23:59:59");

        $utilities['billOfEntry'] = DB::table('transactions')
            ->join('client_suppliers', 'client_suppliers.supplier_id', 'transactions.transaction_supplierId')
            ->where([
                ['transactions.company_id', '=', $company_id],
                ['transactions.transaction_type', '=', 'GOODS_IN']
            ])
            ->wherebetween('transaction_date', [$dateFromTimeStamp, $dateToTimeStamp])
            ->select(
                'transaction_billOfEntry',
                'transaction_clientId',
                'transaction_supplierId',
                DB::raw("
        FROM_UNIXTIME(transaction_date,'%d-%m-%Y') as transaction_date")
            )
            ->groupby('transaction_billOfEntry', 'transaction_clientId', 'transaction_supplierId')
            ->get();


        $utilities['suppliers'] = DB::table('client_suppliers')
            ->groupBy('supplier_id')
            ->get();

        return ApiController::successResponse($utilities, 200);
    }








    public function goodsInPdf(Request $request)
    {

        $UtilitiesController = new UtilitiesController();
        $requestData = $UtilitiesController->decipherRequest($request->transactionDataId);

        if (!$requestData) {
            return 'unreachable url found';
        }

        ini_set('max_execution_time', '50000');
        ini_set("pcre.backtrack_limit", "5000000000");
        ini_set('memory_limit', '200048M');


        $requestData = json_decode($requestData);

        $requestData = $requestData->info;
        $transactionFromDate = $requestData->transactionFromDate;
        $currencyBase = $requestData->currencyBase;
        $currency = $requestData->currency;
        $hscode = $requestData->hscode;


        $language = $requestData->language;

        $transactionToDate = $requestData->transactionToDate;
        $navigationType = $requestData->navigationType;
        $clientId = $requestData->clientId;
        $supplierId = $requestData->supplierId;
        $transactionBillOfEntry = $requestData->transactionBillOfEntry;
        $withDt = $requestData->withDt;
        $company = DB::table('companies')->first();
        $company_id = $company->company_id;
        $company_logo = $company->company_logo;
        $currencyCode = DB::table('companies')
            ->leftjoin('currency', 'currency.currency_id', '=', 'companies.currency')
            ->where('company_id', $company_id)
            ->first();
        // $company_id = JWTAuth::user()->company_id;
        $UtilitiesController = new UtilitiesController();
        $transactionFromDate = $UtilitiesController->convertTodayToTimetsamp($transactionFromDate . "" . "00:00:00");
        $transactionToDate = $UtilitiesController->convertTodayToTimetsamp($transactionToDate . "" . "23:59:59");

        $delivery = $this->getReporstsDataGoodsIn(collect($requestData));

        $moduleKeys = Localization::moduleKeys; // Assuming this is an array of keys

        $Obj['goodsIn'] =  $delivery['data'];
        $Obj['currencyBase'] = $currencyBase;
        $Obj['currency'] = $currency;
        $Obj['hscode'] = $hscode;


        $Obj['currencyCode'] = $currencyCode->currency_code;


        $Obj['company'] = DB::table('companies')->first();
        $Obj['company_id'] = $company_id;
        $Obj['navigationType'] = $navigationType == 'GOODS_IN' ? 'GOODS IN' : 'RMA IN';
        $Obj['title'] = $navigationType == 'GOODS_IN' ? 'goodsInPdf' : 'rmaInPdf';
        $Obj['company_logo'] = $company_logo;


        $Obj['language'] = $requestData->language;
        $Obj['moduleKeys'] = $moduleKeys;
        $Obj['isShipment'] = $Obj['company']->company_onlyShipment;
        $pdf = PDF::loadView('goodsInReport', $Obj);


        return $pdf->stream('goodsIn.pdf');
    }




















    public function getDeliveryDataExcelGoodsIn(Request $request)
    {

        $UtilitiesController = new UtilitiesController();
        $requestData = $UtilitiesController->decipherRequest($request->transactionDataId);
        if (!$requestData) {
            return 'unreachable url found';
        }


        $requestData = json_decode($requestData);
        $requestData = $requestData->info;
        $transactionFromDate = $requestData->transactionFromDate;
        $transactionToDate = $requestData->transactionToDate;
        $currencyBase = $requestData->currencyBase;
        $currency = $requestData->currency;

        $company = DB::table('companies')->first();
        $company_id = $company->company_id;
        $currencyCode = DB::table('companies')
            ->leftjoin('currency', 'currency.currency_id', '=', 'companies.currency')
            ->where('company_id', $company_id)
            ->first();

        $company_logo = $company->company_logo;
        $transactionFromDate = $UtilitiesController->convertTodayToTimetsamp($transactionFromDate . "" . "00:00:00");
        $transactionToDate = $UtilitiesController->convertTodayToTimetsamp($transactionToDate . "" . "23:59:59");

        $delivery = $this->getReporstsDataGoodsIn(collect($requestData));


        //$deleteGroups = tansactionDataPdf::where('transactionData_id','=',$request->transactionDataId)->delete();
        $Obj['delivery'] = $delivery['data'];
        $Obj['company_id'] = $company_id;
        $Obj['company_logo'] = $company_logo;
        // return  $Obj;

        // Config('pdf' , $bannerinfo);
        $Obj['company'] = DB::table('companies')->first();
        $Obj['currencyBase'] = $currencyBase;
        $Obj['currency'] = $currency;

        $Obj['currencyCode'] = $currencyCode->currency_code;
        $Obj['totalForInvoice'] = $delivery['totalForInvoice'];
        $Obj['totalForInvoiceBase'] = $delivery['totalForInvoiceBase'];
        $Obj['totalWithCurrency'] = $delivery['totalWithCurrency'];



        return ApiController::successResponse($Obj, 200);
    }




    public function getGooodsInData(Request $request)
    {
        $company_id = JWTAuth::user()->company_id;

        $delivery = $this->getReporstsDataGoodsIn($request->all());


        //$deleteGroups = tansactionDataPdf::where('transactionData_id','=',$request->transactionDataId)->delete();
        $Obj['delivery'] = $delivery['data'];
        $Obj['company_id'] = $company_id;
        // return  $Obj;

        // Config('pdf' , $bannerinfo);
        $Obj['company'] = DB::table('companies')->first();
        $Obj['totalForInvoice'] = $delivery['totalForInvoice'];
        $Obj['totalForInvoiceBase'] = $delivery['totalForInvoiceBase'];
        $Obj['totalWithCurrency'] = $delivery['totalWithCurrency'];



        return ApiController::successResponse($delivery['data'], 200);
    }


    public function getReporstsDataGoodsIn($requestData)
    {
        $transactionFromDate = $requestData['transactionFromDate'];
        $transactionToDate = $requestData['transactionToDate'];
        // $language = $requestData['language'];
        $clientId = $requestData['clientId'];
        $reference = isset($requestData['reference']) ? $requestData['reference'] : null;
        $withDt = $requestData['withDt'];
        $currencyBase = $requestData['currencyBase'];
        $currency = $requestData['currency'];
        $transactionBillOfEntry = $requestData['transactionBillOfEntry'];
        $supplierId = $requestData['supplierId'];


        $company = DB::table('companies')->first();
        $company_id = $company->company_id;
        $currencyCode = DB::table('companies')
            ->leftjoin('currency', 'currency.currency_id', '=', 'companies.currency')
            ->where('company_id', $company_id)
            ->first();
        $UtilitiesController = new UtilitiesController();

        $company_logo = $company->company_logo;
        $transactionFromDate = $UtilitiesController->convertTodayToTimetsamp($transactionFromDate . "" . "00:00:00");
        $transactionToDate = $UtilitiesController->convertTodayToTimetsamp($transactionToDate . "" . "23:59:59");
        $delivery = DB::table('transactions')
            ->where([
                ['transactions.company_id', '=', $company_id],
                ['transactions.transaction_type', '=', 'GOODS_IN'],
                ['transactions.transaction_date', '>', $transactionFromDate],
                ['transactions.transaction_date', '<', $transactionToDate],
            ])
            ->join('clients', 'clients.client_id', '=', 'transactions.transaction_clientId')
            ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactions.forwarder_id')
            ->leftjoin('currency', 'currency.currency_id', 'transactions.transaction_currencyId')
            ->leftjoin('set_ups as typeOfDelivery', 'typeOfDelivery.setup_id', '=', 'transactions.transaction_typeOfDeliveryId')
            ->leftjoin('set_ups as customBillTypeId', 'customBillTypeId.setup_id', '=', 'transactions.transaction_customBillTypeId')
            ->leftjoin('payment_methods as paymentMethodId', 'paymentMethodId.id', '=', 'transactions.transaction_paymentMethodId')
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactions.clientCustomer_id')
            ->leftjoin('suppliers', 'suppliers.supplier_id', '=', 'transactions.transaction_supplierId');

        if ($clientId && $clientId != 'all') {
            $delivery->where([
                ['transactions.transaction_clientId', $clientId]
            ]);
        }

        if ($transactionBillOfEntry) {
            $delivery->where([
                ['transactions.transaction_billOfEntry', $transactionBillOfEntry]
            ]);
        }
        if ($supplierId && $supplierId != 'all') {
            $delivery->where([
                ['transactions.transaction_supplierId', $supplierId]
            ]);
        }
        if ($reference) {
            $delivery->where([
                ['transactions.transaction_reference', $reference]
            ]);
        }
        $delivery = $delivery->select(
            'transaction_id',
            'transaction_date',
            'transaction_reference',
            'transaction_supplierInvoice',
            'supplier_name',
            'client_firstname',
            'transaction_remark',
            'transaction_billOfEntry',
            'client_customers.customer_name',
            'typeOfDelivery.setup_value as typeOfDelivery',
            'customBillTypeId.setup_value as customBillTypeId',
            'transaction_released_DEC as OutboundBOE',
            'paymentMethodId.name as paymentMethodId',
            'transactions.transaction_destinationPoint',
            'currency_code as currencyCode'
        )
            ->selectRaw(DB::raw(" FROM_UNIXTIME(transaction_date, '%d-%m-%Y') AS transaction_date"))

            ->get();


        $totalForInvoice = 0;
        $totalForInvoiceBase = 0;
        $totalWithCurrency = array();
        $totalWithCurrencyBase = array();

        foreach ($delivery as $deliveryFor) {
            if (!isset($totalWithCurrency[$deliveryFor->currencyCode])) {
                $totalWithCurrency[$deliveryFor->currencyCode] = 0;
            }
            if ($withDt == 'withDtetails') {
                $goodsInDt = DB::table('transaction_dts')
                    ->leftjoin('items', 'items.item_id', '=', 'transaction_dts.item_id')
                    ->join('clients', 'clients.client_id', '=', 'transaction_dts.client_id')
                    ->leftjoin('countries', 'countries.country_id', 'transaction_dts.transactiondt_countryOfOrigin')
                    ->leftjoin('locations', 'locations.location_id', 'transaction_dts.transactiondt_locationid')
                    ->leftjoin('transactions', 'transactions.transaction_id', 'transaction_dts.transaction_id')
                    ->leftjoin('currency', 'currency.currency_id', 'transactions.transaction_currencyId')
                    ->where('transaction_dts.transaction_id', '=', $deliveryFor->transaction_id)
                    ->select(
                        'transaction_dts.*',
                        'items.item_code',
                        'items.item_description',
                        'clients.*',
                        'countries.*',
                        'locations.*',
                        'currency_code'
                    )     
                    ->selectRaw('Format(transaction_dts.transactiondt_price,4) as transactiondt_priceFormated',)

                    
                    ->selectRaw('Format(transaction_dts.transactiondt_priceBase,4) as transactiondt_priceBaseFormated')
                    ->addselect(DB::raw('concat(transactiondt_price, " ", currency_code) as currencyPrice'))
                    ->addselect(DB::raw('concat(transactiondt_priceBase, " ", "' . $currencyCode->currency_code . '") as currencyCompanyPrice'))
                    ->get();
                $deliveryFor->goodsInDt = $goodsInDt;
            }


            $sumDt = DB::table('transaction_dts')
                ->where('transaction_dts.transaction_id', '=', $deliveryFor->transaction_id)
                ->select(
                    'transaction_dts.transactiondt_price',
                    'item_quantity',
                )
                ->selectRaw('SUM(transaction_dts.item_quantity * transactiondt_price) as totalAmount')
                ->selectRaw('SUM(transaction_dts.item_quantity * transactiondt_priceBase) as totalAmountBase')
                ->first();
            $deliveryFor->sumDTotal = number_format($sumDt->totalAmount,4);
            $deliveryFor->sumDTotalBase =number_format($sumDt->totalAmountBase , 4) ;
            $totalWithCurrency[$deliveryFor->currencyCode] = $totalWithCurrency[$deliveryFor->currencyCode] + $sumDt->totalAmount;
            $totalForInvoice = $totalForInvoice + $sumDt->totalAmount;
            $totalForInvoiceBase = $totalForInvoiceBase + $sumDt->totalAmountBase;
        }
        $total = array();
        foreach ($totalWithCurrency as $currency => $amount) {
            $sum = array();
            $sum['currency'] = $currency;
            $sum['amount'] = number_format($amount , 4);
            array_push($total, $sum);
        }

        $Obj = array();
        $Obj['totalForInvoice'] = $totalForInvoice;
        $Obj['totalForInvoiceBase'] = $totalForInvoiceBase;
        $Obj['data'] = $delivery;
        $Obj['totalWithCurrency'] = $total;

        return $Obj;
    }
}
