<?php

namespace App\Http\Controllers\BackOffice\Locations;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\History\HistoryController;
use App\Models\location;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use JWTAuth;

class LocationsController extends ApiController
{
    public function fetchLocation(Request $request)
    {
        $locations = DB::table('locations')
            ->orderBy('location_name')
            ->get();
        return ApiController::successResponse($locations, 200);
    }

    public function removeLocation(Request $request)
    {
        $location = location::where('location_id', '=', $request->locationId)
            ->first();
        $historyController = new HistoryController();
        $deletedLocation = $location->toArray();
        $deletedLocation['location_id'] = $request->locationId;
        $deletedLocation['user_modified'] = auth()->user()->id;
        $historyController->insertHistoryData('locations', $deletedLocation, 'Delete');
        $removeLocation = DB::table('locations')
            ->where('location_id', '=', $request->locationId)->delete();
        return ApiController::successResponse($removeLocation, 200);
    }


    public function insertLocation(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'locationName' => 'required',
            'locationCbm' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }

        $location = array(
            'location_name' => $request->locationName,
            'location_cbm' => $request->locationCbm
        );
        $newLocation = location::create($location);
        if ($newLocation) {
            $location['location_id'] = $newLocation->id;
            $location['user_modified'] = auth()->user()->id;
            $historyController = new HistoryController();
            $historyController->insertHistoryData('locations', $location, 'Insert');
            return ApiController::successResponse($newLocation, 200);
        }
        return ApiController::errorResponse($validator->errors(), 422);

    }


    public function updateLocation(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'locationName' => 'required',
            'locationCbm' => 'required'
        ]);

        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }
        $location = array(
            'location_name' => $request->locationName,
            'location_cbm' => $request->locationCbm
        );

        $updateLocation = location::where('location_id', $request->locationId)->update($location);

        if ($updateLocation) {
            $location['location_id'] = $request->locationId;
            $location['user_modified'] = auth()->user()->id;
            $historyController = new HistoryController();
            $historyController->insertHistoryData('locations', $location, 'Update');
            return ApiController::successResponse($updateLocation, 200);
        }
        return ApiController::errorResponse('no update', 200);
    }
}
