<?php

namespace App\Console\Commands;

use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class TestCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:updatePlan';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        echo "Operation start\n";
        $date = date('Y-m-d');

        $utilitiesController = new UtilitiesController();
        $date = $utilitiesController->convertTodayToTimetsamp($date . "00:00:00");
        DB::table('client_storage_rent')
            ->where([
                ['date_to', '<', $date],
                ['date_to', '!=', '0']
            ])
            ->update([
                'active' => false,
            ]);

        //    $this->info('Item inserted successfully.'.$date);
        echo "Operation end\n";
        return 0;
    }
}
