<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('items', function (Blueprint $table) {
            $table->bigInteger('item_id');
            $table->string('item_code');
            $table->string('item_description')->nullable();
            $table->string('item_barcode')->nullable();
            $table->boolean('item_hasSerial')->default(false);
            $table->string('item_hscode')->nullable();
            $table->string('item_qtyPerPack')->nullable();
            $table->string('item_weight')->nullable();
            $table->string('item_pack')->nullable();
            $table->boolean('item_isActive')->default(true);
            $table->string('item_unit', 50);
            $table->bigInteger('group_id')->nullable();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('items');
    }
}
