<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCurrencyTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('currency', function (Blueprint $table) {
            $table->bigIncrements('currency_id');
            $table->string('currency_name');
            $table->string('currency_code');

        });

        DB::table('currency')->insert(
            [
                [
                    "currency_name" => "USD",
                    "currency_code" => "$",
                ],
                [
                    "currency_name" => "EUR",
                    "currency_code" => "€",
                ],
                [
                    "currency_name" => "LBP",
                    "currency_code" => "LBP",
                ],
            ]
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('currency');
    }
}
