<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateTransactionTmps extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('transactiontmps', function (Blueprint $table) {
            $table->bigInteger('clientCustomer_id')->nullable();
            $table->bigInteger('forwarder_id')->index()->nullable();
            $table->string('transactiontmp_driverName', 32)->nullable();
            $table->string('transactiontmp_vehicleNumber', 32)->nullable();
            $table->string('transactiontmp_exitPoint', 32)->nullable();
            $table->string('transactiontmp_destinationPoint', 32)->nullable();
            $table->bigInteger('company_id')->index()->nullable();
            $table->bigInteger('transactiontmp_paymentMethodId')->index()->nullable();
            $table->bigInteger('transactiontmp_customBillTypeId')->index()->nullable();
            $table->bigInteger('transactiontmp_currencyId')->index()->nullable();
            $table->bigInteger('transactiontmp_shipmentTypeId')->index()->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('transactiontmps', function (Blueprint $table) {
            //
        });
    }
}
