<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransactionDtSnTmpsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transaction_dt_sn_tmps', function (Blueprint $table) {
            $table->bigIncrements('transactiondtsntmp_id');
            $table->bigInteger('transactiondttmp_id')->unsigned();
            $table->string('transaction_item_serial', 50);
            $table->string('file_name', 50)->nullable();
            $table->bigInteger('item_id');
            $table->foreign('transactiondttmp_id')->references('transactiondttmp_id')->on('transactiondttmps')->onDelete('CASCADE');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transaction_dt_sn_tmps');
    }
}
