<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSequencesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sequences', function (Blueprint $table) {
            $table->bigIncrements('sequence_id');
            $table->bigInteger('branch_id');
            $table->string('sequence_transactionType', 20);
            $table->bigInteger('sequence_transactionRef');
        });

        DB::table('sequences')->insert(
            [

                [
                    "branch_id" => 1,
                    "sequence_transactionType" => "GOODS_IN",
                    "sequence_transactionRef" => 14

                ],
                [
                    "branch_id" => 1,
                    "sequence_transactionType" => "RMA_IN",
                    "sequence_transactionRef" => 92

                ],
                [
                    "branch_id" => 1,
                    "sequence_transactionType" => "DO",
                    "sequence_transactionRef" => 1106

                ],
                [
                    "branch_id" => 1,
                    "sequence_transactionType" => "RMA_OUT",
                    "sequence_transactionRef" => 1

                ],
            ]
        );


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sequences');
    }
}
