<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClientShipmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('client_shipments', function (Blueprint $table) {
            $table->bigIncrements('shipment_id');
            $table->bigInteger('shipment_transfer'); // inward / outward
            $table->bigInteger('shipment_type'); // air / sea
            $table->bigInteger('shipment_related_clientid');
            $table->string('shipment_creation_date');
            $table->boolean('isActive')->default(true);


        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('client_shipments');
    }
}
