<?php

namespace App\Http\Controllers\mobile\Users;

use App\Http\Controllers\ApiController;
use App\Models\user;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use JWTAuth;

class UserController extends ApiController
{


    public function refreshToken(Request $request)
    {
        return $this->respondWithToken(auth()->refresh());


        //  $token = JWTAuth::refresh($request->access_token);

    }

    protected function respondWithToken($token)
    {
        return response()->json([
            'access_token' => $token,
            'token_type' => 'bearer',
            'expires_in' => auth()->factory()->getTTL() * 180
        ]);
    }

    public function signIn(Request $request)
    {


        $validator = Validator::make($request->all(), [
            'user_name' => 'required',
            'password' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        if (!$token = auth()->attempt($validator->validated())) {
            return ApiController::errorResponse('Wrong username or password !', 401);
        }
        $userInfo = DB::table('users')
            ->leftjoin("clients", "clients.user_id", "=", "users.id")
            ->leftjoin("countries", "countries.country_id", "=", "clients.client_country")
            ->where([
                ['users.user_name', 'like', $request->user_name],
            ])
            ->first();
        if ($userInfo) {
            $updateUser = DB::table('users')
                ->where([
                    ['users.id', '=', $userInfo->id]
                ])
                ->update([
                    'user_pushToken' => $request->notificationToken,
                ]);


            return ApiController::successResponse(([
                'access_token' => $token,
                'token_type' => 'bearer',
                'expires_in' => auth()->factory()->getTTL() * 180,
                'data' => $userInfo
            ]), 200);
        }
        return ApiController::errorResponse('Wrong username or password !', 401);
    }

    public function testUserModel(Request $request)
    {
        // JWTAuth::parseToken();
        // return response()->json([ 'valid' => auth()->check() ]);
        // $user = JWTAuth::getToken();
        // return ApiController::successResponse($user,200);
        // // and you can continue to chain methods
        // $user = JWTAuth::parseToken()->authenticate();

        // return ApiController::successResponse($user,200);

    }

    public function logout()
    {
        auth()->logout();
        return response()->json(['message' => 'User successfully signed out']);
    }

    public function updateUserInfo(Request $request)
    {

        $user_id = JWTAuth::user()->id;


        $validator = Validator::make($request->all(), [
            'client_address' => 'required',
            'client_firstname' => 'required',
            'client_lastname' => 'required',
            'client_contact' => 'required',
            'client_phone' => 'required',
            'client_email' => 'required',
            'client_phone_code' => 'required',
            'user_id' => 'required',
        ]);


        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }


        $updateUser = DB::table('clients')
            ->where([
                ['user_id', $user_id]
            ])
            ->update([
                'client_address' => $request->client_address,
                'client_firstname' => $request->client_firstname,
                'client_lastname' => $request->client_lastname,
                'client_contact' => $request->client_contact,
                'client_phone' => $request->client_phone,
                'client_phone_code' => $request->client_phone_code,
                'client_email' => $request->client_email,

            ]);
        if ($updateUser) {
            return ApiController::successResponse("success", 200);
        }

        return ApiController::errorResponse($updateUser, 422);
    }

    public function reset_password(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required',
        ]);
        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }

        $userNameExist = DB::table('clients')
            ->where([
                ['clients.client_email', 'like', $request->email]
            ])
            ->first();

        if (!$userNameExist) {
            return ApiController::successResponse("success", 200);
        }
        $random_number = rand(10000, 99999);
        $u = DB::table('users')
            ->join("clients", "clients.user_id", "=", "users.id")
            ->where([
                ['clients.client_email', 'like', $request->email]
            ])
            ->update([
                'users.user_token' => $random_number,
            ]);


        Mail::send([], [], function ($message) use ($random_number, $request) {
            $message->to($request->email)
                ->subject("Verification Code")
                ->setBody($random_number);
        });
        return ApiController::successResponse("success", 200);
    }

    public function register(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|between:2,100',
            'email' => 'required|string|email|max:100|unique:users',
            'password' => 'required|string|confirmed|min:6',
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors()->toJson(), 400);
        }
        $user = User::create(array_merge(
            $validator->validated(),
            ['password' => bcrypt($request->password)]
        ));
        return response()->json([
            'message' => 'User successfully registered',
            'user' => $user
        ], 201);
    }

    public function new_password(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required',
            'verification_code' => 'required',
            'new_password' => 'required',
        ]);
        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }
        $verified = DB::table('users')
            ->where([
                ['users.user_token', 'like', $request->verification_code]
            ])
            ->first();
        if ($verified) {
            $updateUser = DB::table('users')
                ->join("clients", "clients.user_id", "=", "users.id")
                ->where([
                    ['clients.client_email', '=', $request->email]
                ])
                ->update([
                    'users.password' => bcrypt($request->new_password),
                ]);
            if ($updateUser) {
                return ApiController::successResponse("success", 200);
            }


            return ApiController::errorResponse("Invalid password", 422);
        }
        return ApiController::errorResponse("wrong verification code", 409);
    }

    public function changeClientPassword(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'currentPassword' => 'required',
            'newPassword' => 'required',
        ]);

        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }

        if (Hash::check($request->currentPassword, auth()->user()->password)) {
            $resetPassword = DB::table('users')
                ->where([
                    ['id', '=', auth()->user()->id]
                ])
                ->update([
                    'password' => bcrypt($request->newPassword),
                ]);

            return ApiController::successResponse($resetPassword, 200);
        }


        return ApiController::errorResponse("passwordNotFound", 409);
    }

    public function fetchCountries(Request $request)
    {
        $utilities = array();

        $language=$request->header('language');
        $user_id = JWTAuth::user()->id;

        DB::table('users')
        ->where('id',$user_id)
        ->update([
            'language'=>$language
        ]);

        $utilities['countries'] = DB::table('countries')->orderBy('country_name')->get();

        $utilities['shipmentTypes'] = DB::table('set_ups')->where('setup_type', 'like', 'shipment_type')
        ->orderBy('setup_value')->get();

        $utilities['shipmentTransfers'] = DB::table('set_ups')->where('setup_type', 'like', 'shipment_transfer')->orderBy('setup_value')->get();

        $utilities['shipmentStatus'] = DB::table('set_ups')->where('setup_type', 'like', 'shipment_status')->orderBy('setup_value')->get();


        $utilities['deliveryTypes'] = DB::table('set_ups')->where('setup_type', 'like', 'delivery_type')->orderBy('setup_value')->get();


        $utilities['shipBy'] = DB::table('set_ups')->where('setup_type', 'like', 'Shipby')->orderBy('setup_value')->get();

        $utilities['currency'] = DB::table('currency')->get();


        $utilities['dates'] = array(
            'date' => date('Y-m-d')
        );

        return ApiController::successResponse($utilities, 200);
    }

    // public function fetchCountries(Request $request){

    //     // if(!auth()->check()){
    //     //     return ApiController::errorResponse("unAuthorized",401);
    //     // }
    //     $countries =  DB::table('countries')
    //     ->get();

    //     return ApiController::successResponse($countries,200);
    // }

    protected function createNewToken($token)
    {
        return response()->json([
            'access_token' => $token,
            'token_type' => 'bearer',
            'expires_in' => auth()->factory()->getTTL() * 180,
            'user' => auth()->user()
        ]);
    }
}
