<?php
namespace App\Http\Controllers\BackOffice\Transactions\input;

use Illuminate\Foundation\Http\FormRequest;

class TransactionSearchRequest extends FormRequest{
     /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules()
    {
        return [
            // The 'type' field can either be an array or null
            'type' => 'nullable|array',
            'type.*' => 'string', // Each item in 'type' must be a string

            // 'clientId' is a required integer, but nullable if not provided
            'clientId' => 'nullable|integer', // Optional, but if provided, must be a valid client ID

            // 'fromDate' and 'toDate' should be valid dates if provided, and can be nullable
            'fromDate' => 'nullable|date', // 'fromDate' should be before or equal to 'toDate'
            'toDate' => 'nullable|date', // 'toDate' should be a valid date
            'hasFiles' => 'boolean',
            // Optional: Additional validation messages for custom error messages
        ];
    }

    /**
     * Custom messages for validation errors (optional).
     *
     * @return array
     */
    public function messages()
    {
        return [
            'type.array' => 'The type must be an array of strings.',
            'type.*.string' => 'Each type value must be a string.',
            'clientId.integer' => 'The client ID must be a valid integer.',
            'clientId.exists' => 'The specified client ID does not exist.',
            'fromDate.date' => 'The from date must be a valid date.',
            'toDate.date' => 'The to date must be a valid date.',
            'fromDate.before_or_equal' => 'The from date must be before or equal to the to date.',
        ];
    }

    // public function failedValidation(Validator $validator)
    // {
    //     throw new HttpResponseException(response()->json([
    //         'success'   => false,
    //         'message'   => 'Validation errors',
    //         'data'      => $validator->errors()
    //     ],422));
    // }

}

?>