<?php

namespace App\Http\Controllers\BackOffice\Reports\excel;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Concerns\FromView;

class ExcelReportExport implements FromView
{
    protected $data;
    protected $screen;

    public function __construct($data,$screen)
    {
        $this->data = $data;
        $this->screen = $screen;
    }

    public function view(): View
    {
        Log::info('data',
        ['data' =>$this->data['data']]);



        return view($this->screen, [
            'data' => isset($this->data['data'])?$this->data['data']:null,
            'moduleKeys' => isset($this->data['moduleKeys'])?$this->data['moduleKeys']:null,
            'language' => isset($this->data['language'])?$this->data['language']:'en',
            'isShipment' => isset($this->data['isShipment'])?$this->data['isShipment']:0,
            'perWeight' => isset($this->data['perWeight'])?$this->data['perWeight']:'',
            'decimals' => isset($this->data['decimals'])?$this->data['decimals']:4,
            'totalunit' => isset($this->data['totalunit'])?$this->data['totalunit']:0,
            'company' => isset($this->data['company'])?$this->data['company']:0,


            
        ]
    );
    }
}
