<?php

namespace App\Http\Controllers\BackOffice\Reports;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\DQ\DQController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\Localization;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use JWTAuth;
use PDF;
use Illuminate\Support\Facades\Log;

class DeliveryReportsController extends ApiController
{


    public function getDeliveryData(Request $request)
    {
        $company_id = JWTAuth::user()->company_id;
        $UtilitiesController = new UtilitiesController();
        $dqController = new DQController();
        $delivery = $this->getReporstsData($request->all());
        $transactionFromDate = $UtilitiesController->convertTodayToTimetsamp($request->transactionFromDate . "" . "00:00:00");
        $transactionToDate = $UtilitiesController->convertTodayToTimetsamp($request->transactionToDate . "" . "23:59:59");
        $navigationType = $request->navigationType;
        $reportType = $request->reportType;
        $Obj['delivery'] = $delivery['data'];
        $Obj['company_id'] = $company_id;
        // return  $Obj;

        // Config('pdf' , $bannerinfo);
        $Obj['company'] = DB::table('companies')->first();
        $Obj['totalForInvoice'] = $delivery['totalForInvoice'];
        $Obj['totalForInvoiceBase'] = $delivery['totalForInvoiceBase'];
        $Obj['totalWithCurrency'] = $delivery['totalWithCurrency'];



        return ApiController::successResponse($delivery['data'], 200);
    }



    public function getReporstsData($requestData)
    {
        $company = DB::table('companies')->first();
        $company_id = $company->company_id;
        $currencyCode = DB::table('companies')
            ->leftjoin('currency', 'currency.currency_id', '=', 'companies.currency')
            ->where('company_id', $company_id)
            ->first();

        $transactionFromDate = $requestData['transactionFromDate'];
        $transactionToDate = $requestData['transactionToDate'];
        $clientId = $requestData['clientId'];
        $orderForwarder = $requestData['orderForwarder'];
        $orderDeliveryType = $requestData['orderDeliveryType'];
        $orderCustomBillType = $requestData['orderCustomBillType'];
        $orderPaymentMethod = $requestData['orderPaymentMethod'];
        $transactionCustomer = $requestData['transactionCustomer'];
        $orderDestinationPoint = $requestData['orderDestinationPoint'];
        $reference = $requestData['reference'] ?? null;
        $withDt = $requestData['withDt'];
        $currencyBase = $requestData['currencyBase'];
        $currency = $requestData['currency'];
        $reportType = $requestData['reportType'];

        $UtilitiesController = new UtilitiesController();
        $transactionFromDate = $UtilitiesController->convertTodayToTimetsamp($transactionFromDate . " 00:00:00");
        $transactionToDate = $UtilitiesController->convertTodayToTimetsamp($transactionToDate . " 23:59:59");

        $delivery = DB::table('transactions')
            ->where('transactions.company_id', $company_id)
            ->where('transactions.transaction_type', 'DO')
            ->where('transactions.internal_transfer', 0)
            ->where('transactions.transaction_date', '>', $transactionFromDate)
            ->where('transactions.transaction_date', '<', $transactionToDate)
            ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactions.forwarder_id')
            ->join('clients', 'clients.client_id', '=', 'transactions.transaction_clientId')
            ->leftjoin('currency', 'currency.currency_id', '=', 'transactions.transaction_currencyId')
            ->leftjoin('set_ups as typeOfDelivery', 'typeOfDelivery.setup_id', '=', 'transactions.transaction_typeOfDeliveryId')
            ->leftjoin('set_ups as customBillTypeId', 'customBillTypeId.setup_id', '=', 'transactions.transaction_customBillTypeId')
            ->leftjoin('payment_methods as paymentMethodId', 'paymentMethodId.id', '=', 'transactions.transaction_paymentMethodId')
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactions.clientCustomer_id')
            ->groupBy('transactions.transaction_id')
            ->when($orderForwarder && $orderForwarder != 'all', function ($query) use ($orderForwarder) {
                return $query->where('transactions.forwarder_id', $orderForwarder);
            })
            ->when($orderDeliveryType && $orderDeliveryType != 'all', function ($query) use ($orderDeliveryType) {
                return $query->where('transactions.transaction_typeOfDeliveryId', $orderDeliveryType);
            })
            ->when($orderCustomBillType && $orderCustomBillType != 'all', function ($query) use ($orderCustomBillType) {
                return $query->where('transactions.transaction_customBillTypeId', $orderCustomBillType);
            })
            ->when($orderPaymentMethod && $orderPaymentMethod != 'all', function ($query) use ($orderPaymentMethod) {
                return $query->where('transactions.transaction_paymentMethodId', $orderPaymentMethod);
            })
            ->when($transactionCustomer && $transactionCustomer != 'all', function ($query) use ($transactionCustomer) {
                return $query->where('transactions.clientCustomer_id', $transactionCustomer);
            })
            ->when($orderDestinationPoint, function ($query) use ($orderDestinationPoint) {
                return $query->where('transactions.transaction_destinationPoint', 'like', '%' . $orderDestinationPoint . '%');
            })
            ->when($reference, function ($query) use ($reference) {
                return $query->where('transactions.transaction_reference', $reference);
            })
            ->select(
                'transactions.transaction_id',
                DB::raw('FROM_UNIXTIME(transaction_date, "%d-%m-%Y") AS transaction_date'),
                'transaction_reference',
                'client_firstname',
                'transaction_remark',
                'client_customers.customer_name',
                'typeOfDelivery.setup_value as typeOfDelivery',
                'customBillTypeId.setup_value as customBillTypeId',
                'transaction_released_DEC as OutboundBOE',
                'paymentMethodId.name as paymentMethodId',
                'transactions.transaction_destinationPoint',
                'currency_code as currencyCode'
            )
            ->when($reportType == 'Transit', function ($query) use ($clientId) {
                return $query->where('transaction_released', 1)
                    ->where('transaction_arrived', 0);
            })
            ->when($reportType == 'Destination', function ($query) use ($clientId) {
                return $query->where('transaction_released', 1)
                    ->where('transaction_arrived', 1);
            })->get();

        $totalForInvoice = 0;
        $totalForInvoiceBase = 0;
        $totalWithCurrency = [];
        $totalWeightAll = 0;
        $withRemaining = $requestData['remainQty'];
        $validDelivery = array();

        foreach ($delivery  as $deliveryFor) {
            $deliveryFor->enabled = true;
            $totalWithCurrency[$deliveryFor->currencyCode] ??= 0;


            $deliveryFor->deliveryDt = DB::table('transaction_dts')
                ->leftjoin('items', 'items.item_id', '=', 'transaction_dts.item_id')
                ->join('clients', 'clients.client_id', '=', 'transaction_dts.client_id')
                ->leftjoin('countries', 'countries.country_id', 'transaction_dts.transactiondt_countryOfOrigin')
                ->leftjoin('locations', 'locations.location_id', 'transaction_dts.transactiondt_locationid')
                ->leftjoin('transactions', 'transactions.transaction_id', 'transaction_dts.transaction_id')
                ->leftjoin('currency', 'currency.currency_id', 'transactions.transaction_currencyId')
                ->where('transaction_dts.transaction_id', $deliveryFor->transaction_id)
                ->select(
                    'transaction_dts.*',
                    'items.item_code',
                    'items.item_description',
                    'clients.*',
                    'countries.*',
                    'locations.*',
                    'currency_code',
                    DB::raw('IFNULL(SUM(transaction_dts.item_quantity), 0) as Total_Qty'),

                )
                ->when($withRemaining == 1, function ($query) {
                    return $query->addselect(
                        DB::raw('(SELECT IFNULL(SUM(item_quantity_to_delivery+item_quantity_to_cancel), 0) FROM transaction_dts as td WHERE td.reference_from_do = transaction_dts.transactiondt_id AND td.dt_transaction_type = "DQ") as Delivered_Qty'),
                    )
                    ->havingRaw('item_quantity-Delivered_Qty >0');
                })
                ->when($clientId && $clientId != 'all', function ($query) use ($clientId) {
                    return $query->where('transaction_dts.client_id', $clientId);
                })
                ->addselect(DB::raw('concat(transactiondt_price, " ", currency_code) as currencyPrice'))
                ->addselect(DB::raw('concat(transactiondt_priceBase, " ", "' . $currencyCode->currency_code . '") as currencyCompanyPrice'))
                ->groupBy('transaction_dts.transactiondt_id')
                ->get();
            if (count($deliveryFor->deliveryDt) == 0) {
                $deliveryFor->enabled = false;
            }
            if ($withDt != 'withDtetails') {
                $deliveryFor->deliveryDt = [];
            }

            $sumDt = DB::table('transaction_dts')
                ->where('transaction_dts.transaction_id', $deliveryFor->transaction_id)
                ->select(
                    'transaction_dts.transactiondt_price',
                    'item_quantity'
                )
                ->selectRaw('SUM(transaction_dts.item_quantity * transactiondt_price) as totalAmount')
                ->selectRaw('SUM(transaction_dts.item_quantity * transactiondt_priceBase) as totalAmountBase')
                ->selectRaw('SUM(transaction_dts.item_quantity * item_weight) as totalWeight')
                ->first();

            $deliveryFor->sumDTotal = $sumDt ? $sumDt->totalAmount : 0;
            $deliveryFor->sumDTotalBase = $sumDt ? $sumDt->totalAmountBase : 0;
            $deliveryFor->totalWeight = $sumDt ? $sumDt->totalWeight : 0;

            $totalWeightAll += $deliveryFor->totalWeight;
            $totalWithCurrency[$deliveryFor->currencyCode] += $deliveryFor->sumDTotal;
            $totalForInvoice += $deliveryFor->sumDTotal;
            $totalForInvoiceBase += $deliveryFor->sumDTotalBase;
        }

        $total = [];
        foreach ($totalWithCurrency as $currency => $amount) {
            $total[] = [
                'currency' => $currency,
                'amount' => $amount,
            ];
        }
        $filteredResults = $delivery->filter(function ($deliveryFor) {
            return $deliveryFor->enabled != false;
        });
        return [
            'totalForInvoice' => $totalForInvoice,
            'totalForInvoiceBase' => $totalForInvoiceBase,
            'data' => $filteredResults->values()->all(),
            'totalWithCurrency' => $total,
            'totalWeightAll' => $totalWeightAll,
        ];
    }


    public function getDeliveryDataExcel(Request $request)
    {

        $UtilitiesController = new UtilitiesController();
        $requestData = $UtilitiesController->decipherRequest($request->transactionDataId);
        if (!$requestData) {
            return 'unreachable url found';
        }


        $requestData = json_decode($requestData);
        $requestData = $requestData->info;
        $transactionFromDate = $requestData->transactionFromDate;
        $transactionToDate = $requestData->transactionToDate;
        $currencyBase = $requestData->currencyBase;
        $currency = $requestData->currency;

        $company = DB::table('companies')->first();
        $company_id = $company->company_id;
        $currencyCode = DB::table('companies')
            ->leftjoin('currency', 'currency.currency_id', '=', 'companies.currency')
            ->where('company_id', $company_id)
            ->first();

        $company_logo = $company->company_logo;
        $transactionFromDate = $UtilitiesController->convertTodayToTimetsamp($transactionFromDate . "" . "00:00:00");
        $transactionToDate = $UtilitiesController->convertTodayToTimetsamp($transactionToDate . "" . "23:59:59");

        $delivery = $this->getReporstsData(collect($requestData));


        //$deleteGroups = tansactionDataPdf::where('transactionData_id','=',$request->transactionDataId)->delete();
        $Obj['delivery'] = $delivery['data'];
        $Obj['company_id'] = $company_id;
        $Obj['company_logo'] = $company_logo;
        // return  $Obj;

        // Config('pdf' , $bannerinfo);
        $Obj['company'] = DB::table('companies')->first();
        $Obj['currencyBase'] = $currencyBase;
        $Obj['currency'] = $currency;

        $Obj['currencyCode'] = $currencyCode->currency_code;
        $Obj['totalForInvoice'] = $delivery['totalForInvoice'];
        $Obj['totalForInvoiceBase'] = $delivery['totalForInvoiceBase'];
        $Obj['totalWithCurrency'] = $delivery['totalWithCurrency'];
        $Obj['totalWeightAll'] = $delivery['totalWeightAll'];



        return ApiController::successResponse($Obj, 200);
    }





    public function deliveryReportPdf(Request $request)
    {

        $UtilitiesController = new UtilitiesController();
        $requestData = $UtilitiesController->decipherRequest($request->transactionDataId);
        if (!$requestData) {
            return 'unreachable url found';
        }


        $requestData = json_decode($requestData);
        $requestData = $requestData->info;
        $transactionFromDate = $requestData->transactionFromDate;
        $transactionToDate = $requestData->transactionToDate;
        $currencyBase = $requestData->currencyBase;
        $currency = $requestData->currency;

        $company = DB::table('companies')->first();
        $company_id = $company->company_id;
        $currencyCode = DB::table('companies')
            ->leftjoin('currency', 'currency.currency_id', '=', 'companies.currency')
            ->where('company_id', $company_id)
            ->first();

        $company_logo = $company->company_logo;
        $transactionFromDate = $UtilitiesController->convertTodayToTimetsamp($transactionFromDate . "" . "00:00:00");
        $transactionToDate = $UtilitiesController->convertTodayToTimetsamp($transactionToDate . "" . "23:59:59");

        $delivery = $this->getReporstsData(collect($requestData));


        //$deleteGroups = tansactionDataPdf::where('transactionData_id','=',$request->transactionDataId)->delete();
        $Obj['delivery'] = $delivery['data'];
        $Obj['company_id'] = $company_id;
        $Obj['company_logo'] = $company_logo;
        // return  $Obj;

        // Config('pdf' , $bannerinfo);
        $Obj['company'] = DB::table('companies')->first();
        $Obj['currencyBase'] = $currencyBase;
        $Obj['currency'] = $currency;

        $Obj['currencyCode'] = $currencyCode->currency_code;
        $Obj['totalForInvoice'] = $delivery['totalForInvoice'];
        $Obj['totalForInvoiceBase'] = $delivery['totalForInvoiceBase'];



        $moduleKeys = Localization::moduleKeys; // Assuming this is an array of keys

        $Obj['language'] = $requestData->language;
        $Obj['moduleKeys'] = $moduleKeys;
        $Obj['isShipment'] = $Obj['company']->company_onlyShipment;
        ini_set('max_execution_time', '50000');
        ini_set("pcre.backtrack_limit", "5000000000");


        ini_set('memory_limit', '200048M');

        $loadPdf = 'deliveryReport';
        if ($Obj['isShipment'] == 1) {
            $loadPdf = '/shipment/deliveryReport';
        }
        $pdf = PDF::loadView($loadPdf, $Obj, [], [
            'title' => 'Certificate',
            'format' => config('app.PDFFORMAT'),
            'orientation' => 'P'
        ]);


        // tansactionDataPdf::where('transactionData_id','=',$request->transactionDataId)
        // ->delete();


        return $pdf->stream('Delivery.pdf');
    }
}
