<?php

namespace App\Http\Controllers\BackOffice\GoodsIn;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\transactionDtSnTmp;
use App\Models\transactiontmp;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use JWTAuth;

class GoodsInSerialsController extends ApiController
{
    public function fetchGoodsInItemsHavingSerials(Request $request)
    {
        $goodsinSerials = transactiontmp::join('transactiondttmps', 'transactiondttmps.transactiontmp_id', '=', 'transactiontmps.transactiontmp_id')
            ->join('items', 'items.item_id', '=', 'transactiondttmps.item_id')
            ->join('clients', 'clients.client_id', '=', 'transactiontmps.transactiontmp_clientId')
            ->leftjoin('item_groups', 'item_groups.group_id', '=', 'transactiondttmps.group_id')
            ->leftjoin('countries', 'countries.country_id', '=', 'transactiondttmps.transactiondttmp_countryOfOrigin')
            ->where([
                ['items.item_hasSerial', '=', true],

                ['transactiontmps.transactiontmp_id', '=', $request->transactionTmpId],
                ['transactiontmps.transactiontmp_reference', null]
            ])
            ->orderBy('client_firstname')
            ->select('items.item_code', 'transactiondttmps.item_quantity', 'clients.client_firstname',
                'transactiontmpdt_billOfEntry', 'transactiontmp_type', 'items.item_description',
                'transactiondttmps.transactiondttmp_id', 'items.item_id', 'countries.country_name')
            ->get();

        return ApiController::successResponse($goodsinSerials, 200);
    }

    // public function setNewOriginalTransaction(Request $request)
    // {
    //     $user = auth()->user();
    //     $utilitiesController = new UtilitiesController();


    //     $checkTransactionTmpExistance = transactiontmp::where([
    //         ['transactiontmp_id',$request->transactionTmpId],

    //     ])
    //     ->join('users','users.id','transactiontmps.user_id')
    //     ->first();


    //     // retrieve the current transaction dt tmp
    //     $transactionDtsTmp = transactiondttmp::join('items','items.item_id','=','transactiondttmps.item_id')
    //     ->select('transactiondttmps.*','items.item_hasSerial')
    //     ->where('transactiontmp_id','=',$request->transactionTmpId)
    //     ->get();

    //     //return ApiController::errorResponse($transactionDtsTmp,422);

    //     // verify nbr of transaction serials dt is equal to the origin quantity
    //     $invalidTransactionsIndex = Array();
    //     for($i = 0; $i < count($transactionDtsTmp); $i++ )
    //     {
    //         $quantity = $transactionDtsTmp[$i]->item_quantity;
    //         $checkNbrOfSerialsCreatedTmp = transactionDtSnTmp::where([
    //             ['transactiondttmp_id','=',$transactionDtsTmp[$i]->transactiondttmp_id],
    //         ])
    //         ->get();

    //         //return ApiController::errorResponse($quantity,422);

    //         if( $transactionDtsTmp[$i]->item_hasSerial && $quantity != count($checkNbrOfSerialsCreatedTmp) )
    //         {
    //             // $transactionDtsTmp[$i]->errorIndex = $i;
    //             array_push($invalidTransactionsIndex,$transactionDtsTmp[$i]);
    //         }
    //     }


    //     if( count($invalidTransactionsIndex) > 0)
    //     {
    //         return ApiController::errorResponse($invalidTransactionsIndex,422);
    //     }

    //     // delete previous transactions dts
    //     if( $request->transactionId )
    //     {
    //         transactiondt::where('transaction_id','=',$request->transactionId)->delete();
    //     }
    //     $newTransaction = null;
    //     $getSequence = null;

    //     //return ApiController::errorResponse($checkTransactionTmpExistance,422);

    //     if( $checkTransactionTmpExistance )
    //     {


    //         $getSequence = sequence::where('sequence_transactionType','like',$checkTransactionTmpExistance->transactiontmp_type)->first();
    //         if( !$getSequence )
    //         {
    //             return ApiController::errorResponse($getSequence,422);
    //         }

    //         $sequenceNumber = $getSequence->sequence_transactionRef + 1;
    //         $goodsInSequence = $checkTransactionTmpExistance->transactiontmp_reference ? $checkTransactionTmpExistance->transactiontmp_reference : $sequenceNumber;


    //         $transaction = array(
    //             'transaction_reference' => $goodsInSequence,
    //             'transaction_id' => $checkTransactionTmpExistance->transactiontmp_id,
    //             'transaction_date' => $checkTransactionTmpExistance->transactiontmp_date,
    //             'transaction_clientId' => $checkTransactionTmpExistance->transactiontmp_clientId,
    //             'transaction_type' => $checkTransactionTmpExistance->transactiontmp_type,
    //             'transaction_remark' => $checkTransactionTmpExistance->transactiontmp_remark,
    //             'transaction_mobileReference' => $checkTransactionTmpExistance->transactiontmp_mobileReference,
    //             'transaction_shipmentReference' => $checkTransactionTmpExistance->transactiontmp_shipmentReference,
    //             'transaction_billOfEntry' => $checkTransactionTmpExistance->transactiontmp_billOfEntry,
    //             'user_id' => $checkTransactionTmpExistance->user_id,
    //             'transaction_typeOfDeliveryId' => $checkTransactionTmpExistance->transactiontmp_typeOfDeliveryId,
    //             'forwarder_id'=> $checkTransactionTmpExistance->forwarder_id,
    //             'clientCustomer_id'=> $checkTransactionTmpExistance->clientCustomer_id,
    //             'transaction_driverName'=> $checkTransactionTmpExistance->transactiontmp_driverName,
    //             'transaction_vehicleNumber'=> $checkTransactionTmpExistance->transactiontmp_vehicleNumber,
    //             'transaction_exitPoint'=> $checkTransactionTmpExistance->transactiontmp_exitPoint,
    //             'transaction_destinationPoint'=> $checkTransactionTmpExistance->transactiontmp_destinationPoint,
    //             'company_id'=> $checkTransactionTmpExistance->company_id,
    //             'transaction_paymentMethodId'=> $checkTransactionTmpExistance->transactiontmp_paymentMethodId,
    //             'transaction_customBillTypeId'=> $checkTransactionTmpExistance->transactiontmp_customBillTypeId,
    //             'transaction_currencyId'=> $checkTransactionTmpExistance->transactiontmp_currencyId,
    //             'transaction_shipmentTypeId' =>$checkTransactionTmpExistance->transactiontmp_shipmentTypeId,
    //             'transaction_shipById' => $checkTransactionTmpExistance->transactiontmp_shipById,
    //             'transaction_shipmentRemark' => $checkTransactionTmpExistance->transactiontmp_shipmentRemark,
    //             'transaction_supplierId' => $checkTransactionTmpExistance->transactiontmp_supplierId,
    //             'transaction_supplierInvoice' => $checkTransactionTmpExistance->transactiontmp_supplierInvoice,
    //         );
    //         if( $checkTransactionTmpExistance && !$checkTransactionTmpExistance->transactiontmp_reference )
    //         {
    //             $newTransaction = transactions::create($transaction);

    //             $notificationToken = DB::table('users')
    //             ->join('clients','clients.user_id','id')
    //             ->where([
    //                 ["clients.client_id",$checkTransactionTmpExistance->transactiontmp_clientId],
    //             ])
    //             ->first();


    //             $type="GoodsIn";
    //             $ref = $goodsInSequence;
    //             $message =  $type.' Ref: '.$ref.' was created';
    //           if($checkTransactionTmpExistance->transactiontmp_type == 'RMA_IN'){
    //             $type="RMAIN";
    //           }

    //             if(isset($notificationToken->user_pushToken)){
    //                 $utilitiesController->sendNotification('Transaction',$message,$notificationToken->user_pushToken,$checkTransactionTmpExistance->transactiontmp_clientId,'');

    //             }
    //         }
    //         else
    //         {
    //             transactions::where('transaction_id','=',$request->transactionId)->update($transaction);
    //             $newTransaction = transactions::where('transaction_id','=',$request->transactionId)->first();
    //         }

    //         if( !$checkTransactionTmpExistance->transactiontmp_reference )
    //         {
    //             sequence::where('sequence_transactionType','like',$checkTransactionTmpExistance->transactiontmp_type)->increment('sequence_transactionRef',1);
    //         }


    //         // after saving and creation of transaction or update get tmp transaction dt into original and remove from tmp
    //         if( $newTransaction )
    //         {
    //             // start : transfer supplier to client suppliers
    //             if( $checkTransactionTmpExistance && ($checkTransactionTmpExistance->transactiontmp_type == 'GOODS_IN' || $checkTransactionTmpExistance->transactiontmp_type == 'RMA_IN') )
    //             {
    //                 if( $newTransaction->transaction_supplierId )
    //                 {
    //                     $getSupplierDetails = suppliers::where('supplier_id','=',$newTransaction->transaction_supplierId)->first();

    //                     $checkIfSupplierExist = clientSupplier::where([
    //                         ['supplier_email','=',$getSupplierDetails->supplier_email],
    //                         ['supplier_related_clientid','=',$newTransaction->transaction_clientId]
    //                     ])
    //                     ->first();

    //                     if( !$checkIfSupplierExist && $getSupplierDetails )
    //                     {
    //                         $supplierArray = Array(
    //                             'supplier_name' => $getSupplierDetails->supplier_name,
    //                             'supplier_contactPerson' => $getSupplierDetails->supplier_contactPerson,
    //                             'supplier_address' => $getSupplierDetails->supplier_address,
    //                             'supplier_country' => $getSupplierDetails->supplier_country,
    //                             'supplier_phone' => $getSupplierDetails->supplier_phone,
    //                             'supplier_email' => $getSupplierDetails->supplier_email,
    //                             'supplier_related_clientid' => $newTransaction->transaction_clientId
    //                         );
    //                         clientSupplier::create($supplierArray);
    //                     }
    //                 }
    //             }
    //             //return ApiController::errorResponse($transactionDtsTmp,422);
    //             foreach($transactionDtsTmp as $transactionDtTmp)
    //             {
    //                 $transactionDtArray = Array(
    //                     'transactiondt_id' => $transactionDtTmp->transactiondttmp_id,
    //                     'transaction_id' => $newTransaction->transaction_id,
    //                     'item_id' => $transactionDtTmp->item_id,
    //                     'client_id' => $transactionDtTmp->client_id,
    //                     'item_quantity' => $transactionDtTmp->item_quantity,
    //                     'supplier_id' => $transactionDtTmp->supplier_id,
    //                     'supplier_invoice_number' => $transactionDtTmp->supplier_invoice_number,
    //                     'transactiondt_locationid' => $transactionDtTmp->transactiondttmp_locationid,
    //                     'transactiondt_countryOfOrigin' => $transactionDtTmp->transactiondttmp_countryOfOrigin,
    //                     'transactiondt_price' =>$transactionDtTmp->transactiondttmp_price,
    //                     'id_reference_dt' => $transactionDtTmp->id_reference_dt,
    //                     'transactiondt_billOfEntry' => $transactionDtTmp->transactiontmpdt_billOfEntry,
    //                     'raw_in_grid'=>$transactionDtTmp->raw_in_grid,
    //                     'item_weight'=>$transactionDtTmp->item_weight,
    //                     'item_unit'=>$transactionDtTmp->item_unit,
    //                     'item_qtyPerPack'=>$transactionDtTmp->item_qtyPerPack,
    //                     'item_pack'=>$transactionDtTmp->item_pack,
    //                     'group_id' =>$transactionDtTmp->group_id,
    //                     'palet_no' => $transactionDtTmp->palet_no,
    //                     'transactiondt_nbOfCarton'=> $transactionDtTmp->transactiondttmp_nbOfCarton,
    //                     'transactiondt_cellMerge'=> $transactionDtTmp->transactiondttmp_cellMerge,


    //                 );
    //                 // start : transfer items to client items
    //                 if( $checkTransactionTmpExistance && ($checkTransactionTmpExistance->transactiontmp_type == 'GOODS_IN' || $checkTransactionTmpExistance->transactiontmp_type == 'RMA_IN') )
    //                 {
    //                     if( $transactionDtTmp->item_id )
    //                     {
    //                         $getItemDetails = items::where('item_id','=',$transactionDtTmp->item_id)->first();

    //                         $checkIfItemExist = clientItem::where([
    //                             ['item_code','=',$getItemDetails->item_code],
    //                             ['item_related_client_id','=',$newTransaction->transaction_clientId]
    //                         ])
    //                         ->first();

    //                         if( !$checkIfItemExist && $getItemDetails )
    //                         {
    //                             $itemArray = Array(
    //                                 'item_code' => $getItemDetails->item_code,
    //                                 'item_description' => $getItemDetails->item_description,
    //                                 'item_barcode' => $getItemDetails->item_barcode,
    //                                 'item_related_client_id' => $newTransaction->transaction_clientId,
    //                                 'item_hasSerial' => $getItemDetails->item_hasSerial,
    //                                 'item_hscode' => $getItemDetails->item_hscode,
    //                                 'item_weight' => $getItemDetails->item_weight,
    //                                 'item_unit' => $getItemDetails->item_unit,
    //                                 'item_qtyPerPack' => $getItemDetails->item_qtyPerPack,
    //                                 'item_pack' => $getItemDetails->item_pack,
    //                             );
    //                             clientItem::create($itemArray);
    //                         }
    //                     }
    //                     // end : transfer items to client items
    //                 }


    //                 $newTransactionDt = transactiondt::create($transactionDtArray);
    //                 $serialsTmp = transactionDtSnTmp::where('transactiondttmp_id','=',$transactionDtTmp->transactiondttmp_id)->get();
    //                 transactionDtsn::where('transactiondt_id','=', $newTransactionDt->transactiondt_id)->delete();

    //                 foreach ($serialsTmp as $serialTmp) {
    //                     $transactionSerialTmpArray = Array(
    //                         'transactiondt_id' => $newTransactionDt->transactiondt_id,
    //                         'item_id' => $serialTmp->item_id,
    //                         'transaction_item_serial' => $serialTmp->transaction_item_serial
    //                     );
    //                     transactionDtsn::create($transactionSerialTmpArray);
    //                 }
    //             }

    //             if( $newTransaction )
    //             {
    //                 transactiontmp::where('transactiontmp_id','=',$request->transactionTmpId)->delete();
    //                 // delete transaction details from tmp table
    //                 foreach($transactionDtsTmp as $transactionDetailTmp )
    //                 {
    //                     transactionDtSnTmp::where('transactiondttmp_id','=',$transactionDetailTmp->transactiondttmp_id)->delete();
    //                 }
    //                 transactiondttmp::where('transactiontmp_id','=',$request->transactionTmpId)->delete();
    //             }

    //             $id=  $checkTransactionTmpExistance->id;
    //             $token=  $checkTransactionTmpExistance->user_pushToken;
    //             $utilitiesController->sendNotification($type.' serail',$type.' Transaction with ref:'.$ref.' was saved with serials',$token,$id,'SaveGoodsInSerials');

    //             return ApiController::successResponse($newTransaction,200);
    //         }
    //     }
    //     return ApiController::errorResponse($checkTransactionTmpExistance,409);
    // }


    public function retrievePendingGoodsIn(Request $request)
    {
        $loggerUserCompany = auth()->user()->company_id;

        $transactions = transactiontmp::join('users', 'users.id', '=', 'transactiontmps.user_id')
            ->join('clients', 'clients.client_id', '=', 'transactiontmps.transactiontmp_clientId')
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactiontmps.clientCustomer_id')
            ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactiontmps.forwarder_id')
            ->orderBy('transactiontmp_date', 'asc')
            ->where([
                ['transactiontmps.transactiontmp_type', 'like', $request->transactionType],
                ['transactiontmps.company_id', '=', $loggerUserCompany],
                ['transactiontmp_enterSerial', '=', true],
                ['transactiontmps.transactiontmp_reference', null]
            ])
            ->get();

        foreach ($transactions as $transaction) {
            if ($transaction->transactiontmp_date) {
                $transaction->transactiontmp_formatdate = date('Y-m-d', $transaction->transactiontmp_date);
            }
        }
        return ApiController::successResponse($transactions, 200);
    }


    public function saveGoodsInWithoutSerials(Request $request)
    {
        $utilitiesController = new UtilitiesController();


        $checkItemsHaveSerials = transactiontmp::join('transactiondttmps', 'transactiondttmps.transactiontmp_id', 'transactiontmps.transactiontmp_id')
            ->join('items', 'items.item_id', 'transactiondttmps.item_id')
            ->where([
                ['transactiontmps.transactiontmp_id', '=', $request->transactionTmpId],
            ])
            ->get();


        $type = 'GOODS_IN';
        $notificationType = 'd';
        $canSaveWithoutSerial = false;
        $InvalidSerials = false;
        for ($i = 0; $i < count($checkItemsHaveSerials); $i++) {
            $element = $checkItemsHaveSerials[$i];
            if ($element->item_hasSerial) {
                $canSaveWithoutSerial = true;
                $quantity = $element->item_quantity;
                $checkNbrOfSerialsCreatedTmp = transactionDtSnTmp::where([
                    ['transactiondttmp_id', '=', $element->transactiondttmp_id],
                ])
                    ->get();

                $type = $element->transactiontmp_type == 'GOODS_IN' ? 'goodsIn-serials' : 'rmaIn-serials';

                $notificationType = $element->transactiontmp_type == 'GOODS_IN' ? 'GOODS IN W/S' : 'RMA IN';
                if ($element->item_hasSerial && $quantity != count($checkNbrOfSerialsCreatedTmp)) {
                    $InvalidSerials = true;
                }


                // break;
            }
        }


        if ($canSaveWithoutSerial && $InvalidSerials) {
            $updateTransaction = transactiontmp::where('transactiontmp_id', '=', $request->transactionTmpId)
                ->update([
                    'transactiontmp_enterSerial' => true,
                ]);

            $admins = DB::table('users')
                ->join('useraccess', 'useraccess.user_id', 'users.id')
                ->where([
                    ["useraccess.useraccess_formcode", $type],
                    ["useraccess.useraccess_insert", true],
                ])
                ->get();

            foreach ($admins as $admindt) {

                if ($admindt->user_pushToken) {

                    $utilitiesController->sendNotification($notificationType . ' serail', 'New ' . $notificationType . ' was created', $admindt->user_pushToken, $admindt->id, $type);
                }
            }
            return ApiController::successResponse($updateTransaction, 200);
        } else if (!$canSaveWithoutSerial) {
            return ApiController::errorResponse(' All items do not have serials', 422);
        } else {
            return ApiController::errorResponse('save transaction instead of save without serials', 422);

        }
    }
}
