<?php

namespace App\Http\Controllers\BackOffice\DQ;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\History\HistoryController;
use App\Http\Controllers\BackOffice\Charging\ChargeTempalteController;
use App\Models\companies;
use App\Models\items;
use App\Models\sequence;
use App\Models\transactionDt;
use App\Models\transactionDtsn;
use App\Models\transactionDtSnTmp;
use App\Models\transactiondttmp;
use App\Models\transactions;
use App\Models\transactiontmp;
use App\Models\TransactiontmpPalets;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use JWTAuth;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use Illuminate\Support\Facades\Log;

class DQController extends ApiController
{

    public function fetchDQTransactions(Request $request)
    {
     

        $count = 0;
        $transactions = transactions::join('clients', 'clients.client_id', '=', 'transactions.transaction_clientId')
            ->leftjoin('transaction_dts', 'transaction_dts.transaction_id', 'transactions.transaction_id')
            ->leftjoin('clients as toClient', 'toClient.client_id', '=', 'transactions.transferTo_clientId')
            ->leftjoin('clients as toClientdt', 'toClientdt.client_id', '=', 'transaction_dts.client_id')
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactions.clientCustomer_id')
            ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactions.forwarder_id')
            ->leftjoin('currency', 'currency.currency_id', '=', 'transactions.transaction_currencyId');
        if ($request->filterReleased == "released") {

            $transactions->where([
                ['transaction_released', 1],
            ]);
        }
        if ($request->filterReleased == "notReleased") {

            $transactions->where([
                ['transaction_released', 0],

            ]);
        }
        $transactions = $transactions
            ->select(
                'transactions.transaction_reference',
                'transactions.transaction_date',
                'client_customers.customer_name',
                'client_forwarders.clientforwarder_name',
                'clients.client_firstname',
                'toClient.client_firstname as transferToClient',
                'transactions.transaction_id',
                'salesjv_id',
                'transaction_type',
                'transaction_currencyId',
                'currency_code',
                'transactions.transaction_released',
                'transactions.transaction_releasedDate',
                'transactions.transaction_remark',
                'transaction_billOfEntry',
                'transaction_shipmentReference',
                'transaction_exitPoint',
                'transaction_destinationPoint',
                'transaction_shipmentRemark',
                'transactions.transaction_mobileReference',
                'Invoice_type_id',
                'payment_term_id',
                'delivery_term_id',
                'exemption_type_id',
                'transaction_released_DEC',
                'internal_transfer',
                'transferTo_clientId',
                'toClientdt.client_firstname as dtName',
                'transaction_arrived'
            )
            ->selectRaw(DB::raw(" FROM_UNIXTIME(transaction_date, '%d-%m-%Y') AS transaction_formatdate"))
            ->selectRaw(DB::raw(" FROM_UNIXTIME(transaction_releasedDate, '%d-%m-%Y %H:%i:%s ') AS transaction_releasedDate"))
            ->selectRaw(DB::raw("(SELECT SUM(transactiondt_priceBase*item_quantity) FROM transaction_dts WHERE transaction_id = transactions.transaction_id) AS total_price"))
            ->where([
                ['transaction_type', transactions::transactionTypes["$request->transactionType"]['type']],
                ['internal_transfer', transactions::transactionTypes["$request->transactionType"]["internalTransfer"]]
            ])
            ->whereRaw('date(FROM_UNIXTIME(transaction_date)) BETWEEN ? AND ?', [$request->dateFrom, $request->dateTo])
            ->orderBy('transaction_reference', 'desc');
        $count = count($transactions->get());
        if (isset($request->skip) && isset($request->take)) {
            $transactions->skip($request->skip)
                ->take($request->take);
        }
        if ($request->search) {
            $transactions->Where(function ($query) use ($request) {
                $query->Where([
                    ['transaction_reference', 'like', '%' . $request->search . '%']
                ])
                    ->orWhere([
                        ['transaction_mobileReference', 'like', '%' . $request->search . '%']
                    ])
                    ->orWhere([
                        ['transaction_remark', 'like', '%' . $request->search . '%']
                    ])
                    ->orWhere([
                        ['clients.client_firstname', 'like', '%' . $request->search . '%']
                    ])
                    ->orWhere([
                        ['toClientdt.client_firstname', 'like', '%' . $request->search . '%']
                    ]);
            });
        }
        $transactions = $transactions
            ->groupby('transaction_id')->get();

        foreach ($transactions as $splitTrans) {

            $multiDelivery = transactionDt::where('transaction_id', $splitTrans->transaction_id)
                ->groupby('client_id')
                ->get();

            if (count($multiDelivery) > 1) {
                $splitTrans->client_firstname = '-';
            }
        }


        if ($transactions) {
            return ApiController::successResponse($transactions, 200, $count);
        }
        return ApiController::successResponse('No result', 204);
    }

    public function loadFromDO(Request $request)
    {
        $utilitiesController = new UtilitiesController();
        $client = $request->client;
        $DQTransactionId = $request->transaction_id;


        $transactions = transactions::join('transaction_dts', 'transaction_dts.transaction_id', '=', 'transactions.transaction_id')
            ->leftjoin('clients', 'clients.client_id', '=', 'transactions.transaction_clientId')
            ->leftjoin('suppliers', 'suppliers.supplier_id', '=', 'transactions.transaction_supplierId')
            ->leftjoin('countries', 'countries.country_id', '=', 'transaction_dts.transactiondt_countryOfOrigin')
            ->leftjoin('items', 'items.item_id', '=', 'transaction_dts.item_id')
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactions.clientCustomer_id')
            ->select(
                'customer_name',
                'transactions.transaction_reference',
                'transactions.transaction_date',
                'clients.client_firstname',
                'transactions.transaction_id',
                'transactions.transaction_mobileReference',
                'salesjv_id',
                'transactions.transaction_remark',
                'transactions.transaction_billOfEntry',
                'transactions.transaction_shipmentReference',
                'transactions.transaction_typeOfDeliveryId',
                'suppliers.supplier_name',
                'transactions.transaction_supplierInvoice',
                'transactions.transaction_type',
                'transactions.transaction_released as released',
                'transaction_BOE',
                'Invoice_type_id',
                'payment_term_id',
                'delivery_term_id',
                'exemption_type_id',
                'transaction_dts.*',
                'item_code',
                'country_name',
                'item_quantity',

            )
            ->selectRaw(DB::raw(" FROM_UNIXTIME(transactions.transaction_date, '%d-%m-%Y') AS transaction_formatdate"))
            ->where([
                ['transactions.transaction_type', 'DO'],
                ['transactions.transaction_released', 1],
                ['transactions.transaction_arrived', 1],
                ['internal_transfer', transactions::transactionTypes["DO"]["internalTransfer"]],
                ['transaction_dts.client_id', $client]
            ])
            //  ->where('transactions.transaction_date','>',  $dateToTimeStamp)
            ->groupby('transaction_dts.transactiondt_id')
            ->orderBy('transactions.transaction_date', 'desc')
            ->orderBy('transactions.transaction_reference', 'desc');
        $count = count($transactions->get());
        if (isset($request->skip) && isset($request->take)) {
            //$transactions->skip($request->skip)
            // ->take($request->take);
        }
        if ($request->search) {
            $transactions->Where(function ($query) use ($request) {
                $query->Where([
                    ['transaction_reference', 'like', '%' . $request->search . '%']
                ]);
            });
        }
        $transactions = $transactions->get();

        $data = array();
        foreach ($transactions as $splitTrans) {
            $transactiondt_id = $splitTrans->transactiondt_id;
            $quantity = $splitTrans->item_quantity;
            $existQty = $this->calculateExistQtyDQ($quantity, $transactiondt_id, $DQTransactionId);
            $splitTrans->item_quantity = $existQty;
            if ($splitTrans->item_quantity > 0) {
                array_push($data, $splitTrans);
            }
        }


        return ApiController::successResponse($data, 200);
    }



    public function addDOFromMultipleDO(Request $request)
    {
        $utilitiesController = new UtilitiesController();
        $transactions = $request->transactions;
        $DQTransactionId = $request->transaction_id;

        $selectedTransId = $request->transaction_id;
        $k = 0;
        $maxIndex = transactiondttmp::where(
            [
                ['transactiontmp_id', $DQTransactionId]
            ]
        )
            ->max('raw_in_grid');

        if ($maxIndex !== null) {
            $k = $maxIndex + 1;
        }


        foreach ($transactions as $transElement) {
            $transactiondtId = $transElement['transactiondt_id'];
            $newTransactionTmp = transactiontmp::where('transactiontmp_id', $selectedTransId)->first();


            $transactionsDtsOrignal = transactionDt::where(
                [
                    ['transactiondt_id', $transactiondtId]
                ]
            )
                //->groupBy('item_id','transactiondt_billOfEntry','transactiondt_countryOfOrigin')
                ->get();

            $transactionSerialArray = [];
            foreach ($transactionsDtsOrignal as $Transactiondt) {
                if (!empty($Transactiondt)) {
                    $itemDetails = items::where(
                        [
                            ['item_id', $Transactiondt->item_id]
                        ]
                    )->first();

    
                    $transactiondt_id = $Transactiondt->transactiondt_id;
                    $quantity = $Transactiondt->item_quantity;
                    $existQty = $this->calculateExistQtyDQ($quantity, $transactiondt_id, $DQTransactionId);

                    // Formulate record that will be saved
                    $transactionDtsTmp = [];
                    $transactionDtsTmp = array(
                        'transactiontmp_id' => $newTransactionTmp->transactiontmp_id,
                        'dt_transaction_type' => 'DQ',
                        'item_id' => $Transactiondt->item_id,
                        'reference_from_do' => $Transactiondt->transactiondt_id,
                        'item_quantity' => $existQty,
                        'item_price' => $Transactiondt->item_price,
                        'group_id' => $itemDetails->group_id,
                        'item_weight' => $Transactiondt->item_weight,
                        'item_pack' => $itemDetails->item_pack,
                        'item_unit' => $itemDetails->item_unit,
                        'item_qtyPerPack' => $itemDetails->item_qtyPerPack,
                        'id_reference_dt' => null,
                        'raw_in_grid' => $k,
                        'transactiondttmp_cellMerge' => $k + 1,
                        'transactiondttmp_nbOfCarton' => (isset($itemDetails->item_qtyPerPack) && $itemDetails->item_qtyPerPack > 0) ? ceil($Transactiondt->item_quantity / $itemDetails->item_qtyPerPack) : 0,
                        'supplier_id' => $Transactiondt->supplier_id,
                        'supplier_invoice_number' => $Transactiondt->supplier_invoice_number,
                        'transactiondttmp_locationid' => $Transactiondt->transactiondt_locationid,
                        'transactiondttmp_countryOfOrigin' => $Transactiondt->transactiondt_countryOfOrigin,
                        'transactiontmpdt_billOfEntry' => $Transactiondt->transactiondt_billOfEntry,
                        'transactiondttmp_price' => $Transactiondt->transactiondt_price,
                        'client_id' => $Transactiondt->client_id,
                        'hscode' => $Transactiondt->hscode,
                        'transactiondt_item_description' => $Transactiondt->transactiondt_item_description,
                        'transactiondttmp_fpriceBase' => $Transactiondt->transactiondt_fpriceBase,
                        'transactiondttmp_fprice' => $Transactiondt->transactiondt_fprice,
                        'transactiondttmp_priceBase' => $Transactiondt->transactiondt_priceBase,
                        'transactiontmpdt_BOE' => $Transactiondt->transactiondt_BOE,
                    );
                }
                $k = $k + 1;
                $newTransactionDtsTmp = transactiondttmp::create($transactionDtsTmp);

                $serials = transactionDtSn::where([
                    ['transactiondt_id', $Transactiondt->transactiondt_id]
                ])->get();
                foreach ($serials as $splitSerials) {
                    $transactionSerialArray[] = [
                        'item_id' => $splitSerials->item_id,
                        'transaction_item_serial' => $splitSerials->transaction_item_serial,
                        'transactiondttmp_id' => $newTransactionDtsTmp->transactiondttmp_id,
                    ];
                }
            }

            $newTransactionSerialsTmp = transactionDtSnTmp::insert($transactionSerialArray);

            $type = 'DQ';
            $message = ' Automatic ' . $type . ' was created';
        }

        $transactions = transactiontmp::join('users', 'users.id', '=', 'transactiontmps.user_id')
            ->join('clients', 'clients.client_id', '=', 'transactiontmps.transactiontmp_clientId')
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactiontmps.clientCustomer_id')
            ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactiontmps.forwarder_id')
            ->orderBy('transactiontmp_date', 'desc')
            ->where([
                ['transactiontmp_id', $selectedTransId],
            ])
            ->first();

        $transactions->transactiontmp_formatdate = date('Y-m-d', $transactions->transactiontmp_date);

        return ApiController::successResponse($transactions, 200);
    }


    public function createTransactionTmpDQ(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'transactionDate' => 'required',
            'transactionType' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        $user = auth()->user();
        $companyId = companies::get();
        $utilitiesController = new UtilitiesController();

        // in case it is an original transaction copy the transaction to tmp table
        $checkOriginalTransactionExistance = transactions::getTransaction($request->transactionTmpId);
        $getCurrentTransaction = transactiontmp::getTransaction($request->transactionTmpId);
        transactiondttmp::updatePriceBase($getCurrentTransaction, $request->transactionTmpId, $request->transactionRate);


        $transactionTmp = array(
            'transactiontmp_date' => $utilitiesController->convertTodayToTimetsamp($request->transactionDate . "" . date('H:i:s')),
            'transactiontmp_type' => transactions::transactionTypes["$request->transactionType"]["type"],
            'transactiontmp_remark' => $request->transactionRemark,
            'transferTo_clientId' => $request->transactionClientTo,
            'internal_transfer' => transactions::transactionTypes["$request->transactionType"]["internalTransfer"],
            'transactiontmp_shipmentReference' => $request->transactionShipmentReference,
            'transactiontmp_billOfEntry' => $request->transactionBillOfEntry,
            'transactiontmp_clientId' => $request->transactionClient,
            'user_id' => $user->id,
            'transactiontmp_reference' => isset($checkOriginalTransactionExistance->transaction_reference) ? $checkOriginalTransactionExistance->transaction_reference : null,
            'transactiontmp_typeOfDeliveryId' => $request->orderDeliveryType,
            'forwarder_id' => $request->orderForwarder,
            'clientCustomer_id' => isset($request->transactionCustomer) ? $request->transactionCustomer : null,
            'transactiontmp_driverName' => $request->orderDriverName,
            'transactiontmp_driverPhone' => $request->orderDriverPhone,
            'transactiontmp_vehicleNumber' => $request->orderVehicleNumber,
            'transactiontmp_exitPoint' => $request->orderExitPoint,
            'transactiontmp_destinationPoint' => $request->orderDestinationPoint,
            'company_id' => $companyId,
            'transactiontmp_paymentMethodId' => $request->orderPaymentMethod,
            'transactiontmp_customBillTypeId' => $request->orderCustomBillType,
            'transactiontmp_currencyId' => $request->transactionCurrency,
            'transactiontmp_rate' => $request->transactionRate,
            'transactiontmp_shipmentTypeId' => $request->transactionShipmentType,
            'transactiontmp_shipById' => $request->shipBy,
            'transactiontmp_shipmentRemark' => $request->transactionShipmentRemark,
            'transactiontmp_supplierId' => $request->transactionSupplier,
            'transactiontmp_supplierInvoice' => $request->transactionSupplierInvoice,
        );


        if ($request->transactionTmpId) {
            $transactionTmpAfterUpdate = transactiontmp::updateTransaction($request->transactionTmpId, $transactionTmp);
            transactiontmp::updateInternalTransaction($request, $companyId, $user->id);
            if ($transactionTmpAfterUpdate) {
                return ApiController::successResponse($transactionTmpAfterUpdate, 200);
            }
            return ApiController::errorResponse($transactionTmpAfterUpdate, 422);
        } else {
            $newTransactionTmp = transactiontmp::create($transactionTmp);
            $payload = array();
            $payload['transactionType']=$request->transactionType;
            $payload['transactionClient']=$request->transactionClient;
            $payload['transactionDate']=$request->transactionDate;
             $payload['transactionClientTo']=$request->transactionClientTo;
            $payload['userId'] = $user->id;
            $payload['transactiontmp_id'] = $newTransactionTmp->transactiontmp_id;
            $payload['companyId'] = $companyId;
            if ($newTransactionTmp) {
                return ApiController::successResponse($newTransactionTmp, 200);
            }
            return ApiController::errorResponse($newTransactionTmp, 422);
        }
    }

    public function updateTransactionDtTmpPriceDQ(Request $request)
    {


        $deliveredQty = $request->transactionDetailItemQtyToDeliver;
        $canceledQty = $request->transactionDetailItemQtyToCancel;
        $transactionDtTmpsIdGet = DB::table('transactiondttmps')
            ->where([
                ['transactiontmp_id', '=', $request->transactionTmpId],
                ['raw_in_grid', '=', $request->raw_in_grid]
            ]);
        $transactionDtTmpsId = $transactionDtTmpsIdGet->update([
            'transactiondttmp_price' => $request->transactionTmpPrice,
            'transactiondttmp_priceBase' => $request->transactiondttmpPriceBase,
            'transactiondttmp_fprice' => $request->fPrice,
            'transactiondttmp_fpriceBase' => $request->fPrice,
            'transactiondttmp_fpriceBase' => $request->fPrice,
            'transactiondttmp_fpriceBase' => $request->fPrice,
            'item_quantity_to_delivery' => $deliveredQty,
            'item_quantity_to_cancel' => $canceledQty


        ]);
        if ($request->transactiondttmpDescription) {
            $transactionDtTmpsId = $transactionDtTmpsIdGet->update([
                'transactiondt_item_description' => $request->transactiondttmpDescription
            ]);
        }

        //return $request->transactionTmpQtyPerPack;
        //return $request->transactionTmpWeight;
        return ApiController::successResponse($transactionDtTmpsId, 200);
    }

    public function fetchTransactionDetailsTmpDQ(Request $request)
    {

        $transactionDetailsTmp = DB::table('transactiontmps')
            ->join('transactiondttmps', 'transactiondttmps.transactiontmp_id', '=', 'transactiontmps.transactiontmp_id')
            ->join('items', 'items.item_id', '=', 'transactiondttmps.item_id')
            ->join('transaction_dts as dtIn', 'dtIn.transactiondt_id', '=', 'transactiondttmps.reference_from_do')
            ->join('transactions as tIn', 'tIn.transaction_id', '=', 'dtIn.transaction_id')
            ->leftjoin('clients', 'clients.client_id', '=', 'transactiondttmps.client_id')
            ->select('tIn.transaction_id',  DB::raw("COALESCE(tIn.transaction_remark, '') as do_remark"),'transactiondttmps.item_quantity', 'transactiondttmps.item_quantity_to_delivery', 'transactiondttmps.item_quantity_to_cancel',
                'clients.client_id', 'clients.client_firstname', 'transactiondttmps.raw_in_grid', 'transactiondttmps.transactiondttmp_price', 'transactiondttmps.group_id',
                'transactiondttmps.palet_no', 'transactiondttmps.transactiondt_item_description as item_description', 'items.item_id', 'items.item_code', 'transactiondttmps.item_weight',
                'transactiondttmps.item_qtyPerPack', 'transactiondttmps.item_pack', 'transactiondttmps.transactiondttmp_nbOfCarton', 'transactiondttmps.transactiondttmp_cellMerge',
                'isMobile', 'transactiondttmps.item_unit', 'transactiondttmp_fprice', 'transactiondttmps.hscode', 'transactiondttmps.transactiondttmp_priceBase')
            ->where([
                ['transactiondttmps.transactiontmp_id', '=', $request->transactionTmpId],
                //['client_items.item_related_client_id',$clientId]
            ])
            ->get();
        return ApiController::successResponse($transactionDetailsTmp, 201);
    }

    public function insertNewDQTransaction(Request $request)
    {
        $user = auth()->user();
        $utilitiesController = new UtilitiesController();
        $historyController = new HistoryController();
        $hitoryArray = array();
        $state = "Insert";
        $date = date('Y-m-d H:i:s');



        // retrieve the current transaction tmp
        $checkTransactionTmpExistance = transactiontmp::where('transactiontmp_id', '=', $request->transactionTmpId)
            ->first();

        // retrieve the current transaction dt tmp
        $transactionDtsTmp = transactiondttmp::join('items', 'items.item_id', '=', 'transactiondttmps.item_id')
            ->select('transactiondttmps.*', 'items.item_hasSerial',)
            ->where('transactiontmp_id', '=', $request->transactionTmpId)
            ->get();


        $checkQtyValidity = $this->checkValidityQty($transactionDtsTmp);
        if (count($checkQtyValidity["invalidTransactions"]) > 0) {
            $obj = array();
            $obj['message'] = 'Invalid Qty Exist';
            $obj['data'] = $checkQtyValidity["invalidTransactions"];
            $obj['type'] = 'qty';
              return ApiController::errorResponse($obj, 422);
        }



        $newTransaction = null;

        if ($checkTransactionTmpExistance) {
            //return ApiController::errorResponse($transactionDtsTmp,422);
            $sequenceNumber = sequence::getSequences($checkTransactionTmpExistance->transactiontmp_type, $checkTransactionTmpExistance->internal_transfer, $checkTransactionTmpExistance->transactiontmp_reference);

            if (!$sequenceNumber) {
                $obj = array();
                $obj['message'] = 'something error in sequence';
                $obj['data'] = $sequenceNumber;
                return ApiController::errorResponse($obj, 422);
            }


            $goodsInSequence = $checkTransactionTmpExistance->transactiontmp_reference ? $checkTransactionTmpExistance->transactiontmp_reference : $sequenceNumber;


            $transaction = array(
                'transaction_reference' => $goodsInSequence,
                'transaction_id' => $checkTransactionTmpExistance->transactiontmp_id,
                'transaction_date' => $checkTransactionTmpExistance->transactiontmp_date,
                'transaction_clientId' => $checkTransactionTmpExistance->transactiontmp_clientId,
                'transaction_type' => $checkTransactionTmpExistance->transactiontmp_type,
                'internal_transfer' => $checkTransactionTmpExistance->internal_transfer,
                'transferTo_clientId' => $checkTransactionTmpExistance->transferTo_clientId,
                'transaction_remark' => $checkTransactionTmpExistance->transactiontmp_remark,
                'transaction_mobileReference' => $checkTransactionTmpExistance->transactiontmp_mobileReference,
                'transaction_shipmentReference' => $checkTransactionTmpExistance->transactiontmp_shipmentReference,
                'transaction_billOfEntry' => $checkTransactionTmpExistance->transactiontmp_billOfEntry,
                'user_id' => $checkTransactionTmpExistance->user_id,
                'transaction_typeOfDeliveryId' => $checkTransactionTmpExistance->transactiontmp_typeOfDeliveryId,
                'forwarder_id' => $checkTransactionTmpExistance->forwarder_id,
                'clientCustomer_id' => $checkTransactionTmpExistance->clientCustomer_id,
                'transaction_driverName' => $checkTransactionTmpExistance->transactiontmp_driverName,
                'transaction_driverPhone' => $checkTransactionTmpExistance->transactiontmp_driverPhone,

                'transaction_vehicleNumber' => $checkTransactionTmpExistance->transactiontmp_vehicleNumber,
                'transaction_exitPoint' => $checkTransactionTmpExistance->transactiontmp_exitPoint,
                'transaction_destinationPoint' => $checkTransactionTmpExistance->transactiontmp_destinationPoint,
                'company_id' => $checkTransactionTmpExistance->company_id,
                'transaction_paymentMethodId' => $checkTransactionTmpExistance->transactiontmp_paymentMethodId,
                'transaction_customBillTypeId' => $checkTransactionTmpExistance->transactiontmp_customBillTypeId,
                'transaction_currencyId' => $checkTransactionTmpExistance->transactiontmp_currencyId,
                'transaction_rate' => $checkTransactionTmpExistance->transactiontmp_rate,
                'transaction_shipmentTypeId' => $checkTransactionTmpExistance->transactiontmp_shipmentTypeId,
                'transaction_shipById' => $checkTransactionTmpExistance->transactiontmp_shipById,
                'transaction_shipmentRemark' => $checkTransactionTmpExistance->transactiontmp_shipmentRemark,
                'transaction_supplierId' => $checkTransactionTmpExistance->transactiontmp_supplierId,
                'transaction_supplierInvoice' => $checkTransactionTmpExistance->transactiontmp_supplierInvoice,
                'transaction_totalQty' => $checkTransactionTmpExistance->transactiontmp_totalQty,
                'transaction_totalPallet' => $checkTransactionTmpExistance->transactiontmp_totalPallet,
                'transaction_totalPrice' => $checkTransactionTmpExistance->transaction_totalPrice,
                'transaction_totalItem' => $checkTransactionTmpExistance->transaction_totalItem,
                'Invoice_type_id' => $checkTransactionTmpExistance->Invoice_type_id,
                'payment_term_id' => $checkTransactionTmpExistance->payment_term_id,
                'delivery_term_id' => $checkTransactionTmpExistance->delivery_term_id,
                'exemption_type_id' => $checkTransactionTmpExistance->exemption_type_id,

            );
            $clients = array(
                'table' => 'clients',
                'column' => 'client_id',
                'value' => $checkTransactionTmpExistance->transactiontmp_clientId,
                'selectedValue' => 'client_firstname',
                'replaceColumn' => 'transaction_clientId'
            );
            $customers = array(
                'table' => 'client_customers',
                'column' => 'customer_id',
                'value' => $checkTransactionTmpExistance->clientCustomer_id,
                'selectedValue' => 'customer_name',
                'replaceColumn' => 'clientCustomer_id'
            );
            $forwarders = array(
                'table' => 'client_forwarders',
                'column' => 'clientforwarder_id',
                'value' => $checkTransactionTmpExistance->forwarder_id,
                'selectedValue' => 'clientforwarder_name',
                'replaceColumn' => 'forwarder_id'
            );
            array_push($hitoryArray, $clients);
            array_push($hitoryArray, $customers);
            array_push($hitoryArray, $forwarders);

            if ($checkTransactionTmpExistance && !$checkTransactionTmpExistance->transactiontmp_reference) {
                $newTransaction = transactions::create($transaction);
               
            } else {
                $state = "Update";
                transactions::where('transaction_id', '=', $request->transactionId)->update($transaction);
                $newTransaction = transactions::where('transaction_id', '=', $request->transactionId)->first();
            }

            if ($newTransaction) {

                if ($request->transactionId) {
                    transactiondt::where('transaction_id', '=', $request->transactionId)->delete();
                }
                //return ApiController::errorResponse($transactionDtsTmp,422);
                $insertDtFound = array();
                foreach ($transactionDtsTmp as $transactionDtTmp) {
                    if ($transactionDtTmp->item_quantity == 0) {
                        continue;
                    } else {

                        $transactionDtArray = array(
                            'transactiondt_id' => $transactionDtTmp->transactiondttmp_id,
                            'transaction_id' => $newTransaction->transaction_id,
                            'item_id' => $transactionDtTmp->item_id,
                            'client_id' => $transactionDtTmp->client_id,
                            'item_quantity' => $transactionDtTmp->item_quantity,
                            'supplier_id' => $transactionDtTmp->supplier_id,
                            'supplier_invoice_number' => $transactionDtTmp->supplier_invoice_number,
                            'transactiondt_locationid' => $transactionDtTmp->transactiondttmp_locationid,
                            'transactiondt_countryOfOrigin' => $transactionDtTmp->transactiondttmp_countryOfOrigin,
                            'transactiondt_price' => $transactionDtTmp->transactiondttmp_price,
                            'id_reference_dt' => null,
                            'transactiondt_billOfEntry' => $transactionDtTmp->transactiontmpdt_billOfEntry,
                            'raw_in_grid' => $transactionDtTmp->raw_in_grid,
                            'item_weight' => $transactionDtTmp->item_weight,
                            'item_unit' => $transactionDtTmp->item_unit,
                            'item_qtyPerPack' => $transactionDtTmp->item_qtyPerPack,
                            'item_pack' => $transactionDtTmp->item_pack,
                            'group_id' => $transactionDtTmp->group_id,
                            'palet_no' => $transactionDtTmp->palet_no,
                            'transactiondt_nbOfCarton' => $transactionDtTmp->transactiondttmp_nbOfCarton,
                            'transactiondt_cellMerge' => $transactionDtTmp->transactiondttmp_cellMerge,
                            'transactiondt_BOE' => '-',
                            'client_id' => $transactionDtTmp->client_id,
                            'transactiondt_fprice' => $transactionDtTmp->transactiondttmp_fprice,
                            'transactiondt_fpriceBase' => $transactionDtTmp->transactiondttmp_fpriceBase,
                            'transactiondt_priceBase' => $transactionDtTmp->transactiondttmp_priceBase,
                            'hscode' => $transactionDtTmp->hscode,
                            'transactiondt_item_description' => $transactionDtTmp->transactiondt_item_description,
                            'item_quantity_to_delivery' => $transactionDtTmp->item_quantity_to_delivery,
                            'item_quantity_to_cancel' => $transactionDtTmp->item_quantity_to_cancel,
                            'reference_from_do' => $transactionDtTmp->reference_from_do,
                            'dt_transaction_type' => $transactionDtTmp->dt_transaction_type,
                        );
                        array_push($insertDtFound, $transactionDtTmp->transactiondttmp_id);
                    }


                    $newTransactionDt = transactiondt::create($transactionDtArray);
                }


                if ($newTransaction) {
                    $transactionIndex = $historyController->insertTransactionHistoryDataByRef(
                        $state,
                        $newTransaction->transaction_reference,
                        auth()->user()->id,
                        $date,
                        $newTransaction->transaction_type
                    );
                    transactiontmp::where('transactiontmp_id', '=', $request->transactionTmpId)->delete();
                    TransactiontmpPalets::where('transactiontmp_id', '=', $request->transactionTmpId)->delete();

                    // delete transaction details from tmp table
                    foreach ($transactionDtsTmp as $transactionDetailTmp) {
                        transactionDtSnTmp::where('transactiondttmp_id', '=', $transactionDetailTmp->transactiondttmp_id)->delete();
                    }
                    transactiondttmp::where('transactiontmp_id', '=', $request->transactionTmpId)->delete();
                }
            }

        }

        return ApiController::errorResponse('error', 200);
    }



















    public function calculateExistQtyDQ($quantity, $transactiondt_id, $transaction_id)
    {
    
        $tmpQty = DB::table('transactiondttmps')
            ->where([['reference_from_do', $transactiondt_id], ['transactiontmp_id', $transaction_id]])
            ->groupBy('reference_from_do')
            ->sum(DB::raw('item_quantity_to_delivery + item_quantity_to_cancel'));
         
        $usedDeliveredQty = DB::table('transaction_dts')
            ->where([['reference_from_do', $transactiondt_id], ['transaction_id', '!=',$transaction_id]])
            ->groupBy('reference_from_do')
            ->sum(DB::raw('item_quantity_to_delivery + item_quantity_to_cancel'));


           
        return $quantity - ($usedDeliveredQty + $tmpQty);
    }

    public function removeOriginalDQTransaction(Request $request)
    {
        $user = auth()->user();
        $date = date('Y-m-d H:i:s');
        $transactionId=$request->transactionId;
        $utilitiesController = new UtilitiesController();

        $checkExsistance = transactiontmp::where('transactiontmp_id', '=', $transactionId)
            ->join('users', 'users.id', '=', 'transactiontmps.user_id')
            ->join('clients', 'clients.client_id', '=', 'transactiontmps.transactiontmp_clientId')
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactiontmps.clientCustomer_id')
            ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactiontmps.forwarder_id')
            ->orderBy('transactiontmp_date', 'asc')
            ->first();

        if ($checkExsistance) {
            $type = "Delivered QTY";

            return ApiController::errorResponse($type . '  exists in drafts !(By : ' . $checkExsistance->user_name . ')', 422);
        }

        $salesJvId=transactions::where('transaction_id', $transactionId)->first();

        if(isset($salesJvId->salesjv_id)){
            $config = array(
                "salesjvId" => $salesJvId->salesjv_id,
            );
            $utilitiesController->connectDataToErp("deleteInvoiceFromLogisticom", $config);
        }


        $transactions=transactions::where('transaction_id', $transactionId)->delete();


            return ApiController::successResponse($transactions, 200);




    }


    function generateInvoiceAfterSave( $transactionId,$service){

        $ChargeTempalteController=new ChargeTempalteController();
        $fetchCharges=$ChargeTempalteController->fetchChargeTemplateByTransactionFuntion($transactionId,$service);


     //   $ChargeTempalteController->generateInvoicesByTransactionTypeFunction($isShipment,$salesJvId,$transactionId,$details,$ledgerNumber,$currency);

    }


    public function checkValidityQty($transactionDtsTmp){

        $invalidTransactionsIndex=array();

        foreach($transactionDtsTmp as $splitData){

            
            $quantity = transactionDt::where('transactiondt_id',$splitData -> reference_from_do)
            ->sum('item_quantity');
            $transactiondt_id =  $splitData -> reference_from_do;
            $DQTransactionId =  $splitData -> transactiontmp_id;

            $existQty = $this->calculateExistQtyDQ($quantity, $transactiondt_id, $DQTransactionId);
         
            if($existQty <0){
                array_push($invalidTransactionsIndex ,$splitData );
            }
        }
       




        $obj["invalidTransactions"] = $invalidTransactionsIndex;
        return $obj;

    }

}
