<?php

namespace App\Http\Controllers\BackOffice\ClientShipment;

use App\Http\Controllers\ApiController;
use App\Models\client;
use App\Models\clientShipment;
use App\Models\transactions;
use App\Models\transactiontmp;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use JWTAuth;

class ClientShipmentController extends ApiController
{
    public function fetchClientShipments(Request $request)
    {

        $client_id = '';
        if ($request->clientId) {
            $client_id = $request->clientId;
        } else {
            $user_id = JWTAuth::user()->id;
            $client_id = client::where('user_id', $user_id)->first()->client_id;
        }

        $transferStatus = 'Air';
        $clientShipments = clientShipment::leftjoin('set_ups as setup_shipmentTransfer', 'setup_shipmentTransfer.setup_id', '=', 'client_shipments.shipment_transfer')
            ->leftjoin('set_ups as setup_shipmentType', 'setup_shipmentType.setup_id', '=', 'client_shipments.shipment_type')
            ->leftjoin('set_ups as setup_shipmentStatus', 'setup_shipmentStatus.setup_id', '=', 'client_shipments.shipment_status')
            ->where([
                ['shipment_related_clientid', '=', $client_id],
                ['isActive', true],
            ])
            ->select('shipment_id',
                'shipment_transfer',
                'shipment_type',
                'shipment_creation_date',
                'shipment_related_clientid',
                'shipment_trackinglink',
                'shipment_status',
                'shipment_reference',
                'shipment_cbm',
                'shipment_airWayBill',
                'shipment_billOfLading',
                'setup_shipmentTransfer.setup_key as shipmenttransfer_key',
                'setup_shipmentTransfer.setup_value as shipmenttransfer_value',
                'setup_shipmentType.setup_key as shipmenttype_key',
                'setup_shipmentType.setup_value as shipmenttype_value',
                'setup_shipmentStatus.setup_key as shipmentstatus_key',
                'setup_shipmentStatus.setup_value as shipmentstatus_value')
            ->selectRaw("(case when ( setup_shipmentTransfer.setup_key ) = '" . $transferStatus . "' THEN (client_shipments.shipment_airWayBill)
            else (client_shipments.shipment_billOfLading) END ) as shipment_receipttype");


        //   if($request->transactionType=='GOODS_IN'){
        $getShipmentTransferId = DB::table('set_ups')->where([
            ['setup_type', 'like', 'shipment_type'],
            ['setup_key', 'like', 'inward']
        ])
            ->select('setup_id')
            ->first();
        $clientShipments->where([
            ['shipment_type', '=', $getShipmentTransferId->setup_id]
        ]);

        //   }
        $clientShipments = $clientShipments->get();
        return ApiController::successResponse($clientShipments, 200);
    }

    public function insertClientShipment(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'shipmentTransfer' => 'required',
            'shipmentType' => 'required',
            'shipmentReceiptType' => 'required',
            //'shipmentTrackingLink' => 'required',
            'shipmentStatus' => 'required',
            //'shipmentCbm' => 'required',
            'clientId' => 'required',
            'shipmentReference' => 'required'
        ]);

        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }
        $getShipmentTransferId = DB::table('set_ups')->where([
            ['setup_type', 'like', 'Shipby'],
            ['setup_key', 'like', $request->shipmentTransfer]
        ])
            ->select('setup_id')
            ->first();

        $clientShipment = array(
            'shipment_transfer' => $getShipmentTransferId->setup_id,
            'shipment_type' => $request->shipmentType,
            //'shipment_receipttype' => $request->shipmentReceiptType,
            'shipment_trackinglink' => $request->shipmentTrackingLink,
            'shipment_reference' => $request->shipmentReference,
            'shipment_status' => $request->shipmentStatus,
            'shipment_cbm' => $request->shipmentCbm,
            'shipment_related_clientid' => $request->clientId,
            'shipment_creation_date' => time(),
            'shipment_airWayBill' => $request->shipmentTransfer == 'Air' ? $request->shipmentReceiptType : null,
            'shipment_billOfLading' => $request->shipmentTransfer == 'Sea' ? $request->shipmentReceiptType : null,
        );

        $newClientShipment = clientShipment::create($clientShipment);

        if ($newClientShipment) {
            return ApiController::successResponse($newClientShipment, 200);
        }
        return ApiController::errorResponse($newClientShipment, 422);
    }

    public function updateClientShipment(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'shipmentTransfer' => 'required',
            'shipmentType' => 'required',
            //'shipmentReceiptType' => 'required',
            //'shipmentTrackingLink' => 'required',
            'shipmentStatus' => 'required',
            //'shipmentCbm' => 'required'
            'shipmentReference' => 'required',
        ]);

        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }

        $getShipmentTransferId = DB::table('set_ups')->where([
            ['setup_type', 'like', 'Shipby'],
            ['setup_key', 'like', $request->shipmentTransfer]
        ])
            ->select('setup_id')
            ->first();

        $clientShipment = array(
            'shipment_transfer' => $getShipmentTransferId->setup_id,
            'shipment_type' => $request->shipmentType,
            //'shipment_receipttype' => $request->shipmentReceiptType,
            'shipment_trackinglink' => $request->shipmentTrackingLink,
            'shipment_status' => $request->shipmentStatus,
            'shipment_cbm' => $request->shipmentCbm,
            'shipment_reference' => $request->shipmentReference,
            'shipment_airWayBill' => $request->shipmentTransfer == 'Air' ? $request->shipmentReceiptType : null,
            'shipment_billOfLading' => $request->shipmentTransfer == 'Sea' ? $request->shipmentReceiptType : null,
        );

        $updateClientShipment = clientShipment::where('shipment_id', $request->clientShipmentId)->update($clientShipment);

        if ($updateClientShipment) {
            return ApiController::successResponse($updateClientShipment, 200);
        }
        return ApiController::errorResponse($updateClientShipment, 200);
    }

    function removeClientShipment(Request $request)
    {
        $checkClientTransactions = transactions::where('transaction_shipmentReference', $request->shipmentId)->first();
        $checkClientTransactionsTmp = transactiontmp::where('transactiontmp_shipmentReference', $request->shipmentId)->first();

        if ($checkClientTransactions || $checkClientTransactionsTmp) {
//                      clientShipment::where('shipment_id',$request->shipmentId)->update([
//                       'isActive' => false,
//                      ]);
            return ApiController::errorResponse('User successfully deleted', 209);

        } else {
            clientShipment::where('shipment_id', $request->shipmentId)->delete();

            return ApiController::successResponse('User successfully deleted', 200);
        }


    }
}
