<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\BackOffice\AccessManager\RolesController;
use App\Http\Controllers\BackOffice\Charging\ChargeTempalteController;
use App\Http\Controllers\BackOffice\Client\ClientController;
use App\Http\Controllers\BackOffice\Client\ClientStorageController;
use App\Http\Controllers\BackOffice\ClientCustomer\ClientCustomerController;
use App\Http\Controllers\BackOffice\ClientForwarder\ClientForwarderController;
use App\Http\Controllers\BackOffice\ClientItem\ClientItemController;
use App\Http\Controllers\BackOffice\ClientShipment\ClientShipmentController;
use App\Http\Controllers\BackOffice\ClientSupplier\ClientSupplierController;
use App\Http\Controllers\BackOffice\Companies\CompanyController;
use App\Http\Controllers\BackOffice\Country\CountryController;
use App\Http\Controllers\BackOffice\Currency\CurrencyController;
use App\Http\Controllers\BackOffice\Dashboard\DashboardController;
use App\Http\Controllers\BackOffice\DataEntry\DataEntryController;

use App\Http\Controllers\BackOffice\DO\DOController;
use App\Http\Controllers\BackOffice\DQ\DQController;
use App\Http\Controllers\BackOffice\DO\DoSerialsController;
use App\Http\Controllers\BackOffice\GoodsIn\GoodsInController;
use App\Http\Controllers\BackOffice\GoodsIn\GoodsInSerialsController;
use App\Http\Controllers\BackOffice\GoodsIn\StoragePalletController;
use App\Http\Controllers\BackOffice\History\HistoryController;
use App\Http\Controllers\BackOffice\Items\ItemGroupController;
use App\Http\Controllers\BackOffice\Items\ItemsController;
use App\Http\Controllers\BackOffice\Items\ItemsStatementController;
use App\Http\Controllers\BackOffice\Locations\LocationsController;
use App\Http\Controllers\BackOffice\Notifications\NotificationsController as BackOfficeNotifications;
use App\Http\Controllers\BackOffice\Reports\ClientStorageReportsController;
use App\Http\Controllers\BackOffice\Reports\DeliveryReportsController;
use App\Http\Controllers\BackOffice\Reports\GoodsInReportsController;
use App\Http\Controllers\BackOffice\Reports\InventoryController;
use App\Http\Controllers\BackOffice\Reports\ReportController;
use App\Http\Controllers\BackOffice\Reports\TestReportController;
use App\Http\Controllers\BackOffice\SerialTypes\SerialTypesController;
use App\Http\Controllers\BackOffice\Setup\SetupController;
use App\Http\Controllers\BackOffice\TO\TOController;
use App\Http\Controllers\BackOffice\User\UserController as CustomUserController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Http\Controllers\mobile\Customers\CustomerController;
use App\Http\Controllers\mobile\Delivery\DeliveryController;
use App\Http\Controllers\mobile\Notifications\NotificationsController;
use App\Http\Controllers\mobile\RMA\RMAController;
use App\Http\Controllers\mobile\Users\UserController as MobileUserController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\BackOffice\Internal\InternalController;
use App\Http\Controllers\BackOffice\Transactions\TransactionController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

/*******************************************START : MILED *****************************/
Route::post('/fetchClients', [ClientController::class, 'fetchClients'])->middleware(['jwt.verify']);
Route::post('/insertClient', [ClientController::class, 'insertClient'])->middleware(['jwt.verify']);
Route::put('/updateClient/{clientId}', [ClientController::class, 'updateClient'])->middleware(['jwt.verify']);
Route::delete('/removeClient/{clientId}', [ClientController::class, 'removeClient'])->middleware(['jwt.verify']);
Route::post('/checkClientLedgerName', [ClientController::class, 'checkClientLedgerName'])->middleware(['jwt.verify']);
Route::put('/resetPassword/{clientId}', [ClientController::class, 'resetPassword'])->middleware(['jwt.verify']);


Route::get('/fetchClientItems/{clientId}/{searchValue?}', [ClientItemController::class, 'fetchClientItems'])->middleware(['jwt.verify']);
Route::post('/insertClientItem', [ClientItemController::class, 'insertClientItem'])->middleware(['jwt.verify']);
Route::put('/updateClientItem/{clientItemId}', [ClientItemController::class, 'updateClientItem'])->middleware(['jwt.verify']);

// Route::get('/fetchClientSuppliers/{clientId}/{searchValue?}', [ClientSupplierController::class, 'fetchClientSuppliers'])->middleware(['jwt.verify']);
// Route::post('/insertClientSupplier', [ClientSupplierController::class, 'insertClientSupplier'])->middleware(['jwt.verify']);
// Route::put('/updateClientSupplier/{clientSupplierId}', [ClientSupplierController::class, 'updateClientSupplier'])->middleware(['jwt.verify']);

Route::get('/fetchClientCustomers/{clientId}/{searchValue?}', [ClientCustomerController::class, 'fetchClientCustomers'])->middleware(['jwt.verify']);
Route::post('/insertClientCustomer', [ClientCustomerController::class, 'insertClientCustomer'])->middleware(['jwt.verify']);
Route::put('/updateClientCustomer/{clientCustomerId}', [ClientCustomerController::class, 'updateClientCustomer'])->middleware(['jwt.verify']);

Route::get('/fetchClientShipments/{clientId?}', [ClientShipmentController::class, 'fetchClientShipments'])->middleware(['jwt.verify']);
Route::post('/insertClientShipment', [ClientShipmentController::class, 'insertClientShipment'])->middleware(['jwt.verify']);
Route::put('/updateClientShipment/{clientShipmentId}', [ClientShipmentController::class, 'updateClientShipment'])->middleware(['jwt.verify']);

Route::POST('/fetchClientForwarders', [ClientForwarderController::class, 'fetchClientForwarders'])->middleware(['jwt.verify']);
Route::post('/insertClientForwarder', [ClientForwarderController::class, 'insertClientForwarder'])->middleware(['jwt.verify']);
Route::put('/updateClientForwarder/{clientForwarderId}', [ClientForwarderController::class, 'updateClientForwarder'])->middleware(['jwt.verify']);
Route::post('/uploadFile', [ClientForwarderController::class, 'uploadFile'])->middleware(['jwt.verify']);
Route::post('/removePublicFile', [ClientForwarderController::class, 'removePublicFile'])->middleware(['jwt.verify']);
Route::get('/fetchFilesByForwarder/{forwarderId}', [ClientForwarderController::class, 'fetchFilesByForwarder'])->middleware(['jwt.verify']);
Route::delete('/removeForwarder/{forwarderId}', [ClientForwarderController::class, 'removeForwarder'])->middleware(['jwt.verify']);


Route::post('/createTransactionTmp', [GoodsInController::class, 'createTransactionTmp'])->middleware(['jwt.verify']);
Route::post('/insertNewTransaction', [GoodsInController::class, 'insertNewTransaction'])->middleware(['jwt.verify']);
Route::post('/importGOODSDetail', [GoodsInController::class, 'importTransactionDetailsFromExcel'])->middleware(['jwt.verify']);


Route::put('/updateTransaction/{transactionId}', [GoodsInController::class, 'updateTransaction'])->middleware(['jwt.verify']);
Route::post('/fetchTransactions', [GoodsInController::class, 'fetchTransactions'])->middleware(['jwt.verify']);
Route::get('/fetchClientDetails/{clientId}', [GoodsInController::class, 'fetchClientDetails'])->middleware(['jwt.verify']);
Route::get('/fetchTransactionDetails/{transactionId}', [GoodsInController::class, 'fetchTransactionDetails'])->middleware(['jwt.verify']);
Route::get('/checkTransactionUpdateValidity/{transactionId}/{billOfEntry}', [GoodsInController::class, 'checkTransactionUpdateValidity'])->middleware(['jwt.verify']);
Route::get('/addDoFromGoodsIn/{transactionId}', [GoodsInController::class, 'addDoFromGoodsIn'])->middleware(['jwt.verify']);
Route::post('/ExportDraftGoodIn', [GoodsInController::class, 'ExportDraftGoodIn'])->middleware(['jwt.verify']);
Route::post('/addDOFromMultipleGoodsIn', [GoodsInController::class, 'addDOFromMultipleGoodsIn'])->middleware(['jwt.verify']);


Route::get('/fetchTransactionDtSerials/{transactiondtId}', [GoodsInController::class, 'fetchTransactionDtSerials'])->middleware(['jwt.verify']);
Route::post('/insertTransactionDtSerials', [GoodsInController::class, 'insertTransactionDtSerials'])->middleware(['jwt.verify']);
Route::put('/updateTransactionDtSerialsItem/{transactionDtId}', [GoodsInController::class, 'updateTransactionDtSerialsItem'])->middleware(['jwt.verify']);
Route::post('/storeTransactionDtTmp', [GoodsInController::class, 'storeTransactionDtTmp'])->middleware(['jwt.verify']);
Route::post('/storeTransactionDtTmpGoodsIn', [GoodsInController::class, 'storeTransactionDtTmpGoodsIn'])->middleware(['jwt.verify']);
Route::post('/fetchRemainingGoodsInTransactions', [GoodsInController::class, 'fetchRemainingGoodsInTransactions'])->middleware(['jwt.verify']);


Route::get('/fetchTransactionDetailsTmp/{transactionTmpId}', [GoodsInController::class, 'fetchTransactionDetailsTmp'])->middleware(['jwt.verify']);
Route::get('/fetchPendingTransactions/{transactionType}/{transactionTmpId?}', [GoodsInController::class, 'fetchPendingTransactions'])->middleware(['jwt.verify']);
Route::put('/updateUserIdIntransactionTmp/{transactionTmpId}', [GoodsInController::class, 'updateUserIdIntransactionTmp'])->middleware(['jwt.verify']);

Route::get('/fetchMobilePendingTransactions/{transactionType}', [GoodsInController::class, 'fetchMobilePendingTransactions'])->middleware(['jwt.verify']);
Route::delete('/cancelTransactionTmpTable/{transactionTmpId}', [GoodsInController::class, 'cancelTransactionTmpTable'])->middleware(['jwt.verify']);
Route::get('/getNextReference/{transactionType}', [GoodsInController::class, 'getNextReference'])->middleware(['jwt.verify']);
Route::post('/insertTransactionDtSerialTmp', [GoodsInController::class, 'insertTransactionDtSerialTmp'])->middleware(['jwt.verify']);

Route::delete('/removeTransactionDtTmp/{transactionDtTmpId}', [GoodsInController::class, 'removeTransactionDtTmp'])->middleware(['jwt.verify']);
Route::delete('/removeTransactionDtTmpDO/{raw_in_grid}/{transactionTmpId}', [DOController::class, 'removeTransactionDtTmpDO'])->middleware(['jwt.verify']);
Route::delete('/removeTransactionDtSerial/{transactiondtsntmp_id}', [GoodsInController::class, 'removeTransactionDtSerial'])->middleware(['jwt.verify']);
Route::delete('/removeOriginalTransaction/{transactionId}', [GoodsInController::class, 'removeOriginalTransaction'])->middleware(['jwt.verify']);

Route::delete('/removeTransactionDtTmpDOFromMObile/{transactionTmpId}/{itemId}', [GoodsInController::class, 'removeTransactionDtTmpDOFromMObile'])->middleware(['jwt.verify']);


Route::post('/insertNewDOTransaction', [DOController::class, 'insertNewDOTransaction'])->middleware(['jwt.verify']);


Route::put('/updateTransactionDtTmpPriceDO/{raw_in_grid}/{transactionTmpId}', [DOController::class, 'updateTransactionDtTmpPriceDO'])->middleware(['jwt.verify']);

Route::get('/fetchSerialsTmp/{transactiondttmp_id}', [GoodsInController::class, 'fetchSerialsTmp'])->middleware(['jwt.verify']);


Route::get('/fetchTransactionDetailsDO/{transactionId}/{rawInGrid?}', [GoodsInController::class, 'fetchTransactionDetailsDO'])->middleware(['jwt.verify']);


Route::get('/getUtilities', [UtilitiesController::class, 'getUtilities'])->middleware(['jwt.verify']);
Route::post('/convertDateTimestamp', [UtilitiesController::class, 'convertDateTimestamp']);
Route::get('/getCompanyRange', [UtilitiesController::class, 'getCompanyRange'])->middleware(['jwt.verify']);


Route::get('/getUserInfo', [CustomUserController::class, 'getUserInfo']);
Route::post('/login', [CustomUserController::class, 'login']);
Route::get('/getUsers', [CustomUserController::class, 'getUsers'])->middleware(['jwt.verify']);

Route::post('/createTransactionTmpGoodsIn', [GoodsInController::class, 'createTransactionTmpGoodsIn'])->middleware(['jwt.verify']);
Route::post('/createTransactionTmpDO', [DOController::class, 'createTransactionTmpDO'])->middleware(['jwt.verify']);

/*******************************************END : MILED *****************************/


// reports

Route::post('/transactionReport', [GoodsInController::class, 'transactionReport']);

Route::post('/uploadDocumentsByTransaction', [GoodsInController::class, 'uploadDocumentsByTransaction'])->middleware(['jwt.verify']);
Route::get('/fetchDocumentsByTransactionIdAndType/{transactionType}/{transactionId}', [GoodsInController::class, 'fetchDocumentsByTransactionIdAndType'])->middleware(['jwt.verify']);
Route::post('/removeDocument', [GoodsInController::class, 'removeDocument'])->middleware(['jwt.verify']);
Route::post('/generateInvoicesByTransactionType', [ChargeTempalteController::class, 'generateInvoicesByTransactionType'])->middleware(['jwt.verify']);

//wnd reports


//mobile
Route::post('/fetchItems', [DeliveryController::class, 'fetchItems'])->middleware(['jwt.verify']);


//mobile
Route::post('/signIn', [MobileUserController::class, 'signIn']);
Route::post('/resetPassword', [MobileUserController::class, 'reset_password']);
Route::post('/newPassword', [MobileUserController::class, 'new_password']);
Route::post('/updateUserInfo', [MobileUserController::class, 'updateUserInfo'])->middleware(['jwt.verify']);
Route::get('/fetchCountries', [MobileUserController::class, 'fetchCountries'])->middleware(['jwt.verify']);
Route::post('/refreshToken', [MobileUserController::class, 'refreshToken']);
Route::post('/fetchMobileInventoryItems', [DeliveryController::class, 'fetchMobileInventoryItems'])->middleware(['jwt.verify']);

Route::get('/testPdf', [MobileUserController::class, 'testPdf']);
Route::get('/tmpApi', [DeliveryController::class, 'tmpApi'])->middleware(['jwt.verify']);
Route::post('/changeClientPassword', [MobileUserController::class, 'changeClientPassword'])->middleware(['jwt.verify']);

Route::post('/changeClientPassword', [MobileUserController::class, 'changeClientPassword'])->middleware(['jwt.verify']);

//Route::get('/fetchItems/{skip}/{take}/{searchValue?}', [DeliveryController::class, 'fetchItems'])->middleware(['jwt.verify']);


Route::post('/sendNotification', [NotificationsController::class, 'sendNotification']);
Route::post('/getNotifications', [NotificationsController::class, 'getNotifications'])->middleware(['jwt.verify']);
Route::get('/fetchCustomUserNotificationRoles/{userId}', [BackOfficeNotifications::class, 'fetchCustomUserNotificationRoles'])->middleware(['jwt.verify']);
Route::post('/insertCustomNotificationByUser', [BackOfficeNotifications::class, 'insertCustomNotificationByUser'])->middleware(['jwt.verify']);



Route::post('/fetchCustomers', [CustomerController::class, 'fetchCustomers'])->middleware(['jwt.verify']);
Route::post('/getCustomerForClient', [CustomerController::class, 'getCustomerForClient'])->middleware(['jwt.verify']);

Route::post('/searchCustomer', [CustomerController::class, 'searchCustomer'])->middleware(['jwt.verify']);
Route::post('/newCustomer', [CustomerController::class, 'newCustomer'])->middleware(['jwt.verify']);
Route::delete('/removeClientCustomer/{customerId}', [ClientCustomerController::class, 'removeClientCustomer'])->middleware(['jwt.verify']);
Route::delete('/removeClientShipment/{shipmentId}', [ClientShipmentController::class, 'removeClientShipment'])->middleware(['jwt.verify']);

Route::post('/fetchDeliveryOrders', [DeliveryController::class, 'fetchDeliveryOrders'])->middleware(['jwt.verify']);
Route::get('/fetchPendingDeliveryOrders/{clientId?}', [DeliveryController::class, 'fetchPendingDeliveryOrders'])->middleware(['jwt.verify']);


Route::get('/fetchInventoryItems', [UtilitiesController::class, 'fetchInventoryItems'])->middleware(['jwt.verify']);
Route::get('/fetchSetUps', [UtilitiesController::class, 'fetchSetUps'])->middleware(['jwt.verify']);


Route::post('/fetchDeliveryItems', [DeliveryController::class, 'fetchDeliveryItems'])->middleware(['jwt.verify']);
Route::post('/newDeliveryItem', [DeliveryController::class, 'newDeliveryItem'])->middleware(['jwt.verify']);
Route::post('/searchDeliveryItem', [DeliveryController::class, 'searchDeliveryItem'])->middleware(['jwt.verify']);
Route::post('/newDeliveryTransaction', [DeliveryController::class, 'newDeliveryTransaction'])->middleware(['jwt.verify']);
Route::post('/fetchRMAINOrders', [RMAController::class, 'fetchRMAINOrders'])->middleware(['jwt.verify']);

Route::post('/fetchRMAINItems', [RMAController::class, 'fetchRMAINItems'])->middleware(['jwt.verify']);


Route::post('/fetchPendingRMAINOrders', [RMAController::class, 'fetchPendingRMAINOrders'])->middleware(['jwt.verify']);
Route::get('/check_serial', [DeliveryController::class, 'check_serial'])->middleware(['jwt.verify']);

Route::post('/newRMAINTransaction', [RMAController::class, 'newRMAINTransaction'])->middleware(['jwt.verify']);
Route::get('/fetchTransactionDtPerItem/{clientId}/{itemId}', [DeliveryController::class, 'fetchTransactionDtPerItem'])->middleware(['jwt.verify']);
Route::get('/returnToTmpTransaction/{transactionId}', [GoodsInController::class, 'returnToTmpTransaction'])->middleware(['jwt.verify']);
Route::get('/fetchClientMobileForwarders/{searchValue?}', [CustomerController::class, 'fetchClientMobileForwarders'])->middleware(['jwt.verify']);
Route::get('/goodsInInvoicePdf/{transactionId}', [ReportController::class, 'goodsInInvoicePdf']);
Route::get('/goodsInSeriaslInvoicePdf/{transactionId}', [ReportController::class, 'goodsInSeriaslInvoicePdf']);
Route::get('/getGoodInSerialData/{transactionId}', [ReportController::class, 'getGoodInSerialData'])->middleware(['jwt.verify']);

Route::get('/DOSeriaslInvoicePdf/{transactionId}', [ReportController::class, 'DOSeriaslInvoicePdf']);
Route::get('/getDOData/{transactionId}', [ReportController::class, 'getDOData'])->middleware(['jwt.verify']);
Route::get('/doInvoicePdf/{transactionId}', [ReportController::class, 'doInvoicePdf']);
Route::get('/getGoodInInvoiceData/{transactionId}', [ReportController::class, 'getGoodInInvoiceData'])->middleware(['jwt.verify']);

Route::post('/importGoodIn', [GoodsInController::class, 'importGoodIn'])->middleware(['jwt.verify']);


//inventory reports

Route::get('/printInventoryReport/{transactionDataId}', [InventoryController::class, 'printInventoryReport']);
Route::post('/inventoryPdfData', [InventoryController::class, 'inventoryPdfData'])->middleware(['jwt.verify']);
Route::get('/inventoryReportData/{transactionDataId}', [InventoryController::class, 'inventoryReportData1'])->middleware(['jwt.verify']);
Route::post('/fetchInventoryReport', [InventoryController::class, 'fetchInventoryReport'])->middleware(['jwt.verify']);


//end inventory reports


//start report api create by mhmd
Route::get('/generateCommercialInvoicePdf/{transactionId}', [ReportController::class, 'generateCommercialInvoicePdf']);
Route::get('/TransferOfOwnershipInvoicePdf/{transactionId}', [ReportController::class, 'TransferOfOwnershipInvoicePdf']);
Route::get('/deliveryAdviceInvoicePdf/{transactionId}', [ReportController::class, 'deliveryAdviceInvoicePdf']);
Route::get('/deliveryNoteInvoicePdf/{transactionId}', [ReportController::class, 'deliveryNoteInvoicePdf']);
Route::get('/pickingListInvoicePdf/{transactionId}', [ReportController::class, 'pickingListInvoicePdf']);


Route::get('/DeliveryPdf/{transactionId}', [ReportController::class, 'DeliveryPdf']);
Route::get('/deliveryReportData/{transactionId}', [ReportController::class, 'deliveryReportData'])->middleware(['jwt.verify']);


Route::get('/generatePDF', [TestReportController::class, 'generatePDF']);


// end report api


//country start
Route::get('/fetchCountry', [CountryController::class, 'fetchCountry'])->middleware(['jwt.verify']);
Route::delete('/removeCountry/{countryId}', [CountryController::class, 'removeCountry'])->middleware(['jwt.verify']);
Route::post('/insertCountry', [CountryController::class, 'insertCountry'])->middleware(['jwt.verify']);
Route::put('/updateCountry/{countryId}', [CountryController::class, 'updateCountry'])->middleware(['jwt.verify']);


//end start

//location start
Route::get('/fetchLocation', [LocationsController::class, 'fetchLocation'])->middleware(['jwt.verify']);
Route::delete('/removeLocation/{locationId}', [LocationsController::class, 'removeLocation'])->middleware(['jwt.verify']);
Route::post('/insertLocation', [LocationsController::class, 'insertLocation'])->middleware(['jwt.verify']);
Route::put('/updateLocation/{locationId}', [LocationsController::class, 'updateLocation'])->middleware(['jwt.verify']);
//location start

// items group

Route::post('/insertNewGroup', [ItemGroupController::class, 'insertNewGroup'])->middleware(['jwt.verify']);
Route::post('/fetchGroups', [ItemGroupController::class, 'fetchGroups'])->middleware(['jwt.verify']);
Route::put('/updateGroup/{groupId}', [ItemGroupController::class, 'updateGroup'])->middleware(['jwt.verify']);
Route::delete('/removeGroup/{groupId}', [ItemGroupController::class, 'removeGroup'])->middleware(['jwt.verify']);
Route::delete('/removeItem/{itemId}', [ItemsController::class, 'removeItem'])->middleware(['jwt.verify']);
Route::post('/importItems', [ItemsController::class, 'importItems'])->middleware(['jwt.verify']);


//items group

// palets

Route::post('/insertNewPalet', [ItemsController::class, 'insertNewPalet'])->middleware(['jwt.verify']);
Route::get('/fetchPalets/{transactionid}', [ItemsController::class, 'fetchPalets'])->middleware(['jwt.verify']);
Route::delete('/removePalet/{paletId}', [ItemsController::class, 'removePalet'])->middleware(['jwt.verify']);
Route::post('/updateTotalPallet', [ItemsController::class, 'updateTotalPallet'])->middleware(['jwt.verify']);

// Route::put('/updateGroup/{groupId}', [ItemsController::class, 'updateGroup'])->middleware(['jwt.verify']);
// Route::delete('/removeGroup/{groupId}', [ItemsController::class, 'removeGroup'])->middleware(['jwt.verify']);
//palets

//items

Route::post('/insertItem', [ItemsController::class, 'insertItem'])->middleware(['jwt.verify']);
Route::put('/updateItem/{clientItemId}', [ItemsController::class, 'updateClientItem'])->middleware(['jwt.verify']);
//items

//suppliers
Route::post('/fetchSuppliers', [ClientSupplierController::class, 'fetchSuppliers'])->middleware(['jwt.verify']);
Route::post('/insertSupplier', [ClientSupplierController::class, 'insertSupplier'])->middleware(['jwt.verify']);
Route::put('/updateSupplier/{clientSupplierId}', [ClientSupplierController::class, 'updateSupplier'])->middleware(['jwt.verify']);
Route::delete('/removeSupplier/{supplierId}', [ClientSupplierController::class, 'removeSupplier'])->middleware(['jwt.verify']);


//suppliers
Route::get('/getData/{transactionId}', [ReportController::class, 'getData']);
Route::group([
    'middleware' => 'api',
], function ($router) {

    Route::post('/testUserModel', [MobileUserController::class, 'testUserModel'])->middleware(['jwt.verify']);
});


Route::post('/insertRoles', [RolesController::class, 'insertRoles'])->middleware(['jwt.verify']);
Route::delete('/removeRoles/{roleId}', [RolesController::class, 'removeRoles'])->middleware(['jwt.verify']);
Route::put('/updateRoles/{roleId}', [RolesController::class, 'updateRoles'])->middleware(['jwt.verify']);
Route::post('/register', [CustomUserController::class, 'register']);
Route::put('/updateUser/{id}', [CustomUserController::class, 'updateUser'])->middleware(['jwt.verify']);
Route::delete('/removeUser/{id}', [CustomUserController::class, 'deactivateUser'])->middleware(['jwt.verify']);
Route::get('/fetchCustomUserRoles/{userId}', [CustomUserController::class, 'fetchCustomUserRoles'])->middleware(['jwt.verify']);
Route::post('/insertCustomRoleByUser', [CustomUserController::class, 'insertCustomRoleByUser'])->middleware(['jwt.verify']);

Route::post('/forgotPassword', [CustomUserController::class, 'forgotPassword']);

Route::post('/resetUserPassword', [CustomUserController::class, 'resetUserPassword']);

//user access start
Route::get('/getUserRoles', [RolesController::class, 'getUserRoles'])->middleware(['jwt.verify']);
Route::get('/fetchAccessByRole/{role_id}', [RolesController::class, 'fetchAccessByRole'])->middleware(['jwt.verify']);
Route::post('/postUserRoles', [RolesController::class, 'postUserRoles'])->middleware(['jwt.verify']);

Route::post('/insertSetup', [SetupController::class, 'insertSetup'])->middleware(['jwt.verify']);
Route::put('/updateSetup/{setupId}', [SetupController::class, 'updateSetup'])->middleware(['jwt.verify']);
Route::delete('/deleteSetup/{setupId}', [SetupController::class, 'deleteSetup'])->middleware(['jwt.verify']);
Route::delete('/deletePaymentSetup/{setupId}', [SetupController::class, 'deletePaymentSetup'])->middleware(['jwt.verify']);
Route::put('/updatePaymentSetup/{setupId}', [SetupController::class, 'updatePaymentSetup'])->middleware(['jwt.verify']);


Route::get('/fetchSetupsByType/{setupType}', [SetupController::class, 'fetchSetupsByType'])->middleware(['jwt.verify']);
Route::post('/insertPaymentSetup', [SetupController::class, 'insertPaymentSetup'])->middleware(['jwt.verify']);

//Route::get('/createCellMerge', [SetupController::class, 'createCellMerge']);


Route::get('/fetchNotifications/{status?}', [BackOfficeNotifications::class, 'fetchNotifications'])->middleware(['jwt.verify']);
Route::get('/fetchNotificationsCount', [BackOfficeNotifications::class, 'fetchNotificationsCount'])->middleware(['jwt.verify']);



Route::put('/updateNotificationsAsRead/{notificationId?}', [BackOfficeNotifications::class, 'updateNotificationsAsRead'])->middleware(['jwt.verify']);
Route::put('/updateNotificationToken', [BackOfficeNotifications::class, 'updateNotificationToken'])->middleware(['jwt.verify']);


Route::post('/myDashboard', [DashboardController::class, 'myDashboard'])->middleware(['jwt.verify']);
Route::post('/fetchTransactionsByTypeAndStatus', [DashboardController::class, 'fetchTransactionsByTypeAndStatus'])->middleware(['jwt.verify']);
//user access endc


//report
Route::post('/getDataDropDown', [GoodsInReportsController::class, 'getDataDropDown'])->middleware(['jwt.verify']);
Route::post('/getGooodsInData', [GoodsInReportsController::class, 'getGooodsInData'])->middleware(['jwt.verify']);
Route::get('/goodsInPdf/{transactionDataId}', [GoodsInReportsController::class, 'goodsInPdf']);
Route::post('/getExcelData', [GoodsInReportsController::class, 'getExcelData'])->middleware(['jwt.verify']);
Route::post('/goodsInPdfData', [GoodsInReportsController::class, 'goodsInPdfData'])->middleware(['jwt.verify']);


Route::post('/getDeliveryData', [DeliveryReportsController::class, 'getDeliveryData'])->middleware(['jwt.verify']);
Route::get('/getDeliveryDataExcel/{transactionDataId}', [DeliveryReportsController::class, 'getDeliveryDataExcel']);


Route::get('/deliveryReportPdf/{transactionDataId}', [DeliveryReportsController::class, 'deliveryReportPdf']);


//report


//DO

Route::post('/dtItemDetails', [DOController::class, 'dtItemDetails'])->middleware(['jwt.verify']);

Route::post('/storeTransactionDtTmpDO', [DOController::class, 'storeTransactionDtTmpDO'])->middleware(['jwt.verify']);
Route::post('/fetchTransactionDetailsTmpDO', [DOController::class, 'fetchTransactionDetailsTmpDO'])->middleware(['jwt.verify']);
Route::post('/fetchDOItems', [DOController::class, 'fetchDOItems'])->middleware(['jwt.verify']);
Route::get('/fetchTransactionDtSerialsTmpDO/{transactiondttmpId}', [DOController::class, 'fetchTransactionDtSerialsTmpDO'])->middleware(['jwt.verify']);
Route::post('/insertTransactionDtSerialTmpDO', [DOController::class, 'insertTransactionDtSerialTmpDO'])->middleware(['jwt.verify']);
Route::get('/deleteAllSerialsTmp/{transactiondttmp_id}', [DOController::class, 'deleteAllSerialsTmp'])->middleware(['jwt.verify']);
Route::get('/fetchItemsByClient/{navigationType}/{transactiontmp_id}/{client_id}/{transactionFromDate}', [DOController::class, 'fetchItemsByClient'])->middleware(['jwt.verify']);
Route::post('/releaseDO', [DOController::class, 'releaseDO'])->middleware(['jwt.verify']);
Route::post('/arrivedDO', [DOController::class, 'arrivedDO'])->middleware(['jwt.verify']);


Route::get('/getDateValidity/{transactiontmpId}/{transactionDate}', [DOController::class, 'getDateValidity'])->middleware(['jwt.verify']);
Route::post('/fetchDOItemsQty', [DOController::class, 'fetchDOItemsQty'])->middleware(['jwt.verify']);
Route::post('/fetchItemsByClient2', [DOController::class, 'fetchItemsByClient2'])->middleware(['jwt.verify']);
Route::post('/saveMultiItemsDO', [DOController::class, 'saveMultiItemsDO'])->middleware(['jwt.verify']);


Route::post('/fetchDOTransactions', [DOController::class, 'fetchDOTransactions'])->middleware(['jwt.verify']);

//End DO

// START COMPANIES
Route::get('/fetchCompanies', [CompanyController::class, 'fetchCompanies'])->middleware(['jwt.verify']);
Route::post('/insertNewCompany', [CompanyController::class, 'insertNewCompany'])->middleware(['jwt.verify']);
Route::put('/updateCompany/{companyId}', [CompanyController::class, 'updateCompany'])->middleware(['jwt.verify']);
Route::delete('/deleteCompany/{companyId}', [CompanyController::class, 'deleteCompany'])->middleware(['jwt.verify']);
// END COMPANIES

// START GOODS IN SERIALS
Route::get('/fetchGoodsInItemsHavingSerials/{transactionTmpId}', [GoodsInSerialsController::class, 'fetchGoodsInItemsHavingSerials'])->middleware(['jwt.verify']);
Route::post('/setNewOriginalTransaction', [GoodsInController::class, 'insertNewTransaction'])->middleware(['jwt.verify']);
Route::get('/retrievePendingGoodsIn/{transactionType}', [GoodsInSerialsController::class, 'retrievePendingGoodsIn'])->middleware(['jwt.verify']);
Route::put('/saveGoodsInWithoutSerials/{transactionTmpId}', [GoodsInSerialsController::class, 'saveGoodsInWithoutSerials'])->middleware(['jwt.verify']);

// END GOODS IN SERIALS

// START Do  SERIALS
Route::get('/fetchDoItemsHavingSerials/{transactionTmpId}', [DoSerialsController::class, 'fetchDoItemsHavingSerials'])->middleware(['jwt.verify']);
Route::post('/setNewOriginalTransactionDo', [DoSerialsController::class, 'setNewOriginalTransactionDo'])->middleware(['jwt.verify']);
Route::get('/retrievePendingDo/{transactionType}', [DoSerialsController::class, 'retrievePendingDo'])->middleware(['jwt.verify']);
Route::put('/saveDOWithoutSerials/{transactionTmpId}', [DoSerialsController::class, 'saveDOWithoutSerials'])->middleware(['jwt.verify']);

// END Do  SERIALS


// START Do item Statment

Route::post('/getDataDropDownStatment', [ItemsStatementController::class, 'getDataDropDownStatment'])->middleware(['jwt.verify']);
Route::post('/getDataItemStatment', [ItemsStatementController::class, 'getDataItemStatment'])->middleware(['jwt.verify']);
Route::get('/printStatmentOfItems/{transactionDataId}', [ItemsStatementController::class, 'printStatmentOfItems']);


// END Do item Statment


Route::post('/cipherRequest', [UtilitiesController::class, 'cipherRequest']);
Route::get('/decipherRequest/{text}', [UtilitiesController::class, 'decipherRequest'])->middleware(['jwt.verify']);
Route::post('/getCurrencyRate', [UtilitiesController::class, 'getCurrencyRate']);

Route::post('/dubaiTrader', [UtilitiesController::class, 'dubaiTrader'])->middleware(['jwt.verify']);


//history

Route::post('/insertHistoryData', [HistoryController::class, 'insertHistoryData']);
Route::post('/fetchHistory', [HistoryController::class, 'fetchHistory']);
Route::post('/fetchHistoryTransactionDt', [HistoryController::class, 'fetchHistoryTransactionDt']);
Route::post('/fetchHistoryTransactionDtSerials', [HistoryController::class, 'fetchHistoryTransactionDtSerials']);

//End History


//Charge Template  START
Route::post('/fetchChargeTemplates', [ChargeTempalteController::class, 'fetchChargeTemplates'])->middleware(['jwt.verify']);
Route::get('/fetchDataChargeTemplate', [ChargeTempalteController::class, 'fetchDataChargeTemplate'])->middleware(['jwt.verify']);
Route::post('/insertChargeTemplate', [ChargeTempalteController::class, 'insertChargeTemplate'])->middleware(['jwt.verify']);
Route::put('/updateChargeTemplate/{chargeTemplateId}', [ChargeTempalteController::class, 'updateChargeTemplate'])->middleware(['jwt.verify']);
Route::delete('/removeChargeTemplate/{chargeTemplateId}', [ChargeTempalteController::class, 'removeChargeTemplate'])->middleware(['jwt.verify']);
Route::post('/submitInvoices', [ChargeTempalteController::class, 'submitInvoices'])->middleware(['jwt.verify']);
Route::post('/fetchChargeTemplateByTransaction', [ChargeTempalteController::class, 'fetchChargeTemplateByTransaction'])->middleware(['jwt.verify']);

//Charge Template  END


Route::post('/checkMaxDoPrice', [DOController::class, 'checkMaxDoPrice']);


//currency START

Route::get('/fetchCurrency', [CurrencyController::class, 'fetchCurrency'])->middleware(['jwt.verify']);
Route::post('/insertCurrency', [CurrencyController::class, 'insertCurrency'])->middleware(['jwt.verify']);
Route::put('/updateCurrency/{currencyId}', [CurrencyController::class, 'updateCurrency'])->middleware(['jwt.verify']);
Route::delete('/removeCurrency/{currencyId}', [CurrencyController::class, 'removeCurrency'])->middleware(['jwt.verify']);

Route::get('/fetchCurrencyDt/{currencyCode}', [CurrencyController::class, 'fetchCurrencyDt'])->middleware(['jwt.verify']);
Route::post('/insertCurrencyDt', [CurrencyController::class, 'insertCurrencyDt'])->middleware(['jwt.verify']);
Route::put('/updateCurrencyDt/{currencyDtId}', [CurrencyController::class, 'updateCurrencyDt'])->middleware(['jwt.verify']);
Route::delete('/removeCurrencyDt/{currencyDtId}', [CurrencyController::class, 'removeCurrencyDt'])->middleware(['jwt.verify']);

// currency END
Route::post('/changeUserPassword', [CustomUserController::class, 'changeUserPassword'])->middleware(['jwt.verify']);

//serial types

Route::get('/fetchSerialTypes', [SerialTypesController::class, 'fetchSerialTypes'])->middleware(['jwt.verify']);
Route::get('/fetchTypesBySerialId/{serial_id}', [SerialTypesController::class, 'fetchTypesBySerialId'])->middleware(['jwt.verify']);
Route::post('/insertSerialType', [SerialTypesController::class, 'insertSerialType'])->middleware(['jwt.verify']);
Route::delete('/deleteSerialType/{serialId}/{serialLabel?}', [SerialTypesController::class, 'deleteSerialType'])->middleware(['jwt.verify']);


// end serial types

//excel data entry

Route::post('/excelDataEntry', [DataEntryController::class, 'excelDataEntry'])->middleware(['jwt.verify']);
Route::post('/excelDataEntryAlt', [DataEntryController::class, 'excelDataEntryAlt'])->middleware(['jwt.verify']);


Route::post('/import', [DataEntryController::class, 'import']);
Route::post('/importAlt', [DataEntryController::class, 'importAlt']);


// end excel data entry

// Client Rent Storage
Route::get('/fetchClientStorage/{clientId}/{skip}/{take}', [ClientStorageController::class, 'fetchClientStorage'])->middleware(['jwt.verify']);
Route::post('/insertClientStorage', [ClientStorageController::class, 'insertClientStorage'])->middleware(['jwt.verify']);
Route::put('/updateClientStorage/{id}', [ClientStorageController::class, 'updateClientStorage'])->middleware(['jwt.verify']);
Route::post('/insertNewStoragePallet', [StoragePalletController::class, 'insertNewStoragePallet'])->middleware(['jwt.verify']);
Route::get('/fetchStoragePallets/{transactionid}', [StoragePalletController::class, 'fetchStoragePallets'])->middleware(['jwt.verify']);
Route::delete('/removeStoragePallet/{PalletId}', [StoragePalletController::class, 'removeStoragePallet'])->middleware(['jwt.verify']);
Route::post('/fetchClientStorageReport', [ClientStorageReportsController::class, 'fetchClientStorageReport'])->middleware(['jwt.verify']);


//Exit  Client Rent Storage
Route::get('/resolveDublicate', [DOController::class, 'resolveDublicate']);


//delivered
Route::post('/fetchDeliveredTransactions', [DOController::class, 'fetchDeliveredTransactions']);

Route::get('/fetchAutoCompleteData', [DOController::class, 'fetchAutoCompleteData']);


Route::post('/insertDeliveredTransactions', [DOController::class, 'insertDeliveredTransactions']);

Route::get('/printDeliveredItems/{transactionId}', [ReportController::class, 'printDeliveredItems']);
Route::get('/printManifest/{transactionId}', [ReportController::class, 'printManifest']);


//end delivered

Route::post('/fetchTransactionStatus', [DOController::class, 'fetchTransactionStatus']);
Route::post('/insertTransactionStatus', [DOController::class, 'insertTransactionStatus']);
Route::get('/deleteStatus/{transaction_id}/{id?}', [DOController::class, 'deleteStatus'])->middleware(['jwt.verify']);
Route::get('/fetchTransactionStatusTrack/{reference}', [DOController::class, 'fetchTransactionStatusTrack']);
Route::post('/receivetransactionFromShipment', [UtilitiesController::class, 'receivetransactionFromShipment']);
Route::post('/connectShipmentToLogisticomApi', [UtilitiesController::class, 'connectShipmentToLogisticomApi']);



//DQ
Route::post('/fetchDQTransactions', [DQController::class, 'fetchDQTransactions'])->middleware(['jwt.verify']);
Route::post('/loadFromDO', [DQController::class, 'loadFromDO'])->middleware(['jwt.verify']);
Route::post('/addDOFromMultipleDO', [DQController::class, 'addDOFromMultipleDO'])->middleware(['jwt.verify']);
Route::post('/createTransactionTmpDQ', [DQController::class, 'createTransactionTmpDQ'])->middleware(['jwt.verify']);
Route::put('/updateTransactionDtTmpPriceDQ/{raw_in_grid}/{transactionTmpId}', [DQController::class, 'updateTransactionDtTmpPriceDQ'])->middleware(['jwt.verify']);
Route::post('/fetchTransactionDetailsTmpDQ', [DQController::class, 'fetchTransactionDetailsTmpDQ'])->middleware(['jwt.verify']);
Route::post('/insertNewDQTransaction', [DQController::class, 'insertNewDQTransaction'])->middleware(['jwt.verify']);
Route::get('/dqInvoicePdf/{transactionId}', [ReportController::class, 'dqInvoicePdf']);
Route::get('/dqReportPdf/{transactionId}', [ReportController::class, 'dqReportPdf']);

Route::delete('/removeOriginalDQTransaction/{transactionId}', [DQController::class, 'removeOriginalDQTransaction'])->middleware(['jwt.verify']);



//End DQ


//updateLedgersForClient
Route::post('/updateLedgersForClient', [ClientController::class, 'updateLedgersForClient']);
Route::delete('/removeOriginalTransactionDO/{transactionId}', [DOController::class, 'removeOriginalTransactionDO'])->middleware(['jwt.verify']);



Route::post('/updateLanguageUrl', [UtilitiesController::class, 'updateLanguageUrl']);


//insert payment method to transactions

Route::post('/addPaymentMethods', [ChargeTempalteController::class, 'addPaymentMethods'])->middleware(['jwt.verify']);
Route::get('/getPaymentMethods/{transactionId}', [ChargeTempalteController::class, 'getPaymentMethods'])->middleware(['jwt.verify']);

Route::get('/getDeliveryDataExcelGoodsIn/{transactionDataId}', [GoodsInReportsController::class, 'getDeliveryDataExcelGoodsIn']);



Route::prefix('to')->group(function () {
    Route::middleware(['jwt.verify'])->group(function () {
        Route::post('/fetchTransactions', [TOController::class, 'fetchTransactions']);
        Route::delete('/cancelTransactionTmpTable/{transactionTmpId}', [TOController::class, 'cancelTransactionTmpTable'])->middleware(['jwt.verify']);
        Route::post('/insertNewTOTransaction', [TOController::class, 'insertNewTOTransaction'])->middleware(['jwt.verify']);
        Route::post('/createTransactionTmp', [TOController::class, 'createTransactionTmpTO'])->middleware(['jwt.verify']);
        Route::post('/storeTransactionDtTmp', [TOController::class, 'storeTransactionDtTmp'])->middleware(['jwt.verify']);
        Route::post('/importTODetail', [TOController::class, 'importTODetail'])->middleware(['jwt.verify']);
        Route::post('/importTOFromTxt', [TOController::class, 'importTOFromTxt'])->middleware(['jwt.verify']);
    });

    Route::get('/printManifest/{transactionId}', [TOController::class, 'printManifest']);
});
Route::get('/solveInternal/{transactionRef}', [InternalController::class, 'solveInternal']);


Route::middleware(['jwt.verify'])->group(function () {
    Route::prefix('internal-transfer')->group(function () {
        Route::post('/insertNewTransaction', [InternalController::class, 'insertNewTransaction']);
        Route::get('/returnToTmpTransaction/{transactionId}', [InternalController::class, 'returnToTmpTransaction'])->middleware(['jwt.verify']);
        Route::get('/checkTransactionUpdateValidity/{transactionId}/', [InternalController::class, 'checkTransactionUpdateValidity'])->middleware(['jwt.verify']);
        Route::post('/fetchTransactionDetailsTmp', [InternalController::class, 'fetchTransactionDetailsTmp'])->middleware(['jwt.verify']);

        Route::get('/fetchInternalTransactionDetailsTmp/{transactionTmpId}', [InternalController::class, 'fetchInternalTransactionDetailsTmp'])->middleware(['jwt.verify']);
        Route::post('/createTransactionTmp', [InternalController::class, 'createTransactionTmp'])->middleware(['jwt.verify']);
        Route::post('/storeTransactionDtTmp', [InternalController::class, 'storeTransactionDtTmp'])->middleware(['jwt.verify']);

        Route::post('/fetchRemainingGoodsInTransactions', [InternalController::class, 'fetchRemainingGoodsInTransactions']);
        Route::post('/addDOFromMultipleGoodsIn', [InternalController::class, 'addDOFromMultipleGoodsIn']);
        Route::post('/fetchTransactions', [InternalController::class, 'fetchTransactions']);
        Route::delete('/removeOriginalTransaction/{transactionId}', [InternalController::class, 'removeOriginalTransaction'])->middleware(['jwt.verify']);
        Route::get('/returnFromOriginalToTmp/{transactionId}', [InternalController::class, 'returnFromOriginalToTmp'])->middleware(['jwt.verify']);
        Route::put('/updateTransactionDtTmp/{raw_in_grid}/{transactionTmpId}', [InternalController::class, 'updateTransactionDtTmp'])->middleware(['jwt.verify']);
        Route::delete('/removeTransactionDtTmp/{raw_in_grid}/{transactionTmpId}', [InternalController::class, 'removeTransactionDtTmp'])->middleware(['jwt.verify']);
        Route::post('/solveInternalData', [InternalController::class, 'solveInternalData']);


    });
    Route::prefix('GoodsIn')->group(function () {
        Route::get('/fetchTransactions', [GoodsInController::class, 'fetchTransactions'])->middleware(['jwt.verify']);
        Route::get('/fetchPendingTransactions/{transactionType}/{transactionTmpId?}', [GoodsInController::class, 'fetchPendingTransactions'])->middleware(['jwt.verify']);

        Route::post('/createTransactionTmpGoodsIn', [GoodsInController::class, 'createTransactionTmpGoodsIn'])->middleware(['jwt.verify']);
        Route::post('/storeTransactionDtTmpGoodsIn', [GoodsInController::class, 'storeTransactionDtTmpGoodsIn'])->middleware(['jwt.verify']);
        Route::post('/insertNewTransaction', [GoodsInController::class, 'insertNewTransaction'])->middleware(['jwt.verify']);
    });

    Route::prefix('items')->group(function () {
        Route::get('/fetchBackEndItems', [ItemsController::class, 'fetchItems'])->middleware(['jwt.verify']);
    });
    Route::prefix('DO')->group(function () {
        Route::post('/fetchTransactions', [DOController::class, 'fetchTransactions'])->middleware(['jwt.verify']);
        Route::post('/SyncTransactionDO', [DOController::class, 'SyncTransactionDO'])->middleware(['jwt.verify']);
        Route::post('/fetchRemainingGoodsInTransactions', [DOController::class, 'fetchRemainingGoodsIn'])->middleware(['jwt.verify']);

    });

    Route::prefix('transactions')->group(function () {
        Route::get('', [TransactionController::class, 'fetchTransactions'])->middleware(['jwt.verify']);

    });


});
Route::prefix('transactions')->group(function () {
    Route::get('', [TransactionController::class, 'fetchTransactions'])->middleware(['jwt.verify']);
    Route::get('/pdf/{transactionDataId}', [TransactionController::class, 'transactionsPdf']);

    });

    Route::prefix('transactions')->group(function () {
        Route::get('', [TransactionController::class, 'fetchTransactions'])->middleware(['jwt.verify']);

    });

    Route::get('/storageReportData/{transactionDataId}', [ClientStorageReportsController::class, 'excelStorageReport'])->middleware(['jwt.verify']);
    Route::get('/printStorageReport/{transactionId}', [ClientStorageReportsController::class, 'printStorageReport']);

    Route::get('/generateCommercialInvoiceExcel/{transactionId}', [ReportController::class, 'generateCommercialInvoiceExcel']);

    