<html dir="{{$moduleKeys['direction'][$language]}}">

<head>
    <meta charset="utf-8">
    <title>{{$moduleKeys['deliveredQtyInvoice'][$language]}} {{$moduleKeys['report'][$language]}}</title>

</head>

<body dir="{{$moduleKeys['direction'][$language]}}">
    <div class="frame">

        <header>
            @section('content')
            <div>
                @include('./components/logo' ,['company' => $data->company] )
            </div>
            @endsection
            <x-logo :company="$company"></x-logo>
            <h1><u>{{$moduleKeys['deliveredQtyInvoice'][$language]}}</u></h1>
        </header>
        <br>

        <table class="inventory">

            <tr>

                <td class="nullclass" width="45%"></td>
                <th width="10%"> <span>{{$moduleKeys['reference'][$language]}}</span></th>
                <td width="15%"> <span>{{$data->transaction->transaction_reference}}</span></td>
            </tr>
            <tr>
            <tr>


                <td class="nullclass" width="45 %"></td>
                <th><span>{{$moduleKeys['user'][$language]}}</span></th>
                <td><span>{{$data->transaction->user_name}}</span></td>
            </tr>
            <tr>


                <td class="nullclass" width="45 %"></td>
                <th><span>{{$moduleKeys['paymentMethod2'][$language]}}</span></th>
                <td><span>{{$data->paymentMethodId}}</span></td>
            </tr>
            <tr>
                <td class="nullclass" width="45%"></td>
                <th><span>{{$moduleKeys['client'][$language]}}</span></th>
                <td><span>{{$data->transaction->client_firstname}}</span></td>
            </tr>
            <tr>


                <td class="nullclass" width="45 %"></td>
                <th><span>{{$moduleKeys['date'][$language]}}</span></th>
                <td><span>{{$data->transaction->transaction_date}}</span></td>
            </tr>
            <tr>


                <td class="nullclass" width="45 %"></td>
                <th><span>{{$moduleKeys['currency'][$language]}}</span></th>
                <td><span>{{$data->transaction->currency_code}}</span></td>
            </tr>

        </table>

        <br>
        <table class="inventory">

            <thead>
                <tr>
                    <td colspan="4"><span></span></td>


                </tr>
                <tr>
                    <th><span>{{$moduleKeys['item'][$language]}}</span></th>
                    <th><span>{{$moduleKeys['description'][$language]}} </span></th>
                    <th><span>{{$moduleKeys['quantity'][$language]}}</span></th>
                    <th colspan="9"><span>{{$moduleKeys['price'][$language]}}</span></th>
                    <th><span>{{$moduleKeys['totalPrice'][$language]}}</span></th>



                </tr>
            </thead>
            <?php $qty = 0 ?>

            @for($j =0; $j < count($data->transactiondt); $j++ ) <tbody>
                    <tr>
                        <td><span>{{$data->transactiondt[$j]->item_code}}</span></td>
                        <td><span>{{$data->transactiondt[$j]->transactiondt_item_description}}</span></td>

                        <td><span>{{$data->transactiondt[$j]->item_quantity_to_delivery}}</span></td>

                        <td colspan="9" style="text-align: center;"><span>{{$data->transactiondt[$j]->transactiondt_price}}</span></td>

                        <td><span>{{$data->transactiondt[$j]->totalRowPrice}}</span></td>



                    </tr>
                    @endFor

                    <tr>

                        <th colspan="12"><span> {{$moduleKeys['grandTotal'][$language]}}</span></th>
                        <td style="background-color:#D6EAF8 ; text-align: right;"> {{$data->total->total_qty_price}}</td>



                    </tr>
                </tbody>
        </table>
    </div>


    <div>
        @include('./components/footer',['company' => $company] )
    </div>
</body>

</html>
<style type="text/css">
    /* reset */


    .frame {
        padding-left: 2%;
        width: 96%;
        max-width: 680px;
        margin: 0;
    }

    footer {
        position: fixed;
        bottom: -60px;
        left: 0px;
        right: 0px;
        height: 50px;
        font-size: 20px !important;

        /** Extra personal styles **/
        background-color: #008B8B;
        color: white;
        text-align: center;
        line-height: 35px;
    }


    * {
        border: 0;
        box-sizing: content-box;
        color: inherit;
        font-family: inherit;
        font-size: inherit;
        font-style: inherit;
        font-weight: inherit;
        line-height: inherit;
        list-style: none;

    }

    /* content editable */

    *[contenteditable] {
        border-radius: 0.25em;
        min-width: 1em;
        outline: 0;
    }

    *[contenteditable] {
        cursor: pointer;
    }

    *[contenteditable]:hover,
    *[contenteditable]:focus,
    td:hover *[contenteditable],
    td:focus *[contenteditable],
    img.hover {
        background: #DEF;
        box-shadow: 0 0 1em 0.5em #DEF;
    }

    span[contenteditable] {
        display: inline-block;
        position: absolute
    }

    /* heading */

    h1 {
        font: bold 100% sans-serif;
        text-align: center;
        text-transform: uppercase;
    }

    hr {
        border: 0;
        clear: both;
        display: block;
        width: 96%;
        background-color: black;
        height: 1px;
        vertical-align: center;
    }

    /* table */

    table {
        font-size: 75%;
        table-layout: fixed;
        width: 100%;
    }

    table {
        border-collapse: separate;
        border-spacing: 2px;
    }

    th,
    td {
        padding: 0.3em;
        position: relative;
        text-align: left;
        position: absolute
    }

    th,
    td {
        border-radius: 0.25em;
        border-style: solid;
        position: absolute
    }

    th {
        background: #E6E6E6;
        border-color: #BBB;
        position: absolute
    }

    td {
        border-color: rgb(170 166 166 / 33%);
        position: absolute
    }

    td.nullclass {
        border-color: #0000
    }





    /* invoice title */

    .txt {
        font-size: 75%;
        table-layout: fixed;
        width: 95%;
        position: absolute
    }










    /* table meta & balance */

    table.meta,
    table.balance {
        float: right;
        width: 50%;
        text-align: center;
        position: absolute
    }

    table.meta:after,
    table.balance:after {
        clear: both;
        content: "";
        display: table;
        text-align: center;
        position: absolute
    }

    /* table meta */

    table.meta th {
        width: 40%;
        text-align: center;
        position: absolute
    }

    table.meta td {
        width: 60%;
        text-align: center;
        position: absolute
    }

    /* table items */

    table.inventory {
        clear: both;
        width: 100%;
        position: absolute font-size:15px;
    }

    table.inventory th {
        font-weight: bold;
        text-align: center;
        position: absolutefont-size:15px;
    }

    table.inventory td {
        text-align: center;
        position: absolutefont-size:10px;
    }

    table.inventory td.bigFontTd {
        text-align: center;
        position: absolutefont-size:13px;
        font-weight: bold;
    }

    table.inventory td.small {
        text-align: center;
        position: absolutefont-size:8px;
    }

    /* table balance */

    table.balance th,
    table.balance td {
        width: 50%;
        text-align: center;
        position: absolute
    }

    table.balance td {
        text-align: center;
        position: absolute
    }

    @page {
        margin-bottom: 50;

        header: page-header;
        footer: page-footer;
    }

    /* aside */
</style>