<?php

namespace App\Http\Middleware;

use App\Http\Controllers\ApiController;
use Closure;
use Exception;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use JWTAuth;
use Tymon\JWTAuth\Exceptions\TokenExpiredException;
use Tymon\JWTAuth\Exceptions\TokenInvalidException;

class JwtMiddleware extends ApiController
{
    /**
     * Handle an incoming request.
     *
     * @param Request $request
     * @param Closure(Request): (Response|RedirectResponse) $next
     * @return Response|RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        try {
            $user = JWTAuth::parseToken()->authenticate();
        } catch (Exception $e) {
            if ($e instanceof TokenInvalidException) {
                return ApiController::errorResponse("Invalid Token", 401);
            } else if ($e instanceof TokenExpiredException) {
                return ApiController::errorResponse("Expired Token", 401);
            } else {
                return ApiController::errorResponse('Authorization token not found', 401);
            }
        }
        return $next($request);
    }
}
