<?php

namespace App\Http\Controllers\mobile\Customers;

use App\Http\Controllers\ApiController;
use App\Models\client;
use App\Models\clientCustomer;
use App\Models\clientForwarder;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use JWTAuth;


class CustomerController extends ApiController
{
    public function fetchCustomers(Request $request)
    {
        $user_id = JWTAuth::user()->id;
        $limit = 30;
        $page = $request->page;
        $clientId = client::where('user_id', $user_id)->first();


        $clientCustomers = clientCustomer::leftjoin('countries', 'countries.country_id', '=', 'client_customers.customer_country')
            ->where('customer_related_clientid', '=', $clientId->client_id);
        if ($request->searchValue) {
            $clientCustomers->where([
                ['customer_name', 'like', '%' . $request->searchValue . '%']
            ]);
        }
        $clientCustomers = $clientCustomers;

        $count = $clientCustomers->get()->count();

        $clientCustomers = $clientCustomers->limit($limit)
            ->skip($limit * $page)->get();

        return ApiController::successResponse($clientCustomers, 200, $count);
    }

    public function getCustomerForClient(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'clientId' => 'required'
        ]);
        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }
        $user_id = JWTAuth::user()->id;
        $clientCustomers = clientCustomer::leftjoin('countries', 'countries.country_id', '=', 'client_customers.customer_country')
            ->where('customer_related_clientid', '=', $request->clientId);
        if ($request->searchValue) {
            $clientCustomers->where([
                ['customer_name', 'like', '%' . $request->searchValue . '%']
            ]);
        }
        $clientCustomers = $clientCustomers->get();
        return ApiController::successResponse($clientCustomers, 200);
    }

    public function newCustomer(Request $request)
    {
        $user_id = JWTAuth::user()->id;
        $validator = Validator::make($request->all(), [
            'customerName' => 'required',
            'customerContactPerson' => 'required',
            'customerAddress' => 'required',
            'customerEmail' => 'required',
            'customerPhone' => 'required',
            'customerCountry' => 'required',
            'customerPhoneCode' => 'required',
            'clientId' => 'required'
        ]);
        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }

        $emailExist = DB::table('client_customers')
            ->where([
                ['client_customers.customer_email', 'like', $request->customerEmail]
            ])
            ->first();

        if ($emailExist) {
            return ApiController::errorResponse("Email already taken!", 409);
        }
        $phoneExist = DB::table('client_customers')
            ->where([
                ['client_customers.customer_phone', 'like', $request->customerPhone],
                ['client_customers.customer_phone_code', 'like', $request->customerPhone]
            ])
            ->first();

        if ($phoneExist) {
            return ApiController::errorResponse("Phone already taken!", 409);
        }


        $newCustomer = DB::table('client_customers')
            ->insertGetId([
                'customer_name' => $request->customerName,
                'customer_ContactPerson' => $request->customerContactPerson,
                'customer_address' => $request->customerAddress,
                'customer_country' => $request->customerCountry,
                'customer_phone' => $request->customerPhone,
                'customer_phone_code' => $request->customerPhoneCode,
                'customer_email' => $request->customerEmail,
                'customer_related_clientId' => $request->clientId,
            ]);
        if ($newCustomer) {
            return ApiController::successResponse($newCustomer, 200);
        }
        return ApiController::errorResponse("Invalid request", 422);

    }


    public function searchCustomer(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'user_id' => 'required',
        ]);
        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }


        $customers = DB::table('client_customers')
            ->where([
                ['customer_related_clientid', '=', $request->user_id],
                ['customer_firstname', 'like', '%' . $request->search_key . '%'],

            ])
            ->orwhere([
                ['customer_related_clientid', '=', $request->user_id],
                ['customer_lastname', 'like', '%' . $request->search_key . '%'],
            ])
            ->orwhere([
                ['customer_related_clientid', '=', $request->user_id],
                ['customer_email', 'like', '%' . $request->search_key . '%'],
            ])
            ->orwhere([
                ['customer_related_clientid', '=', $request->user_id],
                ['customer_phone', 'like', '%' . $request->search_key . '%'],
            ])
            ->get();

        // $dataCustomers = Array();
        // foreach ($customers as $customer) {
        //     $firstName = str_contains(strtoupper($customer->customer_firstname),strtoupper($request->search_key));
        //     $lastName = str_contains(strtoupper($customer->customer_lastname),strtoupper($request->search_key));
        //     if( $firstName || $lastName)
        //     {
        //         array_push($dataCustomers,$customer);
        //     }
        // }
        return ApiController::successResponse($customers, 200);
    }


    public function fetchClientMobileForwarders(Request $request)
    {
        $clientForwarders = null;
        if ($request->searchValue) {
            $clientForwarders = clientForwarder::where([
                ['clientforwarder_name', 'like', '%' . $request->searchValue . '%']
            ]);
            $clientForwarders = $clientForwarders->get();
        } else {
            $clientForwarders = clientForwarder::select(
                'clientforwarder_id',
                'clientforwarder_name',
                'clientforwarder_contactPerson',
                'clientforwarder_email',
                'clientforwarder_phone',
                'clientforwarder_address',
                'clientforwarder_tradeLicenseNumber',
                'clientforwarder_mercalTo',
                'clientforwarder_importCode',
                'clientforwarder_approved'
            )
                ->selectRaw("(case when ( clientforwarder_approved) = 0 THEN ('No')
            else (' Yes') END ) as aprroved_display")
                ->where('clientforwarder_approved', '1')
                // ->selectRaw( "(CASE WHEN clientforwarder_approved =0 THEN 1No ELSE  END) AS is_user)")

                ->get();
        }
        //$clientForwarders = $clientForwarders->get();
        return ApiController::successResponse($clientForwarders, 200);
    }
}
