<?php

namespace App\Http\Controllers\BackOffice\Reports;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\Common\CommonServices;
use App\Http\Controllers\BackOffice\Reports\excel\ExcelReportExport;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\Localization;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use JWTAuth;
use PDF;
use Excel;

class ReportController extends ApiController
{
    public function generateCommercialInvoicePdf(Request $request)
    {
        $UtilitiesController = new UtilitiesController();
        $requestData = $UtilitiesController->decipherRequest($request->transactionId);

        $requestData = json_decode($requestData);
        $transactionId = $requestData->info->id;
        $language = $requestData->info->language;


        $withStamp = isset($requestData->info->withStamp) ? $requestData->info->withStamp : false;

        $hscodeSummary = isset($requestData->info->hscodeSummary) ? $requestData->info->hscodeSummary : false;
        $dataResult = $this->getData($transactionId, $withStamp, $hscodeSummary);
        $dataTransaction = $dataResult->getData();
        $moduleKeys = Localization::moduleKeys; // Assuming this is an array of keys
        $company = DB::table('companies')
            ->first();
        $Obj = array();
        $Obj['data'] = $dataTransaction->data;
        $Obj['isShipment'] = $company->company_onlyShipment;
        $Obj['moduleKeys'] = $moduleKeys;
        $Obj['hscodeSummary'] = $hscodeSummary;
        $Obj['language'] = $language;
        $Obj['transactionId'] = $transactionId;
        $Obj['company'] = $company;
        $Obj['withStamp'] = $withStamp;
        //return ApiController::successResponse($dataTransaction,200);
        $data = array();

        if ($dataResult->status() == 422) {
            return ApiController::successResponse("No data", 200);
        }

        $Obj['perWeight'] = $moduleKeys['qtyPerPcs'][$language];
        $Obj['unitType'] = $moduleKeys['unitTypePcs'][$language];
        $Obj['totalunit'] = $moduleKeys['totalNOQty/unit'][$language] . $Obj['unitType'];

        $withWeight = $requestData->info->perWeight;
        if ($withWeight == true) {
            $Obj['perWeight'] = $moduleKeys['qtyPerWeight'][$language];
            $Obj['unitType'] = $moduleKeys['unitTypeWeight'][$language];
            $Obj['totalunit'] = $moduleKeys['totalNOQty/unit'][$language] . $Obj['unitType'];
        }


        Storage::put('attempt1.txt', 'Commercial_Invoice');

        $Obj['specificPdf'] = './components/';

        $p = 'views/' . $dataTransaction->data->company->company_user_name . '/components/Commercial_Invoice_component.blade.php';
        $path = resource_path($p);
        if (file_exists($path)) {
            $Obj['specificPdf'] = './' . $dataTransaction->data->company->company_user_name . '' . $Obj['specificPdf'];
        } else {
        }


        $commonServices = new CommonServices();
        $decimals = $commonServices->getDecimal();
        $Obj['decimals'] = $decimals;


        $pdf = PDF::loadView(
            'Commercial_Invoice',
            $Obj,
            [],
            [
                'title' => 'Certificate',
                'format' => config('app.PDFFORMAT'),
                'orientation' => config('app.LANDSCAPEPDF')
            ]
        );

        return $pdf->stream('Commercial-invoice(' . $dataTransaction->data->transaction->transaction_reference . ').pdf');
    }


    public function generateCommercialInvoiceExcel(Request $request)
    {
        try {
            $UtilitiesController = new UtilitiesController();
            $commonServices = new CommonServices();

            $requestData = $UtilitiesController->decipherRequest($request->transactionId);
            $requestData = json_decode($requestData);
            $transactionId = $requestData->info->id;
            $language = $requestData->info->language;
            $withStamp = isset($requestData->info->withStamp) ? $requestData->info->withStamp : false;
            $hscodeSummary = isset($requestData->info->hscodeSummary) ? $requestData->info->hscodeSummary : false;
            $dataTransaction = $this->getData($transactionId, $withStamp, $hscodeSummary)->getData();
            $moduleKeys = Localization::moduleKeys; // Assuming this is an array of keys
            $company = DB::table('companies')
                ->first();
            $Obj = array();
            $Obj['data'] = $dataTransaction->data;
            $Obj['isShipment'] = $company->company_onlyShipment;
            $Obj['moduleKeys'] = $moduleKeys;
            $Obj['hscodeSummary'] = $hscodeSummary;
            $Obj['language'] = $language;
            $Obj['transactionId'] = $transactionId;
            $Obj['company'] = $company;
            $Obj['withStamp'] = $withStamp;
            $decimals = $commonServices->getDecimal();
            $Obj['decimals'] = $decimals;
            $Obj['perWeight'] = $moduleKeys['qtyPerPcs'][$language];
            $Obj['unitType'] = $moduleKeys['unitTypePcs'][$language];
            $Obj['totalunit'] = $moduleKeys['totalNOQty/unit'][$language] . $Obj['unitType'];

            ini_set('max_execution_time', '500');
            ini_set('memory_limit', '-1');
            ini_set("pcre.backtrack_limit", "999999999");
            $excelExport = new ExcelReportExport($Obj, 'excel/commercialReport');
            return Excel::download($excelExport, 'commercialReport.xlsx');
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }
    public function getData($transactionId, $withStamp, $hscodeSummary, $withSerial = null)
    {
        $transaction = DB::table('transactions')
            ->where('transactions.transaction_id', '=', $transactionId)
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactions.clientCustomer_id')
            ->leftjoin('clients', 'clients.client_id', '=', 'transactions.transaction_clientId')
            ->leftjoin('companies', 'companies.company_id', '=', 'transactions.company_id')
            ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactions.forwarder_id')
            ->leftjoin('set_ups as set_ups1', 'set_ups1.setup_id', '=', 'transactions.transaction_customBillTypeId')
            ->leftjoin('payment_methods as set_ups2', 'set_ups2.id', '=', 'transactions.transaction_paymentMethodId')
            ->leftjoin('set_ups as set_ups3', 'set_ups3.setup_id', '=', 'transactions.transaction_typeOfDeliveryId')
            ->leftjoin('currency', 'currency.currency_id', '=', 'transactions.transaction_currencyId')
            ->select(
                'set_ups1.setup_value as customBillType',
                'set_ups2.name as paymentMethod',
                'transactions.transaction_id',
                'transactions.transaction_reference',
                'transactions.transaction_date',
                'transactions.transaction_remark',
                'transactions.transaction_shipmentReference',
                'transactions.transaction_billOfEntry',
                'transactions.transaction_driverName',
                'transactions.transaction_vehicleNumber',
                'transactions.transaction_exitPoint',
                'transactions.transaction_destinationPoint',
                'transactions.showInDocument',
                'transactions.transaction_totalPallet',
                'client_customers.customer_name',
                'currency.currency_code',
                'client_customers.customer_address',
                'client_customers.customer_contactPerson',
                'client_customers.customer_email',
                'client_customers.customer_phone',
                'companies.company_name',
                'clientforwarder_address',
                'companies.company_id',
                'currency.currency_name',
                'set_ups3.setup_key as deliveryType',
                'companies.company_logo',
                'companies.company_address',
                'companies.company_trn',
                'companies.company_importCode',
                'companies.company_exitCode',
                'companies.company_prefix',
                'companies.company_licenseNo',
                'companies.company_stampWidth',
                'companies.company_stampLength',
                'companies.company_logoWidth',
                'companies.company_logoLength',
                'companies.company_stamp',
                'client_forwarders.clientforwarder_name',
                'client_forwarders.clientforwarder_address',
                'client_forwarders.clientforwarder_email',
                'client_forwarders.clientforwarder_importCode',
                'clients.client_firstName',
            )
            ->first();


        $company = DB::table('companies')->first();
        $pallets = [];
        if ($transaction->showInDocument == 1) {
            $pallets = DB::table('transaction_palets')
                ->where('transaction_id', '=', $transaction->transaction_id)
                ->orderBy('transaction_palets.palet_order')
                ->get();
        }


        $transactionDtByGroup = DB::table('transaction_dts')
            ->where('transaction_dts.transaction_id', '=', $transactionId)
            ->leftjoin('item_groups', 'item_groups.group_id', '=', 'transaction_dts.group_id')
            ->select('transaction_dts.group_id', 'item_groups.group_code', 'item_groups.group_name')
            ->selectRaw(' SUM(transaction_dts.item_quantity) as item_quantity')
            ->groupBy('transaction_dts.group_id', 'item_groups.group_code')
            ->get();


        if ($transaction && $transaction->transaction_date) {
            $transaction->transaction_date = date('d-m-Y', $transaction->transaction_date);
        }


        $transactionDts = DB::table('transaction_dts')
            ->where('transaction_dts.transaction_id', '=', $transactionId)
            ->leftjoin('items', 'items.item_id', '=', 'transaction_dts.item_id')
            ->leftjoin('countries', 'countries.country_id', '=', 'transaction_dts.transactiondt_countryOfOrigin')
            ->leftjoin('item_groups', 'item_groups.group_id', '=', 'transaction_dts.group_id')
            ->select(
                'transaction_dts.*',
                'items.item_code',
                'transaction_dts.transactiondt_item_description',
                'transaction_dts.item_pack as pack',
                'items.item_barcode',
                'items.item_hasSerial',

                'transaction_dts.hscode',
                'countries.*',
                'item_groups.group_code',
                'item_groups.group_name',
            )
            ->orderBy('transactiondt_cellMerge')
            ->orderBy('transactiondt_id')
            ->selectRaw(' ceil(transaction_dts.item_quantity / transaction_dts.item_qtyPerPack)as qty_cartoons')
            ->get();


        $transactionDtAdvice = DB::table('transaction_dts')
            ->where('transaction_dts.transaction_id', '=', $transactionId)
            ->leftjoin('items', 'items.item_id', '=', 'transaction_dts.item_id')
            ->leftjoin('countries', 'countries.country_id', '=', 'transaction_dts.transactiondt_countryOfOrigin')
            ->leftjoin('item_groups', 'item_groups.group_id', '=', 'transaction_dts.group_id')
            ->select(
                'transaction_dts.*',
                'items.item_code',
                'transaction_dts.transactiondt_item_description',
                'transaction_dts.item_pack as pack',
                'items.item_barcode',
                'items.item_hasSerial',
                'transaction_dts.hscode',
                'countries.*',
                'item_groups.group_code',
                'item_groups.group_name',
            )
            ->orderBy('transactiondt_cellMerge')
            ->orderBy('transaction_dts.hscode')
            ->orderBy('transactiondt_id')
            ->selectRaw(' SUM(transaction_dts.item_quantity) as item_quantity')
            ->selectRaw(' SUM(transaction_dts.item_quantity *transaction_dts.transactiondt_price) as item_price')
            ->selectRaw(' SUM(transaction_dts.item_quantity * transaction_dts.item_weight) as weight')
            ->selectRaw('SUM(transaction_dts.item_quantity*transaction_dts.gross_weight) as item_total_gross_weight')
            ->groupBy('transaction_dts.hscode', 'country_name', 'item_groups.group_code')
            ->get();


        $transactionDtNote = DB::table('transaction_dts')
            ->where('transaction_dts.transaction_id', '=', $transactionId)
            ->join('items', 'items.item_id', '=', 'transaction_dts.item_id')
            ->leftjoin('countries', 'countries.country_id', '=', 'transaction_dts.transactiondt_countryOfOrigin')
            ->leftjoin('item_groups', 'item_groups.group_id', '=', 'transaction_dts.group_id')
            ->leftjoin('suppliers', 'suppliers.supplier_id', 'transaction_dts.supplier_id')
            ->select(
                'transaction_dts.*',
                'items.item_code',
                'transaction_dts.transactiondt_item_description',
                'transaction_dts.item_pack as pack',
                'items.item_barcode',
                'items.item_hasSerial',
                'transaction_dts.hscode',
                'countries.*',
                'item_groups.group_code',
                'item_groups.group_name',
                'supplier_name'
            )
            ->orderBy('transactiondt_cellMerge')
            ->orderBy('transaction_dts.hscode')
            ->orderBy('transactiondt_id')
            ->selectRaw(' sum(transactiondt_nbOfCarton) as transactiondt_nbOfCarton')
            ->groupBy('transactiondt_cellMerge', 'item_id')
            ->selectRaw(' ceil(transaction_dts.item_quantity / transaction_dts.item_qtyPerPack)as qty_cartoons')
            ->selectRaw(' sum(item_quantity)as item_quantityGroup')
            ->selectRaw(' sum(item_quantity*transaction_dts.item_weight)as item_weightGroup')
            ->get();


        $modelsByRowNote = array();
        $nbOfCartonByRowNote = array();
        $weightByRowNote = array();

        $count = 0;
        $nbOfCarton = 0;
        $weight = 0;
        $lastItem = null;
        //int i=10; i>=0; i--
        for ($i = count($transactionDtNote) - 1; $i >= 0; $i--) {
            $transactionDt = $transactionDtNote[$i];
            if ($lastItem != null && $lastItem != $transactionDt->transactiondt_cellMerge) {
                $count = 0;
                $nbOfCarton = 0;
                $weight = 0;
            }

            $lastItem = $transactionDt->transactiondt_cellMerge;
            $item = array(
                $transactionDt->transactiondt_cellMerge => 0
            );
            $count++;
            $nbOfCarton = $nbOfCarton + $transactionDt->transactiondt_nbOfCarton;
            $weight = $weight + $transactionDt->item_weightGroup;
            array_push($nbOfCartonByRowNote, $nbOfCarton);
            array_push($weightByRowNote, $weight);

            array_push($modelsByRowNote, $count);
        }

        for ($i = 0; $i < count($transactionDtNote) - 1; $i++) {
            if ($modelsByRowNote[$i + 1] > 1) {
                $modelsByRowNote[$i] = 0;
            }
        }

        $modelsByRowNote = array_reverse($modelsByRowNote);
        $nbOfCartonByRowNote = array_reverse($nbOfCartonByRowNote);
        $weightByRowNote = array_reverse($weightByRowNote);


        $transactionDtComercial = DB::table('transaction_dts')
            ->where('transaction_dts.transaction_id', '=', $transactionId)
            ->leftjoin('items', 'items.item_id', '=', 'transaction_dts.item_id')
            ->leftjoin('countries', 'countries.country_id', '=', 'transaction_dts.transactiondt_countryOfOrigin')
            ->leftjoin('item_groups', 'item_groups.group_id', '=', 'transaction_dts.group_id')
            ->select(
                'transaction_dts.*',
                'items.item_code',
                'transaction_dts.transactiondt_item_description',
                'transaction_dts.item_pack as pack',
                'items.item_barcode',
                'items.item_hasSerial',
                'transaction_dts.hscode',
                'countries.*',
                'item_groups.group_code',
                'item_groups.group_name',
            )
            ->orderBy('transactiondt_cellMerge')
            ->orderBy('transaction_dts.hscode')
            ->orderBy('transactiondt_id')
            ->groupBy('transactiondt_cellMerge', 'item_id', 'country_name')
            ->selectRaw(' ceil(transaction_dts.item_quantity / transaction_dts.item_qtyPerPack)as qty_cartoons')
            ->selectRaw(' sum(item_quantity)as item_quantityGroup')
            ->selectRaw(' sum(item_quantity*transaction_dts.item_weight)as item_weightGroup')
            ->get();


        $modelsByRow = array();
        $nbOfCartonByRow = array();
        $weightByRow = array();
        $grossWeightByRow = array();

        $count = 0;
        $nbOfCarton = 0;
        $weight = 0;
        $grossWeight = 0;
        $lastItem = null;
        //int i=10; i>=0; i--
        for ($i = count($transactionDtComercial) - 1; $i >= 0; $i--) {
            $transactionDt = $transactionDtComercial[$i];
            // if( $lastItem != null && $lastItem == $transactionDt->transactiondt_cellMerge)
            // {
            //     //$modelsByRow[$i+1] = 0;
            // }
            if ($lastItem != null && $lastItem != $transactionDt->transactiondt_cellMerge) {
                $count = 0;
                $nbOfCarton = 0;
                $weight = 0;
                $grossWeight = 0;
            }

            // if( $transactionDt->transactiondt_cellMerge == 0 )
            // {
            //     $count = 0;
            //     $nbOfCarton = 0;
            //     $weight = 0;

            // }
            $lastItem = $transactionDt->transactiondt_cellMerge;
            $item = array(
                $transactionDt->transactiondt_cellMerge => 0
            );

            $count++;
            $nbOfCarton = $nbOfCarton + $transactionDt->transactiondt_nbOfCarton;
            $weight = $weight + $transactionDt->item_weightGroup;
            $grossWeight = $grossWeight + $transactionDt->total_gross_weight;
            array_push($nbOfCartonByRow, $nbOfCarton);
            array_push($weightByRow, $weight);
            array_push($grossWeightByRow, $grossWeight);
            array_push($modelsByRow, $count);
        }

        for ($i = 0; $i < count($transactionDtComercial) - 1; $i++) {
            if ($modelsByRow[$i + 1] > 1) {
                $modelsByRow[$i] = 0;
            }
        }

        $modelsByRow = array_reverse($modelsByRow);
        $nbOfCartonByRow = array_reverse($nbOfCartonByRow);
        $weightByRow = array_reverse($weightByRow);
        $grossWeightByRow = array_reverse($grossWeightByRow);


        $countriesOnTransaction = DB::table('transaction_dts')
            ->where([
                ['transaction_dts.transaction_id', '=', $transactionId],
                ['country_name', '!=', null]
            ])
            ->leftjoin('countries', 'countries.country_id', '=', 'transaction_dts.transactiondt_countryOfOrigin')
            ->distinct()
            ->select('countries.country_name')
            ->pluck('countries.country_name');

        if (count($countriesOnTransaction)) {
            $countriesOnTransaction = implode(", ", $countriesOnTransaction->toArray());
        } else {
            $countriesOnTransaction = null;
        }

        $billOfEntryOnTransaction = DB::table('transaction_dts')
            ->where([
                ['transaction_dts.transaction_id', '=', $transactionId],
                ['transactiondt_billOfEntry', '!=', null]
            ])
            ->select('transaction_dts.transactiondt_billOfEntry')
            ->distinct()
            ->pluck('transaction_dts.transactiondt_billOfEntry');

        if (count($billOfEntryOnTransaction)) {
            $billOfEntryOnTransaction = implode(", ", $billOfEntryOnTransaction->toArray());
        } else {
            $billOfEntryOnTransaction = null;
        }


        $pkgTransaction = DB::table('transaction_dts')
            ->where([
                ['transaction_dts.transaction_id', '=', $transactionId],
                ['item_pack', '!=', null]
            ])
            ->select('transaction_dts.item_pack', 'transactiondt_nbOfCarton')
            ->selectRaw('CONCAT(transactiondt_nbOfCarton, item_pack) AS PAK')
            ->groupBy('transaction_dts.raw_in_grid')
            ->orderBy('item_pack')
            ->get();

        if (count($pkgTransaction)) {
            $lastPack = $pkgTransaction[0]->item_pack;
            $boxCount = $pkgTransaction[0]->transactiondt_nbOfCarton;
            $PAK = "";

            for ($i = 1; $i < count($pkgTransaction); $i++) {
                $element = $pkgTransaction[$i];
                if ($element->item_pack == $lastPack) {
                    $boxCount = $boxCount + $element->transactiondt_nbOfCarton;
                } else {
                    if ($PAK == "") {

                        $PAK = $PAK . "" . $boxCount . "-" . $lastPack;
                    } else {
                        $PAK = $PAK . "," . $boxCount . "-" . $lastPack;
                    }
                    $lastPack = $pkgTransaction[$i]->item_pack;
                    $boxCount = $pkgTransaction[$i]->transactiondt_nbOfCarton;
                }
            }
            if ($PAK == "") {
                $pkgTransaction = $PAK . "" . $boxCount . "-" . $lastPack;
            } else {
                $pkgTransaction = $PAK . "," . $boxCount . "-" . $lastPack;
            }
        }

        //return $pkgTransaction;


        // if( count($pkgTransaction) )
        // {
        //     $pkgTransaction = implode(", ",$pkgTransaction->toArray());
        // }
        // else
        // {
        //     $pkgTransaction = null;
        // }


        $hsCodeOnTransaction = DB::table('transaction_dts')
            ->leftjoin('items', 'items.item_id', '=', 'transaction_dts.item_id')
            ->distinct()
            ->where([
                ['transaction_dts.transaction_id', '=', $transactionId]
            ])
            ->select('transaction_dts.hscode')
            ->pluck('transaction_dts.hscode');

        if (count($hsCodeOnTransaction)) {
            $hsCodeOnTransaction = implode(", ", $hsCodeOnTransaction->toArray());
        } else {
            $hsCodeOnTransaction = null;
        }


        $transactionDtDistinctCell = DB::select(

            " SELECT `transactiondt_cellMerge` ,SUM(`transactiondt_nbOfCarton`) AS nbOfCarton
                FROM ( SELECT `raw_in_grid`,`transactiondt_nbOfCarton`,`transactiondt_cellMerge` FROM `transaction_dts`
                WHERE transaction_id =" . $transactionId . "
                GROUP BY `raw_in_grid`,`transactiondt_nbOfCarton`,`transactiondt_cellMerge` ) AS Q1
                GROUP BY `transactiondt_cellMerge`"
        );


        $sumOfCarton = DB::select(

            " SELECT SUM(`transactiondt_nbOfCarton`) AS nbOfCarton
                FROM ( SELECT `raw_in_grid`,`transactiondt_nbOfCarton`,`transactiondt_cellMerge` FROM `transaction_dts`
                WHERE transaction_id =" . $transactionId . "
                GROUP BY `raw_in_grid`,`transactiondt_nbOfCarton`,`transactiondt_cellMerge` ) AS Q1"
        );


        $transactionDtTotalDistincts = DB::table('transaction_dts')
            ->where('transaction_dts.transaction_id', '=', $transactionId)
            ->select('item_id', 'transactiondt_nbOfCarton', 'item_weight')
            ->distinct('item_id')
            ->get();


        $totalWeight = 0;
        $totalNbOfCarton = 0;

        foreach ($transactionDtTotalDistincts as $transactionDtTotalDistinct) {
            $totalWeight = $totalWeight + $transactionDtTotalDistinct->item_weight;
            $totalNbOfCarton = $totalNbOfCarton + $transactionDtTotalDistinct->transactiondt_nbOfCarton;
        }


        $transactionDByGroup = DB::table('transaction_dts')
            ->where('transaction_dts.transaction_id', '=', $transactionId)
            ->where('transaction_dts.transaction_id', '=', $transactionId)
            ->leftjoin('items', 'items.item_id', '=', 'transaction_dts.item_id')
            ->leftjoin('countries', 'countries.country_id', '=', 'transaction_dts.transactiondt_countryOfOrigin')
            ->leftjoin('item_groups', 'item_groups.group_id', '=', 'transaction_dts.group_id')
            ->select(
                'transaction_dts.*',
                'items.item_code',
                'transaction_dts.transactiondt_item_description',
                'transaction_dts.item_pack as pack',
                'items.item_barcode',
                'items.item_hasSerial',
                'transaction_dts.hscode',
                'countries.*',
                'item_groups.group_code',
                'item_groups.group_name',
            )
            ->orderBy('palet_no')
            ->selectRaw('SUM(item_quantity) as item_quantity')
            ->get();


        // return ApiController::successResponse($transactionDByGroup,200);


        // $transactionDtTotalDistincts->totalWeight=$totalWeight;
        // $transactionDtTotalDistincts->totalNbOfCarton=$totalNbOfCarton;
        // ->selectRaw('SUM(transactiondt_nbOfCarton) as item_total_nbOfCartons')
        // ->selectRaw('SUM(item_weight) as item_total_weight')
        // ->first();

        // $transactionDtTotalDistinct = DB::table('transaction_dts')
        // ->where('transaction_dts.transaction_id', '=', $transactionId)
        // ->groupBy('item_id')
        // ->get();

        //return ApiController::successResponse($transactionDtTotalDistincts,200);


        $transactionDtTotal = DB::table('transaction_dts')
            ->where('transaction_dts.transaction_id', '=', $transactionId)
            ->selectRaw('SUM(transaction_dts.item_quantity) as item_total_quantity')
            ->selectRaw('SUM(transaction_dts.item_quantity*transaction_dts.transactiondt_price) as item_total_price')
            ->selectRaw('SUM(transaction_dts.item_quantity*transaction_dts.item_weight) as item_total_weight')
            ->selectRaw('SUM(transaction_dts.item_quantity*transaction_dts.gross_weight) as item_total_gross_weight')

            ->selectRaw('SUM(transaction_dts.transactiondt_nbOfCarton) as item_total_nbOfCartons')
            ->first();


        // $companie=DB::table('companies')
        // ->where('companies.company_id', '=', $transactionId)
        // ->first();
        if (!isset($transactionDt) || !$transactionDtTotal || !$transaction) {
            return ApiController::errorResponse("Error request", 422);
        }


        if ($withSerial) {
            $serialData = $this->getDOData($transactionId)->getData()->data;
        } else {
            $serialData = null;
        }

        $data = [
            'transaction' => $transaction,
            'transactionDByGroup' => $transactionDByGroup,
            'totalWeight' => $totalWeight,
            'totalNbOfCarton' => $totalNbOfCarton,
            'transactionDtDistinctCell' => $transactionDtDistinctCell,
            'nbOfCartonByRow' => $nbOfCartonByRow,
            'weightByRow' => $weightByRow,
            'grossWeightByRow' => $grossWeightByRow,
            'modelsByRow' => $modelsByRow,
            'sumOfCarton' => $sumOfCarton,
            'pkgTransaction' => $pkgTransaction,
            'transactionDtComercial' => $transactionDtComercial,
            'transactionDtNote' => $transactionDtNote,
            'nbOfCartonByRowNote' => $nbOfCartonByRowNote,
            'weightByRowNote' => $weightByRowNote,
            'modelsByRowNote' => $modelsByRowNote,
            'pallet' => $pallets,
            'transactionDtByGroup' => $transactionDtByGroup,
            'transactionDt' => $transactionDts,
            'transactionDtTotal' => $transactionDtTotal,
            'countriesOnTransaction' => $countriesOnTransaction,
            'billOfEntryOnTransaction' => $billOfEntryOnTransaction,
            'hsCodeOnTransaction' => $hsCodeOnTransaction,
            'withStamp' => $withStamp,
            'hscodeSummary' => $hscodeSummary,
            'company' => $company,
            'serialData' => $serialData,

            'transactionDtAdvice' => $transactionDtAdvice,
        ];
        return ApiController::successResponse($data, 200);
    }

    public function getDOData($transactionId)
    {
        $Obj = array();
        $UtilitiesController = new UtilitiesController();

        $transaction = DB::table('transactions')
            ->join('clients', 'clients.client_id', '=', 'transactions.transaction_clientId')
            ->join('companies', 'companies.company_id', '=', 'transactions.company_id')
            ->leftjoin('suppliers', 'suppliers.supplier_id', 'transactions.transaction_supplierId')
            ->where('transactions.transaction_id', '=', $transactionId)
            ->select('transactions.*', 'clients.*', 'suppliers.*', 'companies.*', 'transactions.company_id')
            ->first();
        $transaction->transaction_date = date('Y-m-d', $transaction->transaction_date);
        $Obj['transaction'] = $transaction;

        if ($transaction) {
            $transactiondt = DB::table('transaction_dts')
                ->join('items', 'items.item_id', '=', 'transaction_dts.item_id')
                ->leftjoin('countries', 'countries.country_id', 'transaction_dts.transactiondt_countryOfOrigin')
                ->leftjoin('locations', 'locations.location_id', 'transaction_dts.transactiondt_locationid')
                ->select("transaction_dts.*", "countries.*", "items.*", "locations.*");

            $allHeadears = Db::table('transaction_dts')
                ->leftjoin('items', 'items.item_id', 'transaction_dts.item_id')
                ->leftjoin('serial_types', 'serial_types.serial_id', 'items.serial_type_id')
                ->where([
                    ['transaction_dts.transaction_id', '=', $transactionId],
                    ['items.item_hasSerial', '=', 1],

                ])
                ->select('serial_types.serial_label')
                ->groupBy('serial_types.serial_label')
                ->orderBy('serial_types.serial_code')
                ->orderBy('serial_types.serial_order')
                ->pluck('serial_types.serial_label');


            foreach ($allHeadears as $headears) {
                $transactiondt = $transactiondt->addSelect(DB::raw('COALESCE("' . $headears . '", "") as `' . $headears . '`'));
            }
            // ->leftjoin('transaction_dtsns','transaction_dtsns.transactiondt_id','transaction_dts.transactiondt_id')
            $transactiondt = $transactiondt->where('transaction_dts.transaction_id', '=', $transactionId)
                ->get();
            foreach ($transactiondt as $dt) {

                foreach ($allHeadears as $headears) {
                    $dt->{$headears} = [];
                }
                $serial = DB::table('transaction_dtsns')
                    ->where('transaction_dtsns.transactiondt_id', '=', $dt->transactiondt_id)
                    ->select('transaction_item_serial')
                    ->get();


                $transactionSerials = DB::table('transaction_dtsns')
                    ->leftjoin('transaction_dts', 'transaction_dts.transactiondt_id', 'transaction_dtsns.transactiondt_id')
                    ->select(
                        'transaction_dtsns.transactiondtsn_id',
                        'transaction_dtsns.transaction_item_serial',
                        'transaction_dtsns.transactiondt_id',
                        'transaction_dts.item_id'
                    )
                    ->where([
                        ['transaction_dts.transactiondt_id', $dt->transactiondt_id],
                    ])
                    ->get();

                $serialsHeadear = Db::table('transaction_dts')
                    ->leftjoin('items', 'items.item_id', 'transaction_dts.item_id')
                    ->leftjoin('serial_types', 'serial_types.serial_id', 'items.serial_type_id')
                    ->where([
                        ['transaction_dts.transactiondt_id', $dt->transactiondt_id],
                    ])
                    ->select('serial_types.serial_label')
                    ->pluck('serial_types.serial_label');

                foreach ($transactionSerials as $serial) {
                    $splitSerials = explode(';', $serial->transaction_item_serial);
                    for ($i = 0; $i < count($serialsHeadear); $i++) {
                        $header = $serialsHeadear[$i];
                        array_push($dt->{$header}, $splitSerials[$i]);
                    }
                }
                $dt->serialsHeadear = $serialsHeadear;
                // $dt->serial = $transactionSerials;
            }
            $Obj['transactiondt'] = $transactiondt;
            $Obj['allHeadears'] = $allHeadears;
            $Obj['tableWidth'] = 5 + count($allHeadears);
            $Obj['tableWidthTotal'] = 4 + count($allHeadears);
            $Obj['company'] = DB::table('companies')->first();
            $Obj['transactiondt'] = $transactiondt;
        }
        return ApiController::successResponse($Obj, 200);
    }

    public function generatePDF()
    {
        $data = [
            'title' => 'Welcome to Nicesnippets.com',
            'date' => date('m/d/Y')
        ];

        $pdf = PDF::loadView('myPDF', $data);

        return $pdf->stream('nicesnippets.pdf');
    }

    public function TransferOfOwnershipInvoicePdf(Request $request)
    {
        $UtilitiesController = new UtilitiesController();
        $requestData = $UtilitiesController->decipherRequest($request->transactionId);

        $requestData = json_decode($requestData);
        $language = $requestData->info->language;
        $transactionId = $requestData->info->id;
        $withStamp = $requestData->info->withStamp;
        $hscodeSummary = $requestData->info->hscodeSummary;
        $dataResult = $this->getData($transactionId, $withStamp, $hscodeSummary);
        $dataTransaction = $dataResult->getData();
        //return $dataTransaction;
        $moduleKeys = Localization::moduleKeys; // Assuming this is an array of keys

        $company = DB::table('companies')
            ->first();
        $Obj = array();
        $Obj['data'] = $dataTransaction->data;
        $Obj['isShipment'] = $company->company_onlyShipment;
        $Obj['withStamp'] = $withStamp;
        $Obj['moduleKeys'] = $moduleKeys;
        $Obj['hscodeSummary'] = $hscodeSummary;
        $Obj['language'] = $language;
        $Obj['transactionId'] = $transactionId;
        $Obj['company'] = $company;

        $Obj['perWeight'] = $moduleKeys['qtyPerPcs'][$language];
        $Obj['unitType'] = $moduleKeys['unitTypePcs'][$language];


        $withWeight = $requestData->info->perWeight;
        if ($withWeight == true) {
            $Obj['perWeight'] = $moduleKeys['qtyPerWeight'][$language];
            $Obj['unitType'] = $moduleKeys['unitTypeWeight'][$language];
        }

        if ($dataResult->status() == 422) {
            return ApiController::successResponse("No data", 200);
        }
        $Obj['specificPdf'] = './components/';

        $p = 'views/' . $dataTransaction->data->company->company_user_name . '/components/Transfer_of_ownership_component.blade.php';

        $path = resource_path($p);

        if (file_exists($path)) {
            $Obj['specificPdf'] = './' . $dataTransaction->data->company->company_user_name . '' . $Obj['specificPdf'];
        } else {
        }
        $commonServices = new CommonServices();
        $decimals = $commonServices->getDecimal();
        $Obj['decimals'] = $decimals;
        $pdf = PDF::loadView(
            'Transfer_of_ownership',
            (array)$Obj,
            [],
            [
                'title' => 'Certificate',
                'format' => config('app.PDFFORMAT'),
                'orientation' => 'P'
            ]
        );

        return $pdf->stream('Transfer-of-ownership(' . $dataTransaction->data->transaction->transaction_reference . ').pdf');
    }

    public function DeliveryPdf(Request $request)
    {
        $UtilitiesController = new UtilitiesController();
        $requestData = $UtilitiesController->decipherRequest($request->transactionId);

        $requestData = json_decode($requestData);

        $transactionId = $requestData->info->id;
        $withStamp = $requestData->info->withStamp;
        $hscodeSummary = $requestData->info->hscodeSummary;
        $withSerial = $requestData->info->withSerial;
        $language = $requestData->info->language;


        $dataResult = $this->getData($transactionId, $withStamp, $hscodeSummary, $withSerial);
        $dataTransaction = $dataResult->getData();
        //return $dataTransaction;
        $data = array();

        if ($dataResult->status() == 422) {
            return ApiController::successResponse("No data", 200);
        }

        $moduleKeys = Localization::moduleKeys; // Assuming this is an array of keys

        $company = DB::table('companies')
            ->first();
        $Obj = array();
        $Obj['data'] = $dataTransaction->data;
        $Obj['isShipment'] = $company->company_onlyShipment;
        $Obj['withStamp'] = $withStamp;
        $Obj['moduleKeys'] = $moduleKeys;
        $Obj['hscodeSummary'] = $hscodeSummary;
        $Obj['language'] = $language;
        $Obj['transactionId'] = $transactionId;
        $Obj['company'] = $company;

        $Obj['perWeight'] = $moduleKeys['qtyPerPcs'][$language];
        $Obj['unitType'] = $moduleKeys['unitTypePcs'][$language];


        $Obj['totalunit'] = $moduleKeys['totalNOQty/unit'][$language] . $Obj['unitType'];
        $Obj['specificPdf'] = './components/';
        ini_set('max_execution_time', '50000');
        ini_set("pcre.backtrack_limit", "5000000000");


        ini_set('memory_limit', '200048M');
        $withWeight = $requestData->info->perWeight;
        ini_set('max_execution_time', '50000');
        ini_set("pcre.backtrack_limit", "5000000000");
        ini_set('memory_limit', '200048M');

        if ($withWeight == true) {
            $Obj['perWeight'] = $moduleKeys['qtyPerWeight'][$language];
            $Obj['unitType'] = $moduleKeys['unitTypeWeight'][$language];
            $Obj['totalunit'] = $moduleKeys['totalNOQty/unit'][$language] . $Obj['unitType'];
        }

        if ($dataTransaction->data->company->company_user_name != null && $dataTransaction->data->company->company_user_name != '') {

            $Obj['specificPdf'] = './' . $dataTransaction->data->company->company_user_name . '' . $Obj['specificPdf'];
            //  $pdf = PDF::loadView($dataTransaction->data->company->company_user_name . '/DeliveryPdf', (array)$Obj);
        } else {
        }

        $commonServices = new CommonServices();
        $decimals = $commonServices->getDecimal();
        $Obj['decimals'] = $decimals;
        $pdf = PDF::loadView(
            'DeliveryPdf',
            $Obj,
            [],
            [
                'title' => 'Certificate',
                'format' => config('app.PDFFORMAT'),
                'orientation' => 'P'
            ]
        );


        return $pdf->stream('Delivery(' . $dataTransaction->data->transaction->transaction_reference . ').pdf');
    }

    public function deliveryAdviceInvoicePdf(Request $request)
    {

        $UtilitiesController = new UtilitiesController();
        $requestData = $UtilitiesController->decipherRequest($request->transactionId);

        $requestData = json_decode($requestData);
        $transactionId = $requestData->info->id;
        $withStamp = $requestData->info->withStamp;
        $hscodeSummary = $requestData->info->hscodeSummary;
        $language = $requestData->info->language;

        $dataResult = $this->getData($transactionId, $withStamp, $hscodeSummary);
        $dataTransaction = $dataResult->getData();
        $moduleKeys = Localization::moduleKeys; // Assuming this is an array of keys
        $company = DB::table('companies')
            ->first();
        $Obj = array();
        $Obj['data'] = $dataTransaction->data;
        $Obj['isShipment'] = $company->company_onlyShipment;
        $Obj['withStamp'] = $withStamp;
        $Obj['moduleKeys'] = $moduleKeys;
        $Obj['hscodeSummary'] = $hscodeSummary;
        $Obj['language'] = $language;
        $Obj['transactionId'] = $transactionId;
        $Obj['company'] = $company;

        if ($dataResult->status() == 422) {
            return ApiController::successResponse("No data", 200);
        }

        $Obj['specificPdf'] = './components/';

        $p = 'views/' . $dataTransaction->data->company->company_user_name . '/components/DeliveryAdvice_component.blade.php';
        $path = resource_path($p);
        if (file_exists($path)) {
            $Obj['specificPdf'] = './' . $dataTransaction->data->company->company_user_name . '' . $Obj['specificPdf'];
        } else {
        }
        $commonServices = new CommonServices();
        $decimals = $commonServices->getDecimal();
        $Obj['decimals'] = $decimals;
        $pdf = PDF::loadView(
            'DeliveryAdvice',
            (array)$Obj,
            [],
            [
                'title' => 'Certificate',
                'format' => 'A4',
                'orientation' => 'P'
            ]
        );
        return $pdf->stream('Delivery-Advice(' . $dataTransaction->data->transaction->transaction_reference . ').pdf');
    }

    public function deliveryNoteInvoicePdf(Request $request)
    {
        $UtilitiesController = new UtilitiesController();
        $requestData = $UtilitiesController->decipherRequest($request->transactionId);
        $requestData = json_decode($requestData);

        $transactionId = $requestData->info->id;
        $withStamp = $requestData->info->withStamp;
        $hscodeSummary = $requestData->info->hscodeSummary;
        $language = $requestData->info->language;
        $moduleKeys = Localization::moduleKeys; // Assuming this is an array of keys
        $company = DB::table('companies')
            ->first();
        $Obj = array();
        $Obj['transactionId'] = $transactionId;
        $Obj['withStamp'] = $withStamp;
        $Obj['hscodeSummary'] = $hscodeSummary;
        $Obj['language'] = $language;
        $Obj['moduleKeys'] = $moduleKeys;
        $Obj['company'] = $company;
        $dataResult = $this->getData($transactionId, $withStamp, $hscodeSummary);
        $dataTransaction = $dataResult->getData();
        $Obj['data'] = $dataTransaction->data;
        $Obj['isShipment'] = $company->company_onlyShipment;
        $Obj['perWeight'] = $moduleKeys['qtyPerPcs'][$language];
        $Obj['unitType'] = $moduleKeys['unitTypePcs'][$language];
        $Obj['totalunit'] = $moduleKeys['totalNOQty/unit'][$language] . $Obj['unitType'];

        $withWeight = $requestData->info->perWeight;
        if ($withWeight == true) {
            $Obj['perWeight'] = $moduleKeys['qtyPerWeight'][$language];
            $Obj['unitType'] = $moduleKeys['unitTypeWeight'][$language];
            $Obj['totalunit'] = $moduleKeys['totalNOQty/unit'][$language] . $Obj['unitType'];
        }

        if ($dataResult->status() == 422) {
            return ApiController::successResponse("No data", 200);
        }

        $commonServices = new CommonServices();
        $decimals = $commonServices->getDecimal();
        $Obj['decimals'] = $decimals;
        $Obj['specificPdf'] = './components/';

        $p = 'views/' . $dataTransaction->data->company->company_user_name . '/components/DeliveryNote_component.blade.php';
        $path = resource_path($p);
        if (file_exists($path)) {
            $Obj['specificPdf'] = './' . $dataTransaction->data->company->company_user_name . '' . $Obj['specificPdf'];
        }


        $pdf = PDF::loadView('DeliveryNote', (array)$Obj);
        return $pdf->stream('Delivery-Note(' . $dataTransaction->data->transaction->transaction_reference . ').pdf');
    }

    public function pickingListInvoicePdf(Request $request)
    {
        $UtilitiesController = new UtilitiesController();
        $requestData = $UtilitiesController->decipherRequest($request->transactionId);
        $requestData = json_decode($requestData);

        $transactionId = $requestData->info->id;
        $withStamp = $requestData->info->withStamp;
        $hscodeSummary = $requestData->info->hscodeSummary;
        $language = $requestData->info->language;
        $moduleKeys = Localization::moduleKeys; // Assuming this is an array of keys
        $company = DB::table('companies')
            ->first();
        $Obj = array();
        $Obj['transactionId'] = $transactionId;
        $Obj['withStamp'] = $withStamp;
        $Obj['hscodeSummary'] = $hscodeSummary;
        $Obj['language'] = $language;
        $Obj['moduleKeys'] = $moduleKeys;
        $Obj['company'] = $company;
        $dataResult = $this->getData($transactionId, $withStamp, $hscodeSummary);
        $dataTransaction = $dataResult->getData();
        $Obj['data'] = $dataTransaction->data;
        $Obj['isShipment'] = $company->company_onlyShipment;
        $Obj['perWeight'] = $moduleKeys['qtyPerPcs'][$language];
        $Obj['unitType'] = $moduleKeys['unitTypePcs'][$language];
        $Obj['totalunit'] = $moduleKeys['totalNOQty/unit'][$language] . $Obj['unitType'];

        $withWeight = $requestData->info->perWeight;
        if ($withWeight == true) {
            $Obj['perWeight'] = $moduleKeys['qtyPerWeight'][$language];
            $Obj['unitType'] = $moduleKeys['unitTypeWeight'][$language];
            $Obj['totalunit'] = $moduleKeys['totalNOQty/unit'][$language] . $Obj['unitType'];
        }

        // return $Obj;

        if ($dataResult->status() == 422) {
            return ApiController::successResponse("No data", 200);
        }

        $Obj['specificPdf'] = './components/';

        $p = 'views/' . $dataTransaction->data->company->company_user_name . '/components/DeliveryPicking_component.blade.php';
        $path = resource_path($p);
        if (file_exists($path)) {
            $Obj['specificPdf'] = './' . $dataTransaction->data->company->company_user_name . '' . $Obj['specificPdf'];
        } else {
        }

        $commonServices = new CommonServices();
        $decimals = $commonServices->getDecimal();
        $Obj['decimals'] = $decimals;
        $pdf = PDF::loadView(
            'DeliveryPicking',
            $Obj,
            [],
            [
                'title' => 'Certificate',
                'format' => config('app.PDFFORMAT'),
                'orientation' => config('app.LANDSCAPEPDF')
            ]
        );
        return $pdf->stream('DeliveryPicking(' . $dataTransaction->data->transaction->transaction_reference . ').pdf');
    }

    public function deliveryReportData(Request $request)
    {

        $UtilitiesController = new UtilitiesController();
        $requestData = $UtilitiesController->decipherRequest($request->transactionId);
        $requestData = json_decode($requestData);
        $transactionId = $requestData->info->id;
        $language = $requestData->info->language;

        $dataResult = $this->getData($transactionId, false, false);
        $dataTransaction = $dataResult->getData();
        $data = array();

        if ($dataResult->status() == 422) {
            return ApiController::successResponse("No data", 422);
        }

        return ApiController::successResponse($dataTransaction, 200);
    }

    public function goodsInInvoicePdf(Request $request)
    {

        $UtilitiesController = new UtilitiesController();
        $requestData = $UtilitiesController->decipherRequest($request->transactionId);
        $requestData = json_decode($requestData);

        $request = $requestData->info->id;
        $language = $requestData->info->language;

        $transaction = $this->getGoodInData($request)->getData()->data;

        $moduleKeys = Localization::moduleKeys; // Assuming this is an array of keys
        $company = DB::table('companies')
            ->first();

        $Obj = array();
        $transaction->client = "f";
        $transaction->image = public_path("/images/splash.png");
        $Obj['data'] = $transaction;
        $Obj['isShipment'] = $company->company_onlyShipment;
        $Obj['moduleKeys'] = $moduleKeys;
        $Obj['company'] = $company;
        $Obj['language'] = $language;

        ini_set('max_execution_time', '50000');
        ini_set("pcre.backtrack_limit", "5000000000");


        ini_set('memory_limit', '200048M');
        if ($transaction->transaction->internal_transfer == 1 || $transaction->transaction->internal_transfer == true) {
            if ($language == "en") {
                $pdf = PDF::loadView('Internal_Invoice', (array)$transaction);
            } else {
                $pdf = PDF::loadView('/arabic/Internal_Invoice_' . $language, (array)$transaction);
            }
            return $pdf->stream('Internal_Invoice.pdf');
        }
        $commonServices = new CommonServices();
        $decimals = $commonServices->getDecimal();
        $Obj['decimals'] = $decimals;

        $pdf = PDF::loadView('GoodsIn_Invoice', (array)$Obj);


        return $pdf->stream('GoodsIn_Invoice.pdf');
    }

    public function getGoodInData($transactionId)
    {
        $Obj = array();
        $UtilitiesController = new UtilitiesController();
        $commonServices = new CommonServices();

        $decimals = $commonServices->getDecimal();
        $checkIfInternal = DB::table('transactions')
            ->where('transactions.transaction_id', '=', $transactionId)
            ->first();
        if ($checkIfInternal && $checkIfInternal->internal_transfer && $checkIfInternal->relatedTransferId) {
            $transactionId = $checkIfInternal->relatedTransferId;
        }
        $transaction = DB::table('transactions')
            ->join('clients', 'clients.client_id', '=', 'transactions.transaction_clientId')
            ->join('companies', 'companies.company_id', '=', 'transactions.company_id')
            ->leftjoin('suppliers', 'suppliers.supplier_id', 'transactions.transaction_supplierId')
            ->leftjoin('users', 'users.id', 'transactions.user_id')

            ->leftjoin('client_customers', 'client_customers.customer_id', 'transactions.clientCustomer_id')
            ->leftjoin('currency', 'currency.currency_id', 'transactions.transaction_currencyId')
            ->leftjoin('clients as transferClient', 'transferClient.client_id', 'transactions.transferTo_clientId')
            ->select(
                'transactions.*',
                'clients.client_firstname',
                'clients.client_id',
                'companies.company_logo',
                'companies.company_footer',
                'client_customers.customer_name',
                'suppliers.supplier_name',
                'currency.currency_code',
                'transferClient.client_firstname as toclient',
                'user_name',
            )
            ->where('transactions.transaction_id', '=', $transactionId)
            ->first();

        $paymentMethodId = '';
        $paymentMethod = DB::table('payment_methods')
            ->where('id', $transaction->transaction_paymentMethodId)
            ->first();
        if ($paymentMethod) {
            $paymentMethodId = $paymentMethod->name;
        }
        $transaction->transaction_date = date('Y-m-d', $transaction->transaction_date);

        if (config('app.PrintOutTime') == 1) {
            $transaction->transaction_time = date('H:i', strtotime($transaction->transaction_time));
        } else {
            $transaction->transaction_time = "";
        }

        $Obj['transaction'] = $transaction;

        if ($transaction) {
            $transactiondt = DB::table('transaction_dts')
                ->join('items', 'items.item_id', '=', 'transaction_dts.item_id')
                ->leftjoin('countries', 'countries.country_id', 'transaction_dts.transactiondt_countryOfOrigin')
                ->leftjoin('locations', 'locations.location_id', 'transaction_dts.transactiondt_locationid')
                ->SELECT('transaction_dts.*', "items.item_code", "transaction_dts.transactiondt_item_description", "countries.country_name", "locations.location_name")
                ->selectRaw(" FORMAT(transaction_dts.item_weight * item_quantity, " . $decimals['doWeight'] . ") as total_weight")
                ->selectRaw(" FORMAT(transactiondt_price * item_quantity_to_delivery, " . $decimals['doPrice'] . ") as totalRowPrice")
                ->selectRaw(" FORMAT(transaction_dts.item_weight, " . $decimals['doWeight'] . ") as item_weight")
                ->selectRaw(" FORMAT(transactiondt_price, " . $decimals['doPrice'] . ") as transactiondt_price")
                ->selectRaw(" FORMAT(transaction_dts.item_weight * item_quantity, " . $decimals['doWeight'] . ") as total_weight")
                ->selectRaw(" FORMAT(transaction_dts.transactiondt_price * item_quantity, " . $decimals['doPrice'] . ") as total_price")
                ->selectRaw(" FORMAT(transaction_dts.total_gross_weight, " . $decimals['doWeight'] . ") as total_gross_weight")


                ->where('transaction_dts.transaction_id', '=', $transactionId)
                ->get();
            $Obj['transactiondt'] = $transactiondt;
        }
        $Obj['total'] = DB::table('transactions')
            ->leftjoin('transaction_dts', 'transaction_dts.transaction_id', 'transactions.transaction_id')
            ->where('transactions.transaction_id', '=', $transactionId)
            ->selectRaw(" FORMAT( SUM(transaction_dts.item_weight * item_quantity) , " . $decimals['doWeight'] . ") as total_weight")
            ->selectRaw(" FORMAT(SUM(transactiondt_price * item_quantity)," . $decimals['doPrice'] . ") as total_price")
            ->selectRaw(" FORMAT(SUM(item_quantity),0) as total_qty")
            ->selectRaw(" FORMAT(SUM(total_gross_weight)," . $decimals['doWeight'] . ") as total_gross_weight")
            ->selectRaw(" FORMAT(SUM(item_quantity_to_delivery),0) as total_qty_delivered")
            ->selectRaw(" FORMAT(SUM(item_quantity_to_cancel),0) as total_qty_canceled")
            ->selectRaw(" FORMAT(SUM(item_quantity_to_delivery * transactiondt_price ),0) as total_qty_price")

            ->groupBy("transaction_dts.transaction_id")
            ->first();


        $Obj['company'] = DB::table('companies')->first();
        $Obj['paymentMethodId'] = $paymentMethodId;



        return ApiController::successResponse($Obj, 200);
    }

    public function doInvoicePdf(Request $request)
    {

        $UtilitiesController = new UtilitiesController();
        $requestData = $UtilitiesController->decipherRequest($request->transactionId);
        $requestData = json_decode($requestData);

        $request = $requestData->info->id;
        $language = $requestData->info->language;

        $transaction = $this->getGoodInData($request)->getData()->data;

        $moduleKeys = Localization::moduleKeys; // Assuming this is an array of keys
        $company = DB::table('companies')
            ->first();

        $Obj = array();
        $transaction->client = "f";
        $transaction->image = public_path("/images/splash.png");
        $Obj['data'] = $transaction;
        $Obj['isShipment'] = 1;
        $Obj['moduleKeys'] = $moduleKeys;
        $Obj['company'] = $company;
        $Obj['language'] = $language;

        $commonServices = new CommonServices();
        $decimals = $commonServices->getDecimal();
        $Obj['decimals'] = $decimals;
        $pdf = PDF::loadView('do_Invoice', (array)$Obj);


        // if ($Obj['isShipment'] == 0) {
        //     $pdf = PDF::loadView('/shipment/do_Invoice', (array)$Obj);
        // }


        return $pdf->stream('do_Invoice.pdf');
    }
    public function dqReportPdf(Request $request)
    {

        $UtilitiesController = new UtilitiesController();
        $requestData = $UtilitiesController->decipherRequest($request->transactionId);
        $requestData = json_decode($requestData);

        $request = $requestData->info->id;
        $language = $requestData->info->language;

        $transaction = $this->getGoodInData($request)->getData()->data;

        $moduleKeys = Localization::moduleKeys; // Assuming this is an array of keys
        $company = DB::table('companies')
            ->first();

        $Obj = array();
        $transaction->client = "f";
        $transaction->image = public_path("/images/splash.png");
        $Obj['data'] = $transaction;
        $Obj['isShipment'] = 1;
        $Obj['moduleKeys'] = $moduleKeys;
        $Obj['company'] = $company;
        $Obj['language'] = $language;

        $commonServices = new CommonServices();
        $decimals = $commonServices->getDecimal();
        $Obj['decimals'] = $decimals;
        $pdf = PDF::loadView('dq_report', (array)$Obj);


        // if ($Obj['isShipment'] == 0) {
        //     $pdf = PDF::loadView('/shipment/do_Invoice', (array)$Obj);
        // }


        return $pdf->stream('dq_report.pdf');
    }
    public function dqInvoicePdf(Request $request)
    {

        $UtilitiesController = new UtilitiesController();
        $requestData = $UtilitiesController->decipherRequest($request->transactionId);
        $requestData = json_decode($requestData);

        $request = $requestData->info->id;
        $language = $requestData->info->language;

        $transaction = $this->getGoodInData($request)->getData()->data;

        $moduleKeys = Localization::moduleKeys; // Assuming this is an array of keys
        $company = DB::table('companies')
            ->first();

        $Obj = array();
        $transaction->client = "f";
        $transaction->image = public_path("/images/splash.png");
        $Obj['data'] = $transaction;
        $Obj['isShipment'] = 1;
        $Obj['moduleKeys'] = $moduleKeys;
        $Obj['company'] = $company;
        $Obj['language'] = $language;

        $commonServices = new CommonServices();
        $decimals = $commonServices->getDecimal();
        $Obj['decimals'] = $decimals;
        $pdf = PDF::loadView('dq_Invoice', (array)$Obj);


        // if ($Obj['isShipment'] == 0) {
        //     $pdf = PDF::loadView('/shipment/do_Invoice', (array)$Obj);
        // }


        return $pdf->stream('dq_Invoice.pdf');
    }
    public function goodsInSeriaslInvoicePdf(Request $request)
    {
        $UtilitiesController = new UtilitiesController();
        $requestData = $UtilitiesController->decipherRequest($request->transactionId);
        $requestData = json_decode($requestData);
        $request = $requestData->info->id;
        $language = $requestData->info->language;


        $transaction = $this->getGoodInSerialData($request)->getData()->data;


        //  return  $transaction ;
        $commonServices = new CommonServices();
        $decimals = $commonServices->getDecimal();
        $Obj['decimals'] = $decimals;
        if ($language == "en") {
            $pdf = PDF::loadView('GoodsIn_Serial_Invoice', (array)$transaction);
        } else {
            $pdf = PDF::loadView('/arabic/GoodsIn_Serial_Invoice_' . $language, (array)$transaction);
        }

        return $pdf->stream('GoodsIn_Serial_Invoice(' . $transaction->transaction->transaction_reference . ').pdf');
    }

    public function getGoodInSerialData($transactionId)
    {
        $Obj = array();
        $UtilitiesController = new UtilitiesController();

        $transaction = DB::table('transactions')
            ->join('clients', 'clients.client_id', '=', 'transactions.transaction_clientId')
            ->join('companies', 'companies.company_id', '=', 'transactions.company_id')
            ->leftjoin('suppliers', 'suppliers.supplier_id', 'transactions.transaction_supplierId')
            ->leftjoin('client_customers', 'client_customers.customer_id', 'transactions.clientCustomer_id')
            ->where('transactions.transaction_id', '=', $transactionId)
            ->select('transactions.*', 'clients.client_firstname', 'clients.client_id', 'companies.company_logo', 'client_customers.customer_name', 'suppliers.supplier_name',)
            ->first();
        $transaction->transaction_date = date('Y-m-d', $transaction->transaction_date);
        $Obj['transaction'] = $transaction;

        if ($transaction) {
            $transactiondt = DB::table('transaction_dts')
                ->join('items', 'items.item_id', '=', 'transaction_dts.item_id')
                ->leftjoin('countries', 'countries.country_id', 'transaction_dts.transactiondt_countryOfOrigin')
                ->leftjoin('locations', 'locations.location_id', 'transaction_dts.transactiondt_locationid')
                ->where('transaction_dts.transaction_id', '=', $transactionId)
                ->select("transaction_dts.*", "countries.*", "items.*", "locations.*");

            $allHeadears = Db::table('transaction_dts')
                ->leftjoin('items', 'items.item_id', 'transaction_dts.item_id')
                ->leftjoin('serial_types', 'serial_types.serial_id', 'items.serial_type_id')
                ->where([
                    ['transaction_dts.transaction_id', '=', $transactionId],
                    ['items.item_hasSerial', '=', 1],

                ])
                ->select('serial_types.serial_label')
                ->groupBy('serial_types.serial_label')
                ->orderBy('serial_types.serial_code')
                ->orderBy('serial_types.serial_order')
                ->pluck('serial_types.serial_label');


            foreach ($allHeadears as $headears) {
                $transactiondt = $transactiondt->addSelect(DB::raw('COALESCE("' . $headears . '", "") as `' . $headears . '`'));
            }
            $transactiondt = $transactiondt->get();
            foreach ($transactiondt as $dt) {

                foreach ($allHeadears as $headears) {
                    $dt->{$headears} = [];
                }
                $serial = DB::table('transaction_dtsns')
                    ->where('transaction_dtsns.transactiondt_id', '=', $dt->transactiondt_id)
                    ->select('transaction_item_serial')
                    ->get();


                $transactionSerials = DB::table('transaction_dtsns')
                    ->leftjoin('transaction_dts', 'transaction_dts.transactiondt_id', 'transaction_dtsns.transactiondt_id')
                    ->select(
                        'transaction_dtsns.transactiondtsn_id',
                        'transaction_dtsns.transaction_item_serial',
                        'transaction_dtsns.transactiondt_id',
                        'transaction_dts.item_id'
                    )
                    ->where([
                        ['transaction_dts.transactiondt_id', $dt->transactiondt_id],
                    ])
                    ->get();

                $serialsHeadear = Db::table('transaction_dts')
                    ->leftjoin('items', 'items.item_id', 'transaction_dts.item_id')
                    ->leftjoin('serial_types', 'serial_types.serial_id', 'items.serial_type_id')
                    ->where([
                        ['transaction_dts.transactiondt_id', $dt->transactiondt_id],
                    ])
                    ->select('serial_types.serial_label')
                    ->pluck('serial_types.serial_label');

                foreach ($transactionSerials as $serial) {
                    $splitSerials = explode(';', $serial->transaction_item_serial);
                    for ($i = 0; $i < count($serialsHeadear); $i++) {
                        $header = $serialsHeadear[$i];
                        array_push($dt->{$header}, $splitSerials[$i]);
                    }
                }

                $dt->serialsHeadear = $serialsHeadear;
            }
            $Obj['transactiondt'] = $transactiondt;
            $Obj['allHeadears'] = $allHeadears;
            $Obj['tableWidth'] = 5 + count($allHeadears);
            $Obj['tableWidthTotal'] = 4 + count($allHeadears);
        }
        $Obj['company'] = DB::table('companies')
            ->first();
        return ApiController::successResponse($Obj, 200);
    }

    public function getGoodInInvoiceData($transactionId)
    {
        $Obj = array();
        $UtilitiesController = new UtilitiesController();

        $transaction = DB::table('transactions')
            ->join('clients', 'clients.client_id', '=', 'transactions.transaction_clientId')
            ->join('companies', 'companies.company_id', '=', 'transactions.company_id')
            ->leftjoin('suppliers', 'suppliers.supplier_id', 'transactions.transaction_supplierId')
            ->leftjoin('client_customers', 'client_customers.customer_id', 'transactions.clientCustomer_id')
            ->where('transactions.transaction_id', '=', $transactionId)
            ->select('transactions.*', 'clients.client_firstname', 'clients.client_id', 'companies.company_logo', 'client_customers.customer_name', 'suppliers.supplier_name',)
            ->first();
        $transaction->transaction_date = date('Y-m-d', $transaction->transaction_date);
        $Obj['transaction'] = $transaction;

        if ($transaction) {
            $transactiondt = DB::table('transaction_dts')
                ->join('items', 'items.item_id', '=', 'transaction_dts.item_id')
                ->leftjoin('countries', 'countries.country_id', 'transaction_dts.transactiondt_countryOfOrigin')
                ->leftjoin('locations', 'locations.location_id', 'transaction_dts.transactiondt_locationid')
                ->where('transaction_dts.transaction_id', '=', $transactionId)
                ->select("transaction_dts.*", "countries.*", "items.*", "locations.*");

            $allHeadears = Db::table('transaction_dts')
                ->leftjoin('items', 'items.item_id', 'transaction_dts.item_id')
                ->leftjoin('serial_types', 'serial_types.serial_id', 'items.serial_type_id')
                ->where([
                    ['transaction_dts.transaction_id', '=', $transactionId],
                    ['items.item_hasSerial', '=', 1],

                ])
                ->select('serial_types.serial_label')
                ->groupBy('serial_types.serial_label')
                ->orderBy('serial_types.serial_code')
                ->orderBy('serial_types.serial_order')
                ->pluck('serial_types.serial_label');


            foreach ($allHeadears as $headears) {
                $transactiondt = $transactiondt->addSelect(DB::raw('COALESCE("' . $headears . '", "") as `' . $headears . '`'));
            }
            $transactiondt = $transactiondt->get();
            foreach ($transactiondt as $dt) {

                foreach ($allHeadears as $headears) {
                    $dt->{$headears} = [];
                }
                $serial = DB::table('transaction_dtsns')
                    ->where('transaction_dtsns.transactiondt_id', '=', $dt->transactiondt_id)
                    ->select('transaction_item_serial')
                    ->get();


                $transactionSerials = DB::table('transaction_dtsns')
                    ->leftjoin('transaction_dts', 'transaction_dts.transactiondt_id', 'transaction_dtsns.transactiondt_id')
                    ->select(
                        'transaction_dtsns.transactiondtsn_id',
                        'transaction_dtsns.transaction_item_serial',
                        'transaction_dtsns.transactiondt_id',
                        'transaction_dts.item_id'
                    )
                    ->where([
                        ['transaction_dts.transactiondt_id', $dt->transactiondt_id],
                    ])
                    ->get();

                $serialsHeadear = Db::table('transaction_dts')
                    ->leftjoin('items', 'items.item_id', 'transaction_dts.item_id')
                    ->leftjoin('serial_types', 'serial_types.serial_id', 'items.serial_type_id')
                    ->where([
                        ['transaction_dts.transactiondt_id', $dt->transactiondt_id],
                    ])
                    ->select('serial_types.serial_label')
                    ->pluck('serial_types.serial_label');

                foreach ($transactionSerials as $serial) {
                    $splitSerials = explode(';', $serial->transaction_item_serial);
                    for ($i = 0; $i < count($serialsHeadear); $i++) {
                        $header = $serialsHeadear[$i];
                        array_push($dt->{$header}, $splitSerials[$i]);
                    }
                }

                $dt->serialsHeadear = $serialsHeadear;
            }
            $Obj['transactiondt'] = $transactiondt;
            $Obj['allHeadears'] = $allHeadears;
            $Obj['tableWidth'] = 5 + count($allHeadears);
            $Obj['tableWidthTotal'] = 4 + count($allHeadears);
        }
        $Obj['company'] = DB::table('companies')
            ->first();
        return ApiController::successResponse($Obj, 200);
    }

    public function DOSeriaslInvoicePdf(Request $request)
    {
        $UtilitiesController = new UtilitiesController();
        $requestData = $UtilitiesController->decipherRequest($request->transactionId);
        $requestData = json_decode($requestData);
        $request = $requestData->info->id;
        $language = $requestData->info->language;
        $transaction = $this->getDOData($request)->getData()->data;
        $commonServices = new CommonServices();
        $decimals = $commonServices->getDecimal();
        $Obj['decimals'] = $decimals;
        if ($language == "en") {
            $pdf = PDF::loadView('DO_Serial_Invoice', (array)$transaction);
        } else {
            $pdf = PDF::loadView('/arabic/DO_Serial_Invoice_' . $language, (array)$transaction);
        }
        // return  $transaction;
        //return $transaction;
        return $pdf->stream('DO_Serial_Invoice(' . $transaction->transaction->transaction_reference . ').pdf');
    }

    public function printDeliveredItems(Request $request)
    {

        $UtilitiesController = new UtilitiesController();

        $moduleKeys = Localization::moduleKeys; // Assuming this is an array of keys

        $requestData = $UtilitiesController->decipherRequest($request->transactionId);
        $requestData = json_decode($requestData);
        $request = $requestData->info->id;
        $language = $requestData->info->language;
        $company = DB::table('companies')->first();

        $clientName = "";
        $client = DB::table('transactions')
            ->leftjoin('clients', 'clients.client_id', '=', 'transactions.transaction_clientId')
            ->select('client_firstname', 'transaction_reference')
            ->selectRaw(DB::raw(" FROM_UNIXTIME(transactions.transaction_date, '%d-%m-%Y') AS delivered_date"))

            ->where('transactions.transaction_id', $request)
            ->first();
        if ($client) {
            $clientName = $client->client_firstname;
            $reference = $client->transaction_reference;
            $delivered_date = $client->delivered_date;
        }



        $dtIds = DB::table('transaction_dts')
            ->select('transaction_dts.transactiondt_id',)
            ->where('transaction_dts.transaction_id', $request)
            ->groupBy('transactiondt_id')
            ->pluck('transactiondt_id');


        $responseBalance = DB::table('transaction_dts')
            ->leftjoin('items', 'items.item_id', 'transaction_dts.item_id')

            ->leftjoin('clients', 'clients.client_id', '=', 'transaction_dts.client_id')
            ->leftjoin('transactions', 'transactions.transaction_id', 'transaction_dts.transaction_id')
            ->whereIn('reference_from_do', $dtIds)
            ->select('item_quantity', 'transaction_date', 'client_firstname', 'item_code')
            ->selectRaw('COALESCE(SUM(item_quantity_to_delivery), 0) as deliveredQty')
            ->selectRaw('COALESCE(SUM(item_quantity_to_cancel), 0) as canceledQty')
            ->selectRaw('COALESCE(SUM(item_quantity_to_delivery + item_quantity_to_cancel), 0) as remaining')
            ->selectRaw(DB::raw(" FROM_UNIXTIME(transactions.transaction_date, '%d-%m-%Y %h:%i') AS delivered_date"))

            ->groupBy('reference_from_do', 'transaction_date', 'transactiondt_id')
            //  ->orderBy('transaction_dts.transactiondt_id')
            ->get();

        $collection = collect($responseBalance);
        $grouped = $collection->groupBy('item_code')->map(function ($transactions, $clientId) {
            return [

                'data' => $transactions,
                'item' => $clientId,
            ];
        })->values();
        //   return $grouped;
        $Obj = array();
        $Obj['company_id'] = $company->company_id;
        $Obj['company_logo'] = $company->company_logo;
        $Obj['data'] = $grouped;
        $Obj['clientName'] = $clientName;
        $Obj['moduleKeys'] = $moduleKeys;
        $Obj['language'] = $language;
        $Obj['delivered_date'] = $delivered_date;
        $Obj['reference'] = $reference;

        $Obj['company'] = DB::table('companies')->first();

        $commonServices = new CommonServices();
        $decimals = $commonServices->getDecimal();
        $Obj['decimals'] = $decimals;
        $pdf = PDF::loadView('deliveredItems', (array)$Obj);


        return $pdf->stream('delivered Items.pdf');
    }


    public function printManifest(Request $request)
    {

        $UtilitiesController = new UtilitiesController();

        $moduleKeys = Localization::moduleKeys; // Assuming this is an array of keys

        $requestData = $UtilitiesController->decipherRequest($request->transactionId);
        $requestData = json_decode($requestData);
        $request = $requestData->info->id;
        $language = $requestData->info->language;
        $company = DB::table('companies')
            ->leftjoin('currency', 'currency.currency_id', 'companies.currency')
            ->first();

        $clientName = "";
        $forwarderName = "";
        $client = DB::table('transactions')
            ->leftjoin('clients', 'clients.client_id', '=', 'transactions.transaction_clientId')
            ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactions.forwarder_id')
            ->select('client_firstname', 'clientforwarder_name')
            ->where('transactions.transaction_id', $request)
            ->first();
        if ($client) {
            $clientName = $client->client_firstname;
            $forwarderName   = $client->clientforwarder_name;
        }


        $data = DB::table('transactions')
            ->where('transactions.transaction_id', $request)
            ->leftjoin('transaction_dts', 'transaction_dts.transaction_id', 'transactions.transaction_id')
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactions.clientCustomer_id')
            ->leftjoin('items', 'items.item_id', 'transaction_dts.item_id')
            ->select('transactions.*', 'transaction_dts.item_id', 'client_customers.customer_name')
            ->first();
        $data->transaction_date = date('d-m-Y', $data->transaction_date);


        $suppliers = DB::table('transaction_dts')
            ->where('transaction_id', $request)
            ->select('supplier_invoice_number')
            ->where('transaction_id', $request)
            ->groupBy('supplier_invoice_number')
            ->get();
        $supplierString = '';
        foreach ($suppliers as $supplier) {
            $supplierString .= $supplier->supplier_invoice_number . '/';
        }
        $supplierString = rtrim($supplierString, '/');

        $data->supplier = $supplierString;

        $dt = DB::table('transaction_dts')
            ->join('clients', 'clients.client_id', 'transaction_dts.client_id')
            ->select('transaction_dts.*', 'clients.client_firstName')
            ->selectRaw('SUM(item_weight*item_quantity) as totalWeight,SUM(transactiondt_priceBase*item_quantity )as totalPrice,SUM(total_gross_weight) as totalGrossWeight',)
            ->where('transaction_id', $request)
            ->groupBy('client_id')
            ->get();


        $coutries = DB::table('transaction_dts')
            ->leftjoin('countries', 'countries.country_id', 'transaction_dts.transactiondt_countryOfOrigin')
            ->select('countries.*', 'transaction_dts.transactiondt_countryOfOrigin')
            ->where('transaction_id', $request)
            ->groupBy('transactiondt_countryOfOrigin')
            ->get();
        $countryNamesString = 'AS Per BOE';
        if (count($coutries) <= 3) {
            $countryNames = $coutries->pluck('country_name')->toArray();
            $countryNamesString = implode(' ', $countryNames);
        }


        $finaltotalWeight = 0;
        $finaltotalPrice = 0;
        $finaltotalPkg = 0;
        $finaltotalGrossWeight = 0;

        foreach ($dt as $total) {
            $finaltotalWeight = $finaltotalWeight + $total->totalWeight;
            $finaltotalGrossWeight = $finaltotalGrossWeight + $total->totalGrossWeight;

            $finaltotalPrice = $finaltotalPrice + $total->totalPrice;
        }



        $dtHs = DB::table('transaction_dts')
            ->join('clients', 'clients.client_id', 'transaction_dts.client_id')
            ->select('transaction_dts.*', 'clients.client_firstName')
            ->where('transaction_id', $request)
            ->get();

        $hscodeString = 'AS Per BOE';
        $hscode = collect($dtHs)
            ->groupBy('hscode',)
            ->map(function ($group,) {
                $hscode = $group->pluck('hscode')->unique()->first();
                return [
                    'hscode' => $hscode,
                ];
            })
            ->values();
        $groupedhscode = $hscode->pluck('hscode')->toArray();
        if (count($groupedhscode) <= 3) {
            $hscodeString = implode(' ', $groupedhscode);
        }
        $data->dt = $dt;
        //   return $data;
        $Obj = array();
        $Obj['finaltotalWeight'] = $finaltotalWeight;
        $Obj['finaltotalPrice'] = $finaltotalPrice;
        $Obj['finaltotalPkg'] = $finaltotalPkg;

        $Obj['company_id'] = $company->company_id;
        $Obj['company_prefix'] = $company->company_prefix;
        $Obj['company_logo'] = $company->company_logo;
        $Obj['currency_code'] = $company->currency_code;

        $Obj['data'] = $data;
        $Obj['clientName'] = $clientName;
        $Obj['hscodeString'] = $hscodeString;

        $Obj['forwarderName'] = $forwarderName;
        $Obj['countryNamesString'] = $countryNamesString;



        $Obj['moduleKeys'] = $moduleKeys;
        $Obj['language'] = $language;
        $Obj['company'] = DB::table('companies')->first();
        $withStamp = isset($requestData->withStamp) ? $requestData->withStamp : false;
        $Obj['withStamp'] = $withStamp;
        $commonServices = new CommonServices();
        $decimals = $commonServices->getDecimal();
        $Obj['decimals'] = $decimals;
        $Obj['finaltotalGrossWeight'] = $finaltotalGrossWeight;

        $pdf = PDF::loadView(
            'manifestReport',
            $Obj,
            [],
            [
                'title' => 'Certificate',
                'format' => config('app.PDFFORMAT'),
                'orientation' => 'L'
            ]
        );


        return $pdf->stream('Manifest Report.pdf');
    }
}
