<?php

namespace App\Http\Controllers\BackOffice\Reports;


use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\client;
use App\Models\companies;
use App\Models\Localization;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use JWTAuth;
use PDF;

class ClientStorageReportsController extends ApiController
{
    public function fetchClientStorageReport(Request $request)
    {
        $clientId = $request->clientId;
        $transactionToDate = $request->transactionToDate;
        $transactionFromDate = $request->transactionFromDate;


        $results = $this->fetchClientStorageReportFunction($clientId, $transactionToDate, $transactionFromDate);

        if ($results['code'] == 200) {
            return ApiController::successResponse($results, 200);
        }

        return ApiController::errorResponse($results['message'], 400);
    }

    public function fetchClientStorageReportFunction($clientId, $transactionToDate, $transactionFromDate)
    {
        $utilitiesController = new UtilitiesController();
        $fromContractDate = client::where('client_id', $clientId)->first()->client_from_contract;
        $dateToTimeStamp = $utilitiesController->convertTodayToTimetsamp($transactionToDate . "23:59:59");
        $dateFromTimeStamp = $utilitiesController->convertTodayToTimetsamp($transactionFromDate . "00:00:00");
        $fromContractDateStamp = $utilitiesController->convertTodayToTimetsamp($fromContractDate . "00:00:00");

        if ($dateFromTimeStamp < $fromContractDateStamp || $fromContractDate==='0000-00-00') {
            if($fromContractDate==='0000-00-00')  return [
                'code' => 400,
                'message' => "client's contract date Invalid"
            ]; 
            $rsultDate = Carbon::parse($fromContractDate)->format('Y-m-d');
            return [
                'code' => 400,
                'message' => "Date must be after the client's contract date.(" . $rsultDate . ")"
            ];
        }
     

        $totalValue = 0;
        $dailyValue = 0;
        $totalPayment = 0;
        $cbmBalance = 0;

        $timeZoneOffset = $utilitiesController->getTimeZone();



        $cbmResultsOld = DB::table('transactions')
            ->leftJoin('transaction_dts', 'transaction_dts.transaction_id', 'transactions.transaction_id')
            ->leftJoin('clients', 'clients.client_id', 'transaction_dts.client_id')
            ->leftJoin('items', 'items.item_id', 'transaction_dts.item_id')
            ->select('*', 'transaction_date', 'items.item_cbm')
            ->selectRaw(DB::raw("FROM_UNIXTIME(transaction_date+ " . $timeZoneOffset . ", '%Y-%m-%d') AS transaction_formatdate"))
            ->where(
                'transaction_date',
                '<',
                $fromContractDateStamp
            )
            ->when($clientId != 'all', function ($query) use ($clientId) {
                return $query->where('clients.client_id', $clientId);
            })
            ->selectRaw("SUM(
            CASE WHEN (transaction_type = 'GOODS_IN' )
            THEN  (ceil((item_quantity/transaction_dts.item_qtyPerPack)) * item_cbm)
            ELSE (
                CASE WHEN (transaction_type = 'DO' )
                THEN  (-(floor((item_quantity/transaction_dts.item_qtyPerPack)) * item_cbm))
                ELSE (0) END
                ) END
            )
            AS cbm_no
        ")
            ->selectRaw("SUM(
            CASE WHEN (transaction_type = 'GOODS_IN' )
            THEN  (ceil((item_quantity/transaction_dts.item_qtyPerPack)) * item_cbm * client_cost)
            ELSE (
                CASE WHEN (transaction_type = 'DO' )
                THEN  (-(floor((item_quantity/transaction_dts.item_qtyPerPack)) * item_cbm * client_cost))
                ELSE (0) END
                ) END
            )
            AS dailyValue
        ")
            ->first();


        $beforeContractCbm = $cbmResultsOld->cbm_no;
        $beforeContractDailyValue = $cbmResultsOld->dailyValue;
        $previous = $this->fetchClientStorageReportData(
            $clientId,
            $dateFromTimeStamp - 86400,
            $fromContractDateStamp,
            $totalValue,
            $dailyValue + $beforeContractDailyValue,
            $totalPayment,
            $cbmBalance,
        );

        $totalValue = $previous['totalValue'];
        $dailyValue = $previous['dailyValue'];
        $totalPayment = $previous['totalPayment'];
        $cbmBalance = $previous['cbmBalance'] + $beforeContractCbm;
        $results = $this->fetchClientStorageReportData(
            $clientId,
            $dateToTimeStamp,
            $dateFromTimeStamp,
            $totalValue,
            $dailyValue,
            $totalPayment,
            $cbmBalance,

        );

        $results['cost'] = number_format($previous['cost'], 2);
        $results['cbmBalance'] = number_format($previous['cbmBalance'] + $beforeContractCbm, 2);
        $results['code'] = 200;

        return $results;
    }






    public function fetchClientStorageReportData(
        $clientId,
        $dateToTimeStamp,
        $dateFromTimeStamp,
        $totalValue,
        $dailyValue,
        $totalPayment,
        $cbmBalance
    ) {

        $numberFormatDigit = 2;
        // Generate a list of all days within the date range
        $allDays = [];
        $currentDate = $dateFromTimeStamp;
        while ($currentDate <= $dateToTimeStamp) {
            $allDays[] = date('Y-m-d', $currentDate);
            $currentDate += 86400; // 86400 seconds in a day
        }
        $utilitiesController = new UtilitiesController();
        $timeZoneOffset = $utilitiesController->getTimeZone();

        $cbmResults = DB::table('transactions')
            ->leftJoin('transaction_dts', 'transaction_dts.transaction_id', 'transactions.transaction_id')
            ->leftJoin('clients', 'clients.client_id', 'transaction_dts.client_id')
            ->leftJoin('items', 'items.item_id', 'transaction_dts.item_id')
            ->select('*', 'transaction_date', 'items.item_cbm')
            ->selectRaw(DB::raw("FROM_UNIXTIME(transaction_date+ " . $timeZoneOffset . ", '%Y-%m-%d') AS transaction_formatdate"))
            ->whereBetween(DB::raw('DATE(FROM_UNIXTIME(transaction_date+ ' . $timeZoneOffset . '))'), [
                date('Y-m-d', $dateFromTimeStamp),
                date('Y-m-d', $dateToTimeStamp)
            ])
            ->when($clientId != 'all', function ($query) use ($clientId) {
                return $query->where('clients.client_id', $clientId);
            })
            ->groupBy('transaction_formatdate',)
            ->selectRaw("SUM(
                CASE WHEN (transaction_type = 'GOODS_IN' )
                THEN  (ceil(item_quantity/transaction_dts.item_qtyPerPack) * item_cbm)
                ELSE 0
                END
            ) AS cbm_no_In")
            ->selectRaw("SUM(
                CASE WHEN (transaction_type = 'DO' )
                THEN  (floor(item_quantity/transaction_dts.item_qtyPerPack) * item_cbm)
                ELSE 0
                END
            ) AS cbm_no_Out")
            ->selectRaw("SUM(
                CASE WHEN (transaction_type = 'GOODS_IN' )
                THEN  (ceil(item_quantity/transaction_dts.item_qtyPerPack) * item_cbm)
                ELSE (
                    CASE WHEN (transaction_type = 'DO' )
                    THEN  (-(floor(item_quantity/transaction_dts.item_qtyPerPack) * item_cbm))
                    ELSE (0) END
                    ) END
                )
                AS cbm_no
            ")
            ->selectRaw("SUM(
                CASE WHEN (transaction_type = 'GOODS_IN' )
                THEN  (ceil(item_quantity/transaction_dts.item_qtyPerPack) * item_cbm * client_cost)
                ELSE (
                    CASE WHEN (transaction_type = 'DO' )
                    THEN  (-(floor(item_quantity/transaction_dts.item_qtyPerPack) * item_cbm * client_cost))
                    ELSE (0) END
                    ) END
                )
                AS dailyValue
            ")
            ->selectRaw("SUM(
                CASE WHEN (transaction_type = 'GOODS_IN' )
                THEN  (ceil(item_quantity/transaction_dts.item_qtyPerPack) * item_cbm * client_cost)
                ELSE (
                    CASE WHEN (transaction_type = 'DO' )
                    THEN  (-(floor(item_quantity/transaction_dts.item_qtyPerPack) * item_cbm * client_cost))
                    ELSE (0) END
                    ) END
                )
                AS totalValue
            ")

            ->get();
        $result = [];
        $totalCost = 0;
        $client = "-";


        foreach ($allDays as $day) {
            $found = false;
            $payment = 0;

            $payment = DB::table('client_storage_rent')
                ->where('related_client_id', $clientId)
                ->where(
                    DB::raw('DATE(FROM_UNIXTIME(date_from))'),
                    $day,
                )
                ->groupBy('related_client_id', DB::raw('DATE(FROM_UNIXTIME(date_from))'))
                ->sum('cost');
            $totalPayment = $totalPayment + $payment;



            foreach ($cbmResults as $cbm) {

                //  dailyValue
                if ($cbm->transaction_formatdate == $day) {
                    $cbm->payment =  number_format((float)$payment, $numberFormatDigit);
                    $cbm->dailyValue = $cbm->dailyValue + $dailyValue;
                    $dailyValue = $cbm->dailyValue;
                    $cbm->totalValue = $cbm->dailyValue + $totalValue;
                    $totalValue = $cbm->totalValue;
                    $cbm->cbm_no = $cbm->cbm_no + $cbmBalance;
                    $totalCost = $cbm->totalValue - $totalPayment;

                    $cbm->totalCost = $totalCost;
                    $cbm->totalCost = number_format((float)$cbm->totalCost, $numberFormatDigit);
                    $result[] = $cbm;
                    $found = true;
                    $cbmBalance = $cbm->cbm_no;
                    $client = $cbm->client_firstname;


                    $cbm->dailyValue = number_format((float)$cbm->dailyValue, $numberFormatDigit);
                    $cbm->totalValue = number_format((float)$cbm->totalValue, $numberFormatDigit);
                    $cbm->cbm_no = number_format((float)$cbm->cbm_no, 6);
                    $cbm->cbm_no_In = number_format((float)$cbm->cbm_no_In, 6);
                    $cbm->cbm_no_Out = number_format((float)$cbm->cbm_no_Out, 6);
                    break;
                }
            }
            // If no record was found for the day, add an empty record
            if (!$found) {
                $totalValue = $totalValue + $dailyValue;
                $totalCost = $totalValue - $totalPayment;
                $result[] = (object)[
                    'transaction_formatdate' => $day,
                    'totalCost' => number_format((float)$totalCost, $numberFormatDigit),
                    'cbm_no' =>  number_format((float)$cbmBalance, 6),
                    'payment' =>  number_format((float)$payment, $numberFormatDigit),
                    'client_firstname' => $client,
                    'totalValue' => number_format((float)$totalValue, $numberFormatDigit),
                    'dailyValue' =>  number_format((float)$dailyValue, $numberFormatDigit),
                    'cbm_no_Out' => number_format((float)0, 6),
                    'cbm_no_In' => number_format((float)0, 6),
                ];
            }


            // isset($cbm->totalCost) ? number_format((float)$cbm->totalCost, $numberFormatDigit) : 0;
        }







        $results = array();
        $results['data'] = $result;
        $results['cost'] = $totalCost;
        $results['totalValue'] = $totalValue;
        $results['dailyValue'] = $dailyValue;
        $results['totalPayment'] = $totalPayment;
        $results['cbmBalance'] = $cbmBalance;



        return $results;
    }



    public function excelStorageReport(Request $request)
    {

        $dataResult= $this->inventoryReportData1($request);

        $dataTransaction = $dataResult->getdata();
        if ($dataTransaction->code == 204) {
            return '';
        }

        $data = array();
        //return ApiController::successResponse($dataTransaction->data,200);
        if ($dataResult->status() == 422) {
            return ApiController::successResponse("No data", 200);
        }
        if ($dataTransaction->data->clientGroup == 'byGroup') {
            $collection = collect($dataTransaction->data->data);

            $grouped = $collection->groupBy('transaction_clientId')->map(function ($transactions, $clientId) {
                $clientName = $transactions->pluck('client_firstName')->unique()->implode(', ');
                return [
                    'clientId' => $clientId,
                    'clientName' => $clientName,
                    'items' => $transactions,
                ];
            })->values();

            $dataTransaction->data->data = $grouped;
        }
        return ApiController::successResponse($dataTransaction->data, 200);
    }



    public function printStorageReport(Request $request)
    {
        $UtilitiesController = new UtilitiesController();

        $moduleKeys = Localization::moduleKeys; // Assuming this is an array of keys
        $requestData = $UtilitiesController->decipherRequest($request->transactionId);
        $requestData = json_decode($requestData);

        $transactionToDate = $requestData->info->transactionToDate;
        $transactionFromDate = $requestData->info->transactionFromDate;
        $clientId = $requestData->info->clientId;
        $language = $requestData->info->language;
        $results = $this->fetchClientStorageReportFunction($clientId, $transactionToDate, $transactionFromDate);
        if ($results['code'] != 200) {
            return ApiController::errorResponse($results['message'], 400);
        }

        $client = client::where('client_id', $clientId)
            ->leftjoin('currency', 'currency.currency_id', '=', 'clients.client_currency')
            ->first();
        $clientName = "";
        $currency = "";
        if ($client) {
            $clientName = $client->client_firstname;
            $currency = $client->currency_code;
        }
        $Obj['moduleKeys'] = $moduleKeys;
        $Obj['language'] = $language;
        $Obj['data'] = $results;
        $Obj['company'] = DB::table('companies')->first();
        $Obj['clientName'] = $clientName;
        $Obj['transactionToDate'] = $transactionToDate;
        $Obj['transactionFromDate'] = $transactionFromDate;

        $Obj['currency'] = $currency;


        $Obj['prevcost'] = $results['cost'];
        $Obj['prevBalance'] = $results['cbmBalance'];


        // return $Obj['data'];
        $pdf = PDF::loadView(
            'storagePdf',
            $Obj,
            [],
            [
                'title' => 'Certificate',
                'format' => 'A4',
                'orientation' => 'P'
            ]
        );


        return $pdf->stream('Storage Report.pdf');
    }
}
