<?php

namespace App\Http\Controllers\BackOffice\Items;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\Localization;
use App\Models\transactionDt;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use JWTAuth;
use PDF;
use Illuminate\Support\Facades\Log;

class ItemsStatementController extends ApiController
{
    public function getDataDropDownStatment(Request $request)
    {
        //$company_id = JWTAuth::user()->company_id;
        $UtilitiesController = new UtilitiesController();
        $filterValue = $request->filterValue;
        $dateFromTimeStamp = $UtilitiesController->convertTodayToTimetsamp($request->transactionFromDate . "00:00:00");
        $dateToTimeStamp = $UtilitiesController->convertTodayToTimetsamp($request->transactionToDate . "23:59:59");
        $utilities['billOfEntry'] = DB::table('transactions')
            ->where([
                ['transactions.transaction_type', '=', 'GOODS_IN']
            ])
            //->wherebetween('transaction_date',[$dateFromTimeStamp,$dateToTimeStamp])
            ->when($filterValue, function ($query) use ($request, $filterValue) {
                return $query->Where('transaction_billOfEntry', 'like', '%' . $filterValue . '%');
            })
            ->when(!$filterValue, function ($query) use ($dateFromTimeStamp, $dateToTimeStamp) {
                return $query->wherebetween('transaction_date', [$dateFromTimeStamp, $dateToTimeStamp]);
            })
            ->select(
                'transaction_billOfEntry',
                'transaction_clientId',

                DB::raw("
        FROM_UNIXTIME(transaction_date,'%d-%m-%Y') as transaction_date")
            )
            ->get();


        $utilities['boe'] = DB::table('transactions')
            ->where([
                ['transactions.transaction_type', '=', 'GOODS_IN']
            ])
            ->when($filterValue, function ($query) use ($request, $filterValue) {
                return $query->Where('transaction_BOE', 'like', '%' . $filterValue . '%');
            })
            ->when(!$filterValue, function ($query) use ($dateFromTimeStamp, $dateToTimeStamp) {
                return $query->wherebetween('transaction_date', [$dateFromTimeStamp, $dateToTimeStamp]);
            })
            ->select(
                'transaction_BOE',
                'transaction_clientId',

                DB::raw("
        FROM_UNIXTIME(transaction_date,'%d-%m-%Y') as transaction_date")
            )
            ->get();


        $utilities['clietnItems'] = DB::table('client_items')
            ->select('client_items.*')
            ->groupBy('item_id')
            ->orderby('item_code')
            ->get();


        return ApiController::successResponse($utilities, 200);
    }

    public function getDataItemStatment(Request $request)
    {
        $company_id = JWTAuth::user()->company_id;
        $UtilitiesController = new UtilitiesController();
        $transactionFromDate = $UtilitiesController->convertTodayToTimetsamp($request->transactionFromDate . "" . "00:00:00");
        $transactionToDate = $UtilitiesController->convertTodayToTimetsamp($request->transactionToDate . "" . "23:59:59");
        $clientId = $request->clientId;
        $customerId = $request->customerId;
        $itemId = $request->item;
        $billOfEntry = $request->transactionBillOfEntry;
        $boe = $request->transactionBOE;

        $navigationTypeEntry = 'GOODS_IN';
        $navigationTypeOUT = 'DO';
        $combinedArray = array();
        if ($request->navigationType == 'rma') {
            $navigationTypeEntry = 'RMA_IN';
            $navigationTypeOUT = 'RMA_OUT';
        }
        if ($itemId != "all") {
            $itemStatements = $this->getDataItemStatmentFunction(
                $transactionFromDate,
                $transactionToDate,
                $clientId,
                $itemId,
                $billOfEntry,
                $navigationTypeEntry,
                $navigationTypeOUT,
                $boe,
                $customerId
            );
            $combinedArray = array_merge($combinedArray, $itemStatements->toarray());
        } else {
            if (!$billOfEntry) {
                $moduleKeys = Localization::moduleKeys; // Assuming this is an array of keys
                $language =$request->header('language');
                return ApiController::errorResponse($moduleKeys['decRequiredForAllItems'][$language], 422);

            }

            $items = transactionDt::where([
                ['transactiondt_billOfEntry', $billOfEntry]
            ])
                ->groupBy('item_id')
                ->get();


            foreach ($items as $itemsData) {
                $itemStatements = $this->getDataItemStatmentFunction(
                    $transactionFromDate,
                    $transactionToDate,
                    $clientId,
                    $itemsData->item_id,
                    $billOfEntry,
                    $navigationTypeEntry,
                    $navigationTypeOUT,
                    $boe,
                    $customerId
                );

                $combinedArray = array_merge($combinedArray, $itemStatements->toarray());
            }
        }


        $collection = collect($combinedArray);
        $groupedData = $collection->groupBy('item_code')->map(function ($transactions, $clientId) {
            $item_code = $transactions->pluck('item_code', 'transactiondt_id')->unique()->first();
            $transactiondt_billOfEntry = $transactions->pluck('transactiondt_billOfEntry')->unique()->first();
            $client_firstname = $transactions->pluck('client_firstname')->unique()->first();
            $prevQty = $transactions->pluck('prevQty')->unique()->first();

            return [
                'transactions' => $transactions,
                'item_code' => $item_code,
                'transactiondt_billOfEntry' => $transactiondt_billOfEntry,
                'client_firstname' => $client_firstname,
                'prevQty' => $prevQty,


            ];
        })->values();

        return ApiController::successResponse($groupedData, 200);
    }

    public function getDataItemStatmentFunction(
        $transactionFromDate,
        $transactionToDate,
        $clientId,
        $itemId,
        $billOfEntry,
        $navigationTypeEntry,
        $navigationTypeOUT,
        $boe,
        $customerId
    )
    {


        $itemStatementPrevGoodsIn = $this->getPrevQtyByItem($transactionFromDate, $itemId, $clientId, $billOfEntry, $navigationTypeEntry, $customerId);
        $itemStatementPrevDO = $this->getPrevQtyByItem($transactionFromDate, $itemId, $clientId, $billOfEntry, $navigationTypeOUT, $customerId);
        $itemStatementPrev = $itemStatementPrevGoodsIn - $itemStatementPrevDO;

       
        $itemStatements = DB::table('transactions')
            ->join('transaction_dts', 'transaction_dts.transaction_id', '=', 'transactions.transaction_id')
            ->leftjoin('currency', 'currency.currency_id', 'transactions.transaction_currencyId')
            ->where(function ($query) use ($navigationTypeEntry, $navigationTypeOUT, $itemId, $transactionFromDate, $transactionToDate) {
                return $query->where(
                    [
                        ['transactions.transaction_type', $navigationTypeEntry],
                        ['transaction_dts.item_id', '=', $itemId],
                        ['transactions.transaction_date', '>', $transactionFromDate],
                        ['transactions.transaction_date', '<', $transactionToDate],
                    ]
                )->orWhere([
                    ['transactions.transaction_type', $navigationTypeOUT],
                    ['transaction_dts.item_id', '=', $itemId],
                    ['transactions.transaction_date', '>', $transactionFromDate],
                    ['transactions.transaction_date', '<', $transactionToDate],
                ]);
            })
            ->join('items', 'items.item_id', '=', 'transaction_dts.item_id')
            ->join('clients', 'clients.client_id', '=', 'transaction_dts.client_id')
            ->leftjoin('suppliers', 'suppliers.supplier_id', '=', 'transactions.transaction_supplierId')
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactions.clientCustomer_id')
            ->leftjoin('countries', 'countries.country_id', '=', 'transaction_dts.transactiondt_countryOfOrigin')
            ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactions.forwarder_id')
            ->select('*', 'transaction_dts.item_weight as item_weight')
            ->addselect(DB::raw('concat(transactiondt_price, " ",currency_code) as currencyPrice'))
            ->orderBy('transactions.transaction_date')          ;


        if ($clientId && $clientId != "all") {
            $itemStatements = $itemStatements->where([
                ['transaction_dts.client_id', '=', $clientId]
            ]);
        }else{
            
        }
        if ($customerId && $customerId != "all") {
            $itemStatements = $itemStatements->where([
                ['transactions.clientCustomer_id', '=', $customerId]
            ]);
        }
        if ($billOfEntry) {
            $itemStatements = $itemStatements->where([
                ['transaction_dts.transactiondt_billOfEntry', '=', $billOfEntry]
            ]);
        }
        if ($boe) {
            $itemStatements = $itemStatements->where([
                ['transaction_dts.transactiondt_BOE', '=', $boe]
            ]);
        }

        $itemStatements = $itemStatements->get();


        foreach ($itemStatements as $itemStatement) {
            if ($itemStatement->transaction_date) {
                $itemStatement->transaction_date = date('d-m-Y', $itemStatement->transaction_date);
            }

            if ($itemStatement->transaction_type == $navigationTypeEntry) {
                $itemStatement->prevQty = $itemStatementPrev;
                $itemStatement->qtyIn = $itemStatement->item_quantity;
                $itemStatement->qtyOut = 0;
                $itemStatementPrev = $itemStatementPrev + $itemStatement->item_quantity;
                $itemStatement->qtyExisting = $itemStatementPrev;

                if ($itemStatement->transaction_type == 'RMA_IN') {
                    $itemStatement->customer = $itemStatement->customer_name;
                    $itemStatement->suppliers = "-";
                } else {
                    $itemStatement->customer = "-";
                    $itemStatement->suppliers = $itemStatement->supplier_name;
                }

                $itemStatement->forwarder = "-";
            }
            if ($itemStatement->transaction_type == $navigationTypeOUT) {
                $itemStatement->prevQty = $itemStatementPrev;
                $itemStatement->qtyIn = 0;
                $itemStatement->qtyOut = $itemStatement->item_quantity;
                $itemStatementPrev = $itemStatementPrev - $itemStatement->item_quantity;
                $itemStatement->qtyExisting = $itemStatementPrev;
                $itemStatement->customer = $itemStatement->customer_name;
                $itemStatement->suppliers = "-";

                $itemStatement->forwarder = $itemStatement->clientforwarder_name;
            }
        }

        return $itemStatements;
    }

    public function getPrevQtyByItem($transactionFromDate, $itemId, $clientId, $billOfEntry, $type, $customerId)
    {
        $itemStatementPrev = DB::table('transactions')
            ->join('transaction_dts', 'transaction_dts.transaction_id', '=', 'transactions.transaction_id')
            ->where([

                ['transactions.transaction_date', '<', $transactionFromDate],
                ['transaction_dts.item_id', '=', $itemId],
                ['transactions.transaction_type', '=', $type],

            ]);
        if ($clientId && $clientId != "all") {
            $itemStatementPrev = $itemStatementPrev->where([
                ['transaction_dts.client_id', '=', $clientId]
            ]);
        }
        if ($customerId && $customerId != "all") {
            $itemStatementPrev = $itemStatementPrev->where([
                ['transactions.clientCustomer_id', '=', $customerId]
            ]);
        }
        if ($billOfEntry) {
            $itemStatementPrev = $itemStatementPrev->where([
                ['transaction_dts.transactiondt_billOfEntry', '=', $billOfEntry]
            ]);
        }
        $itemStatementPrev = $itemStatementPrev->selectRaw(' SUM(item_quantity)  as prevQty')
            ->first();
        return $itemStatementPrev->prevQty;
    }

    public function printStatmentOfItems(Request $request)
    {
        $UtilitiesController = new UtilitiesController();
        $requestData = $UtilitiesController->decipherRequest($request->transactionDataId);

        if (!$requestData) {
            return 'unreachable url found';
        }
        $requestData = json_decode($requestData);
        $requestData = $requestData->info;
        $transactionFromDate = $requestData->transactionFromDate;
        $transactionToDate = $requestData->transactionToDate;
        $clientId = $requestData->clientId;
        $customerId = $requestData->customerId;
        $language = $requestData->language;

        $itemId = $requestData->item;
        $billOfEntry = $requestData->transactionBillOfEntry;
        $navigationType = $requestData->navigationType;
        $currency = $requestData->currency;
        $weight = $requestData->weight;
        $totalWeight = $requestData->totalWeight;
        $currencyBase = $requestData->currencyBase;
        $transactionFromDate = $UtilitiesController->convertTodayToTimetsamp($transactionFromDate . "" . "00:00:00");
        $transactionToDate = $UtilitiesController->convertTodayToTimetsamp($transactionToDate . "" . "23:59:59");
        $forwarder = $requestData->forwarder;
        $customer = $requestData->customerId;
        $supplier = $requestData->supplier;


        $navigationTypeEntry = 'GOODS_IN';
        $navigationTypeOUT = 'DO';
        if ($navigationType == 'rma') {
            $navigationTypeEntry = 'RMA_IN';
            $navigationTypeOUT = 'RMA_OUT';
        }
        $itemStatements = null;
        $combinedArray = array();
        if ($itemId != "all") {
            $itemStatements = $this->getDataItemStatmentFunction(
                $transactionFromDate,
                $transactionToDate,
                $clientId,
                $itemId,
                $billOfEntry,
                $navigationTypeEntry,
                $navigationTypeOUT,
                '',
                $customerId
            );
        } else {

            // $items = clientItem::when($clientId != 'all', function ($query) use ($request, $clientId) {
            //     return $query->Where([
            //         ['item_related_client_id', $clientId]
            //     ]);
            //     return $query->orderby('item_id');
            // })
            //     ->when($clientId == 'all', function ($query) use ($request, $clientId) {
            //         return $query->groupby('item_id');
            //         return $query->orderby('item_id');
            //     })
            //     ->get();
            $items = transactionDt::where([
                ['transactiondt_billOfEntry', $billOfEntry]
            ])
                ->groupBy('item_id')
                ->get();

            foreach ($items as $itemsData) {
                $data = $this->getDataItemStatmentFunction(
                    $transactionFromDate,
                    $transactionToDate,
                    $clientId,
                    $itemsData->item_id,
                    $billOfEntry,
                    $navigationTypeEntry,
                    $navigationTypeOUT,
                    '',
                    $customerId
                );

                $combinedArray = array_merge($combinedArray, $data->toarray());
            }
            $itemStatements = $combinedArray;
        }


        $collection = collect($itemStatements);

        $groupedData = $collection->groupBy('item_code')->map(function ($transactions, $clientId) {
            $item_code = $transactions->pluck('item_code', 'transactiondt_id')->unique()->first();
            $transactiondt_billOfEntry = $transactions->pluck('transactiondt_billOfEntry')->unique()->first();
            $client_firstname = $transactions->pluck('client_firstname')->unique()->first();
            $customer_name = $transactions->pluck('customer_name')->unique()->first();

            $prevQty = $transactions->pluck('prevQty')->unique()->first();

            return [
                'transactions' => $transactions,
                'item_code' => $item_code,
                'transactiondt_billOfEntry' => $transactiondt_billOfEntry,
                'client_firstname' => $client_firstname,
                'prevQty' => $prevQty,
                'customer_name' => $customer_name


            ];
        })->values();


        //   return $groupedData;


        $moduleKeys = Localization::moduleKeys; // Assuming this is an array of keys

        $company = DB::table('companies')->first();
        $currencyCode = DB::table('companies')
            ->leftjoin('currency', 'currency.currency_id', '=', 'companies.currency')
            ->where('company_id', $company->company_id)
            ->first();
        $Obj['company_id'] = $company->company_id;
        $Obj['company_logo'] = $company->company_logo;
        $Obj['currencyCode'] = $currencyCode->currency_code;
        $Obj['data'] = $groupedData;

        $Obj['transactionFromDate'] = date('d-m-Y', $transactionFromDate);
        $Obj['transactionToDate'] = date('d-m-Y', $transactionToDate);
        $Obj['clientId'] = $clientId;
        $Obj['itemId']=$itemId;
        $Obj['billOfEntry'] = $billOfEntry;
        $Obj['currency'] = $currency;
        $Obj['currencyBase'] = $currencyBase;
        $Obj['weight'] = $weight;
        $Obj['totalWeight'] = $totalWeight;
        $Obj['forwarder'] = $forwarder;
        $Obj['customer'] = $customer;
        $Obj['supplier'] = $supplier;
        $Obj['language'] = $requestData->language;
        $Obj['moduleKeys'] = $moduleKeys;


        $Obj['company'] = DB::table('companies')->first();
        $Obj['isShipment'] = $Obj['company']->company_onlyShipment;
        $pdfPath = "statementOfItems";
        if ($Obj['isShipment'] == 1) {
            $pdfPath = "/shipment/statementOfItems";
        }
        $pdf = PDF::loadView(
            $pdfPath,
            $Obj,
            [],
            [
                'title' => 'Certificate',
                'format' => config('app.PDFFORMAT'),
                'orientation' => 'L'
            ]
        );


        return $pdf->stream('statementOfItem.pdf');
    }
}
