<?php

namespace App\Http\Controllers\BackOffice\Internal;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\History\HistoryController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\clientItem;
use App\Models\clientSupplier;
use App\Models\companies;
use App\Models\items;
use App\Models\Localization;
use App\Models\location;
use App\Models\sequence;
use App\Models\transactionDt;
use App\Models\transactionDtsn;
use App\Models\transactionDtSnTmp;
use App\Models\transactiondttmp;
use App\Models\TransactionPalets;
use App\Models\transactions;
use App\Models\transactiontmp;
use App\Models\TransactiontmpPalets;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use JWTAuth;
use File;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\BackOffice\Common\CommonServices;


class InternalServices extends ApiController
{
    function fetchTransactionsService($payload)
    {

        $transactionType = $payload['transactionType'];
        $dateFrom = $payload['dateFrom'];
        $dateTo = $payload['dateTo'];
        $skip = $payload['skip'];
        $take = $payload['take'];
        $searchKey = $payload['searchKey'];
        $commonServices = new CommonServices;


        $transactions = transactions::join('clients', 'clients.client_id', '=', 'transactions.transaction_clientId')
            ->leftjoin('transaction_dts', 'transaction_dts.transaction_id', 'transactions.transaction_id')
            ->leftjoin('clients as toClient', 'toClient.client_id', '=', 'transactions.transferTo_clientId')
            ->leftjoin('clients as toClientdt', 'toClientdt.client_id', '=', 'transaction_dts.client_id')
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactions.clientCustomer_id')
            ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactions.forwarder_id')
            ->leftjoin('currency', 'currency.currency_id', '=', 'transactions.transaction_currencyId')
            ->select(
                'transactions.transaction_reference',
                'transactions.transaction_date',
                'clients.client_firstname',
                'toClient.client_firstname as transferToClient',
                'transactions.transaction_id',
                'transaction_type',
                'transaction_currencyId',
                'currency_code',
                'transactions.transaction_remark',
                'internal_transfer',
                'transferTo_clientId',
            )
            ->selectRaw(DB::raw(" FROM_UNIXTIME(transaction_date, '%d-%m-%Y') AS transaction_formatdate"))
            ->where([
                ['transaction_type', transactions::transactionTypes["$transactionType"]['type']],
                ['internal_transfer', transactions::transactionTypes["$transactionType"]["internalTransfer"]]
            ])
            ->whereRaw('date(FROM_UNIXTIME(transaction_date)) BETWEEN ? AND ?', [$dateFrom, $dateTo])
            ->orderBy('transaction_reference', 'desc');
        $count = count($transactions->groupby('transaction_id')->get());
        if (isset($skip) && isset($take)) {
            $transactions->skip($skip)
                ->take($take);
        }
        if ($searchKey) {
            $transactions->Where(function ($query) use ($searchKey) {
                $query->Where([
                    ['transaction_reference', 'like', '%' . $searchKey . '%']
                ])

                    ->orWhere([
                        ['transaction_remark', 'like', '%' . $searchKey . '%']
                    ])
                    ->orWhere([
                        ['clients.client_firstname', 'like', '%' . $searchKey . '%']
                    ])
                    ->orWhere([
                        ['toClientdt.client_firstname', 'like', '%' . $searchKey . '%']
                    ]);
            });
        }
        $transactions = $transactions
            ->groupby('transaction_id')
            ->get();

        $transactions = $commonServices->getTransactionFilesExist(['INTERNAL_TRANSFER'], $transactions);

        // foreach ($transactions as $splitTrans) {
        //     $splitTrans->transaction_formatdate = date('Y-m-d', $splitTrans->transaction_date);

            
        // }
        if ($transactions) {
            return ApiController::successResponse($transactions, 200, $count);
        }
        return ApiController::successResponse('No result', 204);
    }
}
