<?php

namespace App\Http\Controllers\BackOffice\History;

use App\Http\Controllers\ApiController;
use App\Models\client;
use App\Models\clientCustomer;
use App\Models\clientForwarder;
use App\Models\country;
use App\Models\ItemGroup;
use App\Models\transactionDtSnTmp;
use App\Models\transactiondttmp;
use App\Models\transactions;
use App\Models\user;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use JWTAuth;

class HistoryController extends ApiController
{
    public function insertHistoryData($table, $data, $modifiedType)
    {
        $user = user::where([
            ['id', $data['user_modified']]
        ])->first();


        if (isset($data['group_id'])) {
            $group = ItemGroup::where([
                ['group_id', $data['group_id']]
            ])->first();
            $data['group_id'] = isset($group->group_name) ? $group->group_name : null;
        }
        if (isset($data['supplier_country'])) {
            $country = country::where([
                ['country_id', $data['supplier_country']]
            ])->first();
            $data['supplier_country'] = isset($country->country_name) ? $country->country_name : null;
        }
        $data['modification_type'] = $modifiedType;
        $data['date_modified'] = date('Y-m-d H:i:s');
        $data['user_modified'] = $user->user_name;


        DB::connection('mysql2')
            ->table($table)
            ->insert($data);

        return true;
    }


    public function insertTransactionHistoryData($table, $data, $modifiedType, $hitoryArray)
    {


        foreach ($hitoryArray as $getValue) {
            $replace = DB::table($getValue['table'])
                ->where($getValue['column'], $getValue['value'])
                ->select($getValue['selectedValue'])
                ->first();
            if ($replace) {
                $v = $getValue['selectedValue'];
                $data[$getValue['replaceColumn']] = $replace->$v;
            }
        }
        $data['modification_type'] = $modifiedType;
        $transactionIndex = DB::connection('mysql2')
            ->table($table)
            ->insertGetId($data);

        return $transactionIndex;
    }


    public function insertHistoryTransactionDtData($previousDtData, $insertDtFound, $date, $transactionIndex, $modificationUser)
    {


        foreach ($previousDtData as $preData) {

            $filter = in_array($preData->transactiondt_id, $insertDtFound);
            if (!$filter) {
                $deleteRecord = $preData->toArray();
                $deleteRecord['modification_type'] = 'Delete';
                $deleteRecord['date_modified'] = $date;
                $deleteRecord['transaction_index'] = $transactionIndex;

                $deletedRecord = DB::connection('mysql2')
                    ->table('transaction_dts')
                    ->where('transactiondt_id', $preData->transactiondt_id)
                    ->orderBy('index', 'desc')
                    ->first();

                $transactionDtArray = array(
                    'transactiondt_id' => $deletedRecord->transactiondt_id,
                    'transaction_id' => $deletedRecord->transaction_id,
                    'item_id' => $deletedRecord->item_id,
                    'client_id' => $deletedRecord->client_id,
                    'item_quantity' => $deletedRecord->item_quantity,
                    'supplier_id' => $deletedRecord->supplier_id,
                    'supplier_invoice_number' => $deletedRecord->supplier_invoice_number,
                    'transactiondt_locationid' => $deletedRecord->transactiondt_locationid,
                    'transactiondt_countryOfOrigin' => $deletedRecord->transactiondt_countryOfOrigin,
                    'transactiondt_price' => $deletedRecord->transactiondt_price,
                    'id_reference_dt' => $deletedRecord->id_reference_dt,
                    'transactiondt_billOfEntry' => $deletedRecord->transactiondt_billOfEntry,
                    'raw_in_grid' => $deletedRecord->raw_in_grid,
                    'item_weight' => $deletedRecord->item_weight,
                    'item_unit' => $deletedRecord->item_unit,
                    'item_qtyPerPack' => $deletedRecord->item_qtyPerPack,
                    'item_pack' => $deletedRecord->item_pack,
                    'group_id' => $deletedRecord->group_id,
                    'palet_no' => $deletedRecord->palet_no,
                    'transactiondt_nbOfCarton' => $deletedRecord->transactiondt_nbOfCarton,
                    'transactiondt_cellMerge' => $deletedRecord->transactiondt_cellMerge,
                    'client_id' => $deletedRecord->client_id,
                    'modification_type' => 'Delete',
                    'date_modified' => $date,
                    'transaction_index' => $transactionIndex,
                    'user_modified' => $modificationUser

                );

                DB::connection('mysql2')
                    ->table('transaction_dts')
                    ->insert($transactionDtArray);
            }
        }
        return true;
    }

    public function insertHistoryTransactionSnData($previousDtData, $insertSnFound, $date, $transactionIndex,)
    {


        foreach ($previousDtData as $preData) {

            $filter = in_array($preData->transactiondtsn_id, $insertSnFound);
            if (!$filter) {
                $deleteRecord = $preData->toArray();
                $deleteRecord['modification_type'] = 'Delete';
                $deleteRecord['date_modified'] = $date;
                $deleteRecord['transaction_index'] = $transactionIndex;
                DB::connection('mysql2')
                    ->table('transaction_dtsns')
                    ->insert($deleteRecord);
            }
        }
        return true;
    }


    public function insertHistoryData2($table, $data, $previousDtData, $modifiedType)
    {

        $data['modification_type'] = $modifiedType;
        $data['date_modified'] = date('Y-m-d H:i:s');


        // $checkData=DB::connection('mysql2')
        // ->table($table)
        // ->where('transactiondt_id', $data['transactiondt_id'])
        // ->latest('date_modified')->first();

        //  $resultCollection =$data->intersect($checkData->toarray());

        if ($previousDtData) {
            $data['modification_type'] = 'Update';
        }
        DB::connection('mysql2')
            ->table($table)
            ->insert($data);

        return true;
    }


    public function insertHistoryData3($table, $data, $previousDtData, $modifiedType, $insertDtFound)
    {

        $data['modification_type'] = $modifiedType;
        $data['date_modified'] = date('Y-m-d H:i:s');


        foreach ($previousDtData as $preData) {

            $filter = in_array($preData->transactiondt_id, $insertDtFound);
            if (!$filter) {
                $deleteRecord = $preData->toArray();
                $deleteRecord['modification_type'] = 'Delete';
                $deleteRecord['date_modified'] = $data['date_modified'];
                DB::connection('mysql2')
                    ->table($table)
                    ->insert($deleteRecord);
            }
        }
        // if($previousDtData){
        //   $data['modification_type']='Update';
        // }
        // DB::connection('mysql2')
        // ->table($table)
        // ->insert($data);

        return true;
    }


    public function fetchHistory(Request $request)
    {

        $dateFrom = $request->dateFrom . " 00:00:00";
        $dateTo = $request->dateTo . " 23:59:59";
        $historyType = $request->historyType;
        $userSelected = $request->userSelected;
        $skip = $request->skip;
        $take = $request->take;
        $search = $request->search;
        $filter = $request->filter;
        $referenceSelected = $request->referenceSelected;
        $obj = array();
        if ($userSelected != 'all') {
            $userSelected = user::where('id', $userSelected)->first()->user_name;
        }

        // return $this->fetchNonTransactionHistory($historyType,$dateFrom,$dateTo,$search,$userSelected,$skip,$take,$referenceSelected);
        if ($historyType == 'clients') {
            $clients = DB::connection('mysql2')->table('clients')
                ->select('clients.*', 'clients.user_modified as mofication_user', 'clients.client_id as user_name')
                ->wherebetween('clients.date_modified', [$dateFrom, $dateTo])
                ->when($referenceSelected != "", function ($query) use ($referenceSelected) {
                    return $query->where('client_id', $referenceSelected);
                })
                // ->when(!$referenceSelected || $referenceSelected=="", function ($query) use ($referenceSelected) {
                //    // return $query->groupby('client_id');
                // })
                ->when($filter != 'all', function ($query) use ($filter) {
                    return $query->where('modification_type', $filter);
                });
            if ($userSelected != 'all') {
                $clients->where('clients.user_modified', $userSelected);
            }

            $obj['count'] = count($clients->get());
            $clientsData = $clients
                ->skip($skip)
                ->take($take)
                ->orderBy('clients.date_modified', 'desc')
                ->get();

            $obj['data'] = $clientsData;


            return ApiController::successResponse($obj, 200);
        } else if ($historyType == 'suppliers') {
            $suppliers = DB::connection('mysql2')->table('suppliers')
                ->leftjoin('users as modificationData', 'modificationData.id', '=', 'suppliers.user_modified')
                ->select('suppliers.*', 'suppliers.user_modified as mofication_user',)
                ->wherebetween('suppliers.date_modified', [$dateFrom, $dateTo])
                ->when($referenceSelected, function ($query) use ($referenceSelected) {
                    return $query->where('supplier_name', $referenceSelected);
                })
                ->when(!$referenceSelected, function ($query) use ($referenceSelected) {
                    return $query->groupby('supplier_name');
                })
                ->when($filter != 'all', function ($query) use ($filter) {
                    return $query->where('modification_type', $filter);
                });
            if ($userSelected != 'all') {
                $suppliers->where('suppliers.user_modified', $userSelected);
            }
            $obj['count'] = count($suppliers->get());
            $suppliersData = $suppliers
                ->skip($skip)
                ->take($take)
                ->orderBy('suppliers.date_modified', 'desc')
                ->get();
            $obj['data'] = $suppliersData;
            return ApiController::successResponse($obj, 200);
        } else if ($historyType == 'items') {
            $itemsObject = array();
            $items = DB::connection('mysql2')->table('items')
                ->select('items.*', 'items.user_modified as mofication_user', 'items.group_id as group_name')
                ->wherebetween('items.date_modified', [$dateFrom, $dateTo])
                ->when($referenceSelected, function ($query) use ($referenceSelected) {
                    return $query->where('item_code', $referenceSelected);
                })
                ->when(!$referenceSelected, function ($query) use ($referenceSelected) {
                    return $query->groupby('item_code');
                })
                ->when($filter != 'all', function ($query) use ($filter) {
                    return $query->where('modification_type', $filter);
                });
            if ($userSelected != 'all') {
                $items->where('items.user_modified', $userSelected);
            }
            $itemsObject['count'] = count($items->get());
            $itemsData = $items
                ->skip($skip)
                ->take($take)
                ->orderBy('items.date_modified', 'desc')
                ->get();
            $itemsObject['data'] = $itemsData;
            return ApiController::successResponse($itemsObject, 200);
        } else if ($historyType == 'groups') {
            $items = DB::connection('mysql2')->table('item_groups')
                ->leftjoin('users as modificationData', 'modificationData.id', '=', 'item_groups.user_modified')
                ->select('item_groups.*', 'modificationData.user_name as mofication_user',)
                ->wherebetween('item_groups.date_modified', [$dateFrom, $dateTo])
                ->when($referenceSelected, function ($query) use ($referenceSelected) {
                    return $query->where('group_code', $referenceSelected);
                })
                ->when(!$referenceSelected, function ($query) use ($referenceSelected) {
                    return $query->groupby('group_code');
                })
                ->when($filter != 'all', function ($query) use ($filter) {
                    return $query->where('modification_type', $filter);
                });
            if ($userSelected != 'all') {
                $items->where('item_groups.user_modified', $userSelected);
            }
            $obj['count'] = count($items->get());
            $itemsData = $items
                ->skip($skip)
                ->take($take)
                ->orderBy('item_groups.date_modified', 'desc')
                ->get();
            $obj['data'] = $itemsData;
            return ApiController::successResponse($obj, 200);
        } else if ($historyType == 'forwarders') {
            $items = DB::connection('mysql2')->table('client_forwarders')
                ->leftjoin('users as modificationData', 'modificationData.id', '=', 'client_forwarders.user_modified')
                ->select('client_forwarders.*', 'modificationData.user_name as mofication_user',)
                ->wherebetween('client_forwarders.date_modified', [$dateFrom, $dateTo])
                ->orderBy('client_forwarders.date_modified', 'desc')
                ->when($referenceSelected, function ($query) use ($referenceSelected) {
                    return $query->where('clientforwarder_name', $referenceSelected);
                })
                ->when(!$referenceSelected, function ($query) use ($referenceSelected) {
                    return $query->groupby('clientforwarder_name');
                });


            if ($userSelected != 'all') {
                $items->where('client_forwarders.user_modified', $userSelected);
            }
            $obj['count'] = count($items->get());
            $itemsData = $items
                ->skip($skip)
                ->take($take)
                ->get();
            $obj['data'] = $itemsData;
            return ApiController::successResponse($obj, 200);
        } else if ($historyType == 'countries') {
            $items = DB::connection('mysql2')->table('countries')
                ->leftjoin('users as modificationData', 'modificationData.id', '=', 'countries.user_modified')
                ->select('countries.*', 'modificationData.user_name as mofication_user',)
                ->wherebetween('countries.date_modified', [$dateFrom, $dateTo])
                ->when($referenceSelected, function ($query) use ($referenceSelected) {
                    return $query->where('country_code', $referenceSelected);
                })
                ->when(!$referenceSelected, function ($query) use ($referenceSelected) {
                    return $query->groupby('country_code');
                });
            if ($userSelected != 'all') {
                $items->where('countries.user_modified', $userSelected);
            }
            $obj['count'] = count($items->get());
            $itemsData = $items
                ->skip($skip)
                ->take($take)
                ->orderBy('countries.date_modified', 'desc')
                ->get();
            $obj['data'] = $itemsData;
            return ApiController::successResponse($obj, 200);
        } else if ($historyType == 'locations') {
            $items = DB::connection('mysql2')->table('locations')
                ->leftjoin('users as modificationData', 'modificationData.id', '=', 'locations.user_modified')
                ->select('locations.*', 'modificationData.user_name as mofication_user',)
                ->wherebetween('locations.date_modified', [$dateFrom, $dateTo])
                ->when($referenceSelected, function ($query) use ($referenceSelected) {
                    return $query->where('location_name', $referenceSelected);
                })
                ->when(!$referenceSelected, function ($query) use ($referenceSelected) {
                    return $query->groupby('location_name');
                });
            if ($userSelected != 'all') {
                $items->where('locations.user_modified', $userSelected);
            }
            $obj['count'] = count($items->get());
            $itemsData = $items
                ->skip($skip)
                ->take($take)
                ->orderBy('locations.date_modified', 'desc')
                ->get();
            $obj['data'] = $itemsData;
            return ApiController::successResponse($obj, 200);
        } else if (transactions::transactionTypes["$historyType"]) {
            $client = $request->client;
            $items = DB::connection('mysql2')->table('transactions')
                ->leftjoin('users as modificationData', 'modificationData.id', '=', 'transactions.user_modified')
                // ->leftjoin('clients','clients.client_id','transactions.transaction_clientId')

                ->select('transactions.*', 'modificationData.user_name as mofication_user')
                ->selectRaw(DB::raw(" FROM_UNIXTIME(transaction_date, '%d-%m-%Y') AS transaction_formatdate"))
                ->where([
                    ['transaction_type', transactions::transactionTypes["$historyType"]["type"],],
                    ['transaction_reference', 'like', '%' . $search . '%'],
                    ['internal_transfer', transactions::transactionTypes["$historyType"]["internalTransfer"]]
                ])
                ->wherebetween('transactions.date_modified', [$dateFrom, $dateTo])
                ->when($referenceSelected, function ($query) use ($referenceSelected) {
                    return $query->where('transaction_reference', $referenceSelected);
                });

            // if($filter !='all'){
            //     $items->where('transactions.modification_type',$filter);
            // }

            if ($userSelected != 'all') {
                $items->where('transactions.user_modified', $userSelected);
            }
            if ($client != 'all') {
                $items->where('transactions.transaction_clientId', $client);
            }
            $obj['count'] = count($items->get());

            $itemsData = $items
                ->skip($skip)
                ->take($take)
                ->orderBy('transactions.date_modified', 'desc')
                ->get();
            $groupItemsData = $items
                ->skip($skip)
                ->take($take)
                ->whereRaw('transactions.date_modified IN (select MAX(transactions.date_modified)
                FROM transactions  GROUP BY transaction_reference)')
                ->groupBy('transaction_reference')
                //   ->orderBy('transactions.date_modified', 'desc')
                ->get();
            $obj['data'] = $itemsData;
            $obj['group_data'] = $groupItemsData;
            return ApiController::successResponse($obj, 200);
        }

        return ApiController::successResponse([], 200);
    }


    public function fetchHistoryTransactionDt(Request $request)
    {
        $dateFrom = $request->dateFrom . " 00:00:00";
        $dateTo = $request->dateTo . " 23:59:59";
        $dateModified = $request->date_modified;
        $index = $request->index;
        $previousIndex = $request->previousIndex;
        $modificationType = $request->modificationType;

        $historyType = $request->historyType;
        $userSelected = $request->userSelected;
        $skip = $request->skip;
        $take = $request->take;
        $obj = array();
        $transactionId = $request->transaction_id;
        $items = DB::connection('mysql2')->table('transaction_dts')
            ->leftjoin('users as modificationData', 'modificationData.id', '=', 'transaction_dts.user_modified')
            //->leftjoin('items','items.item_id','transaction_dts.item_id')
            //->leftjoin('countries','countries.country_id','transactiondt_countryOfOrigin')
            //->leftjoin('locations','locations.location_id','transactiondt_locationId')

            ->select('transaction_dts.*', 'transaction_dts.date_modified as date_modified', 'modificationData.user_name as mofication_user',)
            ->where([
                ['transaction_dts.transaction_id', $transactionId],
                ['transaction_dts.transaction_index', $index]
            ]);
        if ($modificationType != 'Delete') {
            $items->orwhere(
                [
                    ['transaction_dts.transaction_id', $transactionId],
                    ['transaction_dts.transaction_index', $previousIndex]
                ]
            );
        }

        $items->wherebetween('transaction_dts.date_modified', [$dateFrom, $dateTo])
            ->orderby('transactiondt_id');

        if ($userSelected != 'all') {
            $items->where('transaction_dts.user_modified', $userSelected);
        }
        $obj['count'] = count($items->get());
        $itemsData = $items
            // ->skip($skip)
            // ->take($take)
            ->orderBy('transaction_dts.date_modified', 'desc')
            ->get();
        $obj['data'] = $itemsData;
        return ApiController::successResponse($obj, 200);
    }

    public function fetchHistoryTransactionDtSerials(Request $request)
    {

        $dateFrom = $request->dateFrom . " 00:00:00";
        $dateTo = $request->dateTo . " 23:59:59";
        $dateModified = $request->date_modified;
        $index = $request->index;
        $previousIndex = $request->previousIndex;
        $modificationType = $request->modificationType;

        $historyType = $request->historyType;
        $userSelected = $request->userSelected;
        $skip = $request->skip;
        $take = $request->take;
        $obj = array();
        $transactionId = $request->transaction_id;
        $items = DB::connection('mysql2')->table('transaction_dtsns')
            ->leftjoin('users as modificationData', 'modificationData.id', '=', 'transaction_dtsns.user_modified')
            //->leftjoin('items','items.item_id','transaction_dtsns.item_id')
            //->leftjoin('countries','countries.country_id','transactiondt_countryOfOrigin')
            //->leftjoin('locations','locations.location_id','transactiondt_locationId')

            ->select('transaction_dtsns.*', 'transaction_dtsns.date_modified as date_modified', 'modificationData.user_name as mofication_user',)
            ->where([
                ['transaction_dtsns.transactiondt_id', $transactionId],
                ['transaction_dtsns.transaction_index', $index],
            ]);
        //   if($modificationType != 'Delete'){
        $items->orwhere(
            [
                ['transaction_dtsns.transactiondt_id', $transactionId],
                ['transaction_dtsns.transaction_index', $previousIndex]
            ]
        );
        //    }

        $items->wherebetween('transaction_dtsns.date_modified', [$dateFrom, $dateTo])
            ->orderby('transactiondtsn_id');

        if ($userSelected != 'all') {
            $items->where('transaction_dtsns.user_modified', $userSelected);
        }
        $obj['count'] = count($items->get());
        $itemsData = $items
            // ->skip($skip)
            // ->take($take)
            ->orderBy('transaction_dtsns.date_modified', 'desc')
            ->get();
        $obj['data'] = $itemsData;
        return ApiController::successResponse($obj, 200);
    }


    public function checkDeletetHistorySerials($transactionIndex)
    {
    }


    public function insertTransactionHistoryDataByRef($modifiedType, $reference, $userModified, $date, $type)
    {

        $transactions = transactions::where([
            ['transaction_reference', $reference],
            ['transaction_type', $type]
        ])
            ->leftjoin('clients', 'clients.client_id', 'transactions.transaction_clientId')
            ->select('transactions.*', 'client_firstname',)
            ->first()->toarray();
        $user = DB::table('users')
            ->where([
                ['id', $userModified]
            ])->first()->user_name;


        if ($transactions['clientCustomer_id']) {
            $transactions['clientCustomer_id'] = clientCustomer::where(
                [
                    ['customer_id', $transactions['clientCustomer_id']]
                ]
            )->first()->customer_name;
        }
        if ($transactions['forwarder_id']) {
            $transactions['forwarder_id'] = clientForwarder::where(
                [
                    ['clientforwarder_id', $transactions['forwarder_id']]
                ]
            )->first()->clientforwarder_name;
        }
        if ($transactions['transferTo_clientId']) {
            $transactions['transferTo_clientId'] = client::where(
                [
                    ['client_id', $transactions['transferTo_clientId']]
                ]
            )->first()->client_firstname;
        }

        $transactions['modification_type'] = $modifiedType;
        $transactions['user_modified'] = $user;
        $transactions['date_modified'] = $date;
        $transactions['transaction_clientId'] = $transactions['client_firstname'];

        unset($transactions['client_firstname']);
        $transactionIndex = DB::connection('mysql2')
            ->table('transactions')
            ->insertGetId($transactions);


        $details = transactiondttmp::leftjoin('countries', 'countries.country_id', 'transactiondttmps.transactiondttmp_countryOfOrigin')
            ->leftjoin('locations', 'locations.location_id', 'transactiondttmps.transactiondttmp_locationid')
            ->leftjoin('items', 'items.item_id', 'transactiondttmps.item_id')
            ->where('transactiontmp_id', $transactions['transaction_id'])
            ->select('transactiondttmps.*', 'country_name', 'location_name', 'item_code')
            ->get();

        // start dt
        foreach ($details as $detailsSplit) {

            $detailsSplit->user_modified = $user;
            $detailsSplit->date_modified = $date;
            $detailsSplit->modification_type = $modifiedType;
            if ($detailsSplit->state == 'deleted') {
                $detailsSplit->modification_type = 'Delete';
            }


            $detailsSplit->transactiondt_countryOfOrigin = $detailsSplit->country_name;
            $detailsSplit->transactiondt_locationid = $detailsSplit->location_name;
            $detailsSplit->item_id = $detailsSplit->item_code;
            $detailsSplit->transaction_index = $transactionIndex;
            $detailsSplit->transactiondt_id = $detailsSplit->transactiondttmp_id;
            $detailsSplit->transaction_id = $detailsSplit->transactiontmp_id;
            $detailsSplit->transactiondt_billOfEntry = $detailsSplit->transactiontmpdt_billOfEntry;
            $detailsSplit->transactiondt_price = $detailsSplit->transactiondttmp_price;
            $detailsSplit->transactiondt_nbOfCarton = $detailsSplit->transactiondttmp_nbOfCarton;
            $detailsSplit->transactiondt_cellMerge = $detailsSplit->transactiondttmp_cellMerge;
            $detailsSplit->transactiondt_BOE = $detailsSplit->transactiontmpdt_BOE;
            $detailsSplit->transactiondt_priceBase = $detailsSplit->transactiondttmp_priceBase;
            $detailsSplit->transactiondt_fprice = $detailsSplit->transactiondttmp_fprice;
            $detailsSplit->transactiondt_fpriceBase = $detailsSplit->transactiondttmp_fpriceBase;

            unset($detailsSplit->transactiondttmp_id);
            unset($detailsSplit->transactiontmp_id);
            unset($detailsSplit->transactiondttmp_locationid);
            unset($detailsSplit->transactiondttmp_countryOfOrigin);
            unset($detailsSplit->transactiontmpdt_billOfEntry);
            unset($detailsSplit->transactiondttmp_price);
            unset($detailsSplit->transactiondttmp_nbOfCarton);
            unset($detailsSplit->transactiondttmp_cellMerge);
            unset($detailsSplit->transactiontmpdt_BOE);
            unset($detailsSplit->transactiondttmp_priceBase);
            unset($detailsSplit->transactiondttmp_fprice);
            unset($detailsSplit->transactiondttmp_fpriceBase);
            unset($detailsSplit->country_name);
            unset($detailsSplit->location_name);
            unset($detailsSplit->item_code);
            unset($detailsSplit->id_refrence_dt);
            unset($detailsSplit->isMobile);
            unset($detailsSplit->state);


            $transactiondtIndex = DB::connection('mysql2')->table('transaction_dts')->insertGetId($detailsSplit->toArray());

            $detailsSn = transactionDtSnTmp::where([
                ['transactiondttmp_id', $detailsSplit->transactiondt_id]
            ])->get();
            $newDetailsSn = $detailsSn->map(function ($detailsSn) use ($user, $date, $modifiedType, $transactionIndex, $transactiondtIndex) {
                $detailsSn->user_modified = $user;
                $detailsSn->date_modified = $date;
                // $detail->modification_type = $modifiedType;
                $detailsSn->modification_type = $detailsSn->status != null ? ($detailsSn->status == 'New' ? 'Insert' : $detailsSn->status) : 'Insert';
                $detailsSn->transactiondtsn_id = $detailsSn->transactiondtsntmp_id;
                $detailsSn->transactiondt_id = $detailsSn->transactiondttmp_id;
                $detailsSn->file_name = '5';
                // $detail->transactiondt_locationid = $detail->location_name;
                // $detail->item_id = $detail->item_code;
                $detailsSn->transaction_index = $transactionIndex;
                // unset($detail->country_name);
                // unset($detail->location_name);
                unset($detailsSn->status);
                unset($detailsSn->transactiondttmp_id);
                unset($detailsSn->transactiondtsntmp_id);

                $detailsSn->transactiondt_index = $transactiondtIndex;


                return $detailsSn;
            });
            DB::connection('mysql2')->table('transaction_dtsns')->insert($newDetailsSn->toArray());
        }


        // end dt

        return $transactionIndex;
    }


    public function fetchNonTransactionHistory($historyType, $dateFrom, $dateTo, $search, $userSelected, $skip, $take, $referenceSelected)
    {
        $response = DB::connection('mysql2')->table($historyType)
            ->select($historyType . '.*', $historyType . '.user_modified as mofication_user', $historyType . '.client_id as user_name')
            ->wherebetween($historyType . '.date_modified', [$dateFrom, $dateTo])
            ->when($referenceSelected, function ($query) use ($referenceSelected) {
                return $query->where('item_code', $referenceSelected);
            });

        if ($userSelected != 'all') {
            $response->where($historyType . '.user_modified', $userSelected);
        }

        $obj['count'] = count($response->get());
        $responseData = $response
            ->skip($skip)
            ->take($take)
            ->orderBy($historyType . '.date_modified', 'desc')
            ->get();

        $obj['data'] = $responseData;


        return ApiController::successResponse($obj, 200);
    }
}
