<?php

namespace App\Http\Controllers\BackOffice\GoodsIn;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use File;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use JWTAuth;


class StoragePalletController extends ApiController
{
    public function insertNewStoragePallet(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'palet_no' => 'required',
            'palet_dimension' => 'required',
            'transactiontmp_id' => 'required',
        ]);
        $dim = $request->palet_dimension;
        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }
        $dimensions = explode('x', $dim);
        $activePlan = DB::table('client_storage_rent')
            ->where([
                ['active', true]
            ])
            ->orderby('id', 'desc')
            ->first();
        $palets = array(
            'length' => isset($dimensions[0]) ? $dimensions[0] : 0,
            'width' => isset($dimensions[1]) ? $dimensions[1] : 0,
            'height' => isset($dimensions[2]) ? $dimensions[2] : 1,
            'related_transaction_id' => $request->transactiontmp_id,
            'pallet_no' => $request->palet_no,
            'pallet_seq' => $request->palet_seq,
            'related_plan' => $activePlan->id
        );

        $newPalets = null;
        if ($request->paletId) {

            // $checkPalet = TransactiontmpPalets::where([
            //     ['palet_no', $request->palet_no],
            //     ['transactiontmp_id', $request->transactiontmp_id],
            //     ['palettmp_id', '!=', $request->palettmp_id]

            // ])
            //     ->first();

            // if ($checkPalet) {
            //     return ApiController::errorResponse('pallet already exist', 422);
            // }
            $newPalets = DB::table('client_storage_pallets_tmp')
                ->where('id', $request->paletId)->update($palets);
        } else {
            // $checkPalet = TransactiontmpPalets::where([
            //     ['palet_no', $request->palet_no],
            //     ['transactiontmp_id', $request->transactiontmp_id],

            // ])
            //     ->first();

            // if ($checkPalet) {
            //     return ApiController::errorResponse('pallet already exist', 422);
            // }


            $newPalets = DB::table('client_storage_pallets_tmp')
                ->insert($palets);
        }


        $palets = DB::table('client_storage_pallets_tmp')
            ->where([
                ['related_transaction_id', $request->transactiontmp_id]
            ])
            ->select('*', DB::raw('CONCAT(length, "x", width, "x", height) as palet_dimension'))
            ->get();


        $transactionTmp = DB::table('transactiontmps')
            ->where([
                ['transactiontmp_id', $request->transactiontmp_id]
            ])
            ->first();


        $obj['palets'] = $palets;
        $obj['totalPallet'] = 1;
        return ApiController::successResponse($obj, 200);
    }

    public function fetchStoragePallets(Request $request)
    {

        $palets = DB::table('client_storage_pallets_tmp')
            ->where([
                ['related_transaction_id', $request->transactionid]
            ])
            ->select('*', DB::raw('CONCAT(length, "x", width, "x", height) as palet_dimension'))
            ->get();

        $utilitiesController = new UtilitiesController();
        $clientId = DB::table('transactiontmps')
            ->where('transactiontmp_id', $request->transactionid)
            ->first()->transactiontmp_clientId;
        $activePlans = $utilitiesController->checkActivePlan($clientId);


        $obj['palets'] = $palets;
        $obj['totalPallet'] = 1;
        $obj['activePlans'] = $activePlans;
        return ApiController::successResponse($obj, 200);
    }

    public function removeStoragePallet(Request $request)
    {

        $palets = DB::table('client_storage_pallets_tmp')
            ->where([
                ['id', $request->PalletId]
            ])
            ->delete();


        return ApiController::successResponse($palets, 200);
    }
}
