<?php

namespace App\Http\Controllers\BackOffice\Client;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class ClientStorageController extends ApiController
{
    public function fetchClientStorage(Request $request)
    {
        $loggerCompanyId = auth()->user()->company_id;
        $searchValue = $request->searchValue;
        $take = $request->take;
        $skip = $request->skip;
        $clientId = $request->clientId;

        $clients = DB::table('client_storage_rent')
            ->leftjoin('currency', 'currency.currency_id', 'client_storage_rent.unit_cost')
            // ->leftjoin('client_storage_pallets', 'client_storage_pallets.related_plan', 'client_storage_rent.id')
            ->where([
                ['related_client_id', $clientId],
            ])
            ->select('*', 'active as edit')
            ->selectRaw(DB::raw(" FROM_UNIXTIME(client_storage_rent.date_from, '%d-%m-%Y') AS date_from"))
            ->selectRaw(DB::raw(" FROM_UNIXTIME(client_storage_rent.date_to, '%Y-%m-%d') AS date_from_formatted"))
            ->selectRaw(DB::raw(" FROM_UNIXTIME(client_storage_rent.date_to, '%d-%m-%Y') AS date_to"))
            ->selectRaw(DB::raw(" FROM_UNIXTIME(client_storage_rent.date_to, '%Y-%m-%d') AS date_to_formatted"))
            ->orderBy('active', 'desc')
            ->orderBy('date_to', 'desc');

        $count = $clients->count();
        $clients = $clients->skip($skip)
            ->take($take)
            ->get();
        $clients->each(function ($clients, $clientId) {
            $utilitiesController = new UtilitiesController();
            $clients->charges = $utilitiesController->getChargesStorage($clientId, $clients);
            // if($clients->storage_type='daily'){
            //     $clients->charges = $clients->length * $clients->width * $clients->height * $clients->cost;
            // }else{
            //     $clients->charges = $clients->cost;
            // }

        });

        $utilitiesController = new UtilitiesController();
        $activePlans = $utilitiesController->checkActivePlan($clientId);
        //$charges = $utilitiesController->getChargesStorage($clientId);
        $response = array();
        $response['data'] = $clients;
        $response['isActivePlan'] = $activePlans;
        $response['count'] = $count;
        //   $response['charges'] = $charges;
        return ApiController::successResponse($response, 200);
    }


    public function insertClientStorage(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'storageType' => 'required',
            'dateFrom' => 'required',
            'dateTo' => 'required',
            'cost' => 'required',
            'unitCost' => 'required',
        ]);

        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }


        $utilitiesController = new UtilitiesController();


        $client = array(
            'storage_type' => $request->storageType,
            'date_from' => $utilitiesController->convertTodayToTimetsamp($request->dateFrom . "" . date('H:i:s')),
            'date_to' => $utilitiesController->convertTodayToTimetsamp($request->dateTo . "" . date('H:i:s')),
            'cost' => $request->cost,
            'related_client_id' => $request->clientId,
            'unit_cost' => $request->unitCost,
            'active' => 1,

        );


        $newClient = DB::table('client_storage_rent')->insert($client);
        if ($newClient) {
            return ApiController::successResponse($newClient, 200);
        }
        return ApiController::errorResponse($validator->errors(), 422);
    }

    public function updateClientStorage(Request $request)
    {
        $validator = Validator::make($request->all(), [
            // 'clientFirstName' => 'required',
            // 'clientLastName' => 'required',
            // 'clientCountry' => 'required',
            // 'clientContact' => 'required',
            // 'clientPhone' => 'required',
            // 'clientEmail' => 'required'
        ]);

        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }


        $utilitiesController = new UtilitiesController();


        $client = array(
            'storage_type' => $request->storageType,
            'date_from' => $utilitiesController->convertTodayToTimetsamp($request->dateFrom . "" . date('H:i:s')),
            'date_to' => $utilitiesController->convertTodayToTimetsamp($request->dateTo . "" . date('H:i:s')),
            'cost' => $request->cost,
            'unit_cost' => $request->unitCost,
            'active' => 1,
        );

        $updateClient = DB::table('client_storage_rent')->where('id', $request->id)
            ->update($client);

        if ($updateClient) {

            return ApiController::successResponse($updateClient, 200);
        }
        return ApiController::errorResponse($validator->errors(), 200);
    }
}
